/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStudiosResponse extends EmrResponse implements
        ToCopyableBuilder<ListStudiosResponse.Builder, ListStudiosResponse> {
    private static final SdkField<List<StudioSummary>> STUDIOS_FIELD = SdkField
            .<List<StudioSummary>> builder(MarshallingType.LIST)
            .memberName("Studios")
            .getter(getter(ListStudiosResponse::studios))
            .setter(setter(Builder::studios))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Studios").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StudioSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StudioSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListStudiosResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIOS_FIELD, MARKER_FIELD));

    private final List<StudioSummary> studios;

    private final String marker;

    private ListStudiosResponse(BuilderImpl builder) {
        super(builder);
        this.studios = builder.studios;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Studios property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStudios() {
        return studios != null && !(studios instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Studio summary objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStudios} method.
     * </p>
     * 
     * @return The list of Studio summary objects.
     */
    public final List<StudioSummary> studios() {
        return studios;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStudios() ? studios() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudiosResponse)) {
            return false;
        }
        ListStudiosResponse other = (ListStudiosResponse) obj;
        return hasStudios() == other.hasStudios() && Objects.equals(studios(), other.studios())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStudiosResponse").add("Studios", hasStudios() ? studios() : null).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Studios":
            return Optional.ofNullable(clazz.cast(studios()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudiosResponse, T> g) {
        return obj -> g.apply((ListStudiosResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStudiosResponse> {
        /**
         * <p>
         * The list of Studio summary objects.
         * </p>
         * 
         * @param studios
         *        The list of Studio summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studios(Collection<StudioSummary> studios);

        /**
         * <p>
         * The list of Studio summary objects.
         * </p>
         * 
         * @param studios
         *        The list of Studio summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studios(StudioSummary... studios);

        /**
         * <p>
         * The list of Studio summary objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StudioSummary>.Builder} avoiding the need
         * to create one manually via {@link List<StudioSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StudioSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #studios(List<StudioSummary>)}.
         * 
         * @param studios
         *        a consumer that will call methods on {@link List<StudioSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studios(List<StudioSummary>)
         */
        Builder studios(Consumer<StudioSummary.Builder>... studios);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<StudioSummary> studios = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudiosResponse model) {
            super(model);
            studios(model.studios);
            marker(model.marker);
        }

        public final List<StudioSummary.Builder> getStudios() {
            List<StudioSummary.Builder> result = StudioSummaryListCopier.copyToBuilder(this.studios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudios(Collection<StudioSummary.BuilderImpl> studios) {
            this.studios = StudioSummaryListCopier.copyFromBuilder(studios);
        }

        @Override
        @Transient
        public final Builder studios(Collection<StudioSummary> studios) {
            this.studios = StudioSummaryListCopier.copy(studios);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studios(StudioSummary... studios) {
            studios(Arrays.asList(studios));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studios(Consumer<StudioSummary.Builder>... studios) {
            studios(Stream.of(studios).map(c -> StudioSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListStudiosResponse build() {
            return new ListStudiosResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
