/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditions that trigger an automatic scaling activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingTrigger implements SdkPojo, Serializable, ToCopyableBuilder<ScalingTrigger.Builder, ScalingTrigger> {
    private static final SdkField<CloudWatchAlarmDefinition> CLOUD_WATCH_ALARM_DEFINITION_FIELD = SdkField
            .<CloudWatchAlarmDefinition> builder(MarshallingType.SDK_POJO).memberName("CloudWatchAlarmDefinition")
            .getter(getter(ScalingTrigger::cloudWatchAlarmDefinition)).setter(setter(Builder::cloudWatchAlarmDefinition))
            .constructor(CloudWatchAlarmDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchAlarmDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_WATCH_ALARM_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchAlarmDefinition cloudWatchAlarmDefinition;

    private ScalingTrigger(BuilderImpl builder) {
        this.cloudWatchAlarmDefinition = builder.cloudWatchAlarmDefinition;
    }

    /**
     * <p>
     * The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with other trigger
     * parameters, scaling activity begins.
     * </p>
     * 
     * @return The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with other
     *         trigger parameters, scaling activity begins.
     */
    public final CloudWatchAlarmDefinition cloudWatchAlarmDefinition() {
        return cloudWatchAlarmDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchAlarmDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingTrigger)) {
            return false;
        }
        ScalingTrigger other = (ScalingTrigger) obj;
        return Objects.equals(cloudWatchAlarmDefinition(), other.cloudWatchAlarmDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingTrigger").add("CloudWatchAlarmDefinition", cloudWatchAlarmDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchAlarmDefinition":
            return Optional.ofNullable(clazz.cast(cloudWatchAlarmDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingTrigger, T> g) {
        return obj -> g.apply((ScalingTrigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingTrigger> {
        /**
         * <p>
         * The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with other
         * trigger parameters, scaling activity begins.
         * </p>
         * 
         * @param cloudWatchAlarmDefinition
         *        The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with
         *        other trigger parameters, scaling activity begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinition cloudWatchAlarmDefinition);

        /**
         * <p>
         * The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with other
         * trigger parameters, scaling activity begins.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchAlarmDefinition.Builder} avoiding the
         * need to create one manually via {@link CloudWatchAlarmDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchAlarmDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchAlarmDefinition(CloudWatchAlarmDefinition)}.
         * 
         * @param cloudWatchAlarmDefinition
         *        a consumer that will call methods on {@link CloudWatchAlarmDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchAlarmDefinition(CloudWatchAlarmDefinition)
         */
        default Builder cloudWatchAlarmDefinition(Consumer<CloudWatchAlarmDefinition.Builder> cloudWatchAlarmDefinition) {
            return cloudWatchAlarmDefinition(CloudWatchAlarmDefinition.builder().applyMutation(cloudWatchAlarmDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchAlarmDefinition cloudWatchAlarmDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingTrigger model) {
            cloudWatchAlarmDefinition(model.cloudWatchAlarmDefinition);
        }

        public final CloudWatchAlarmDefinition.Builder getCloudWatchAlarmDefinition() {
            return cloudWatchAlarmDefinition != null ? cloudWatchAlarmDefinition.toBuilder() : null;
        }

        public final void setCloudWatchAlarmDefinition(CloudWatchAlarmDefinition.BuilderImpl cloudWatchAlarmDefinition) {
            this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition != null ? cloudWatchAlarmDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinition cloudWatchAlarmDefinition) {
            this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
            return this;
        }

        @Override
        public ScalingTrigger build() {
            return new ScalingTrigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
