/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for an Amazon EMR Studio session mapping including creation time, user or group ID, Studio ID, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionMappingDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionMappingDetail.Builder, SessionMappingDetail> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioId").getter(getter(SessionMappingDetail::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(SessionMappingDetail::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityName").getter(getter(SessionMappingDetail::identityName)).setter(setter(Builder::identityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(SessionMappingDetail::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> SESSION_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionPolicyArn").getter(getter(SessionMappingDetail::sessionPolicyArn))
            .setter(setter(Builder::sessionPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionPolicyArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(SessionMappingDetail::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(SessionMappingDetail::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD,
            IDENTITY_ID_FIELD, IDENTITY_NAME_FIELD, IDENTITY_TYPE_FIELD, SESSION_POLICY_ARN_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String studioId;

    private final String identityId;

    private final String identityName;

    private final String identityType;

    private final String sessionPolicyArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private SessionMappingDetail(BuilderImpl builder) {
        this.studioId = builder.studioId;
        this.identityId = builder.identityId;
        this.identityName = builder.identityName;
        this.identityType = builder.identityType;
        this.sessionPolicyArn = builder.sessionPolicyArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio.
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * The globally unique identifier (GUID) of the user or group.
     * </p>
     * 
     * @return The globally unique identifier (GUID) of the user or group.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * <p>
     * The name of the user or group. For more information, see <a href=
     * "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName"
     * >UserName</a> and <a href=
     * "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName"
     * >DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
     * </p>
     * 
     * @return The name of the user or group. For more information, see <a href=
     *         "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName"
     *         >UserName</a> and <a href=
     *         "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName"
     *         >DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
     */
    public final String identityName() {
        return identityName;
    }

    /**
     * <p>
     * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session policy associated with the user or group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session policy associated with the user or group.
     */
    public final String sessionPolicyArn() {
        return sessionPolicyArn;
    }

    /**
     * <p>
     * The time the session mapping was created.
     * </p>
     * 
     * @return The time the session mapping was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the session mapping was last modified.
     * </p>
     * 
     * @return The time the session mapping was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(identityName());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionMappingDetail)) {
            return false;
        }
        SessionMappingDetail other = (SessionMappingDetail) obj;
        return Objects.equals(studioId(), other.studioId()) && Objects.equals(identityId(), other.identityId())
                && Objects.equals(identityName(), other.identityName())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(sessionPolicyArn(), other.sessionPolicyArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionMappingDetail").add("StudioId", studioId()).add("IdentityId", identityId())
                .add("IdentityName", identityName()).add("IdentityType", identityTypeAsString())
                .add("SessionPolicyArn", sessionPolicyArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "IdentityName":
            return Optional.ofNullable(clazz.cast(identityName()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "SessionPolicyArn":
            return Optional.ofNullable(clazz.cast(sessionPolicyArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionMappingDetail, T> g) {
        return obj -> g.apply((SessionMappingDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionMappingDetail> {
        /**
         * <p>
         * The ID of the Amazon EMR Studio.
         * </p>
         * 
         * @param studioId
         *        The ID of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * The globally unique identifier (GUID) of the user or group.
         * </p>
         * 
         * @param identityId
         *        The globally unique identifier (GUID) of the user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * The name of the user or group. For more information, see <a href=
         * "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName"
         * >UserName</a> and <a href=
         * "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName"
         * >DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
         * </p>
         * 
         * @param identityName
         *        The name of the user or group. For more information, see <a href=
         *        "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName"
         *        >UserName</a> and <a href=
         *        "https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName"
         *        >DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityName(String identityName);

        /**
         * <p>
         * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         * </p>
         * 
         * @param identityType
         *        Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         * </p>
         * 
         * @param identityType
         *        Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session policy associated with the user or group.
         * </p>
         * 
         * @param sessionPolicyArn
         *        The Amazon Resource Name (ARN) of the session policy associated with the user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionPolicyArn(String sessionPolicyArn);

        /**
         * <p>
         * The time the session mapping was created.
         * </p>
         * 
         * @param creationTime
         *        The time the session mapping was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the session mapping was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time the session mapping was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String studioId;

        private String identityId;

        private String identityName;

        private String identityType;

        private String sessionPolicyArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionMappingDetail model) {
            studioId(model.studioId);
            identityId(model.identityId);
            identityName(model.identityName);
            identityType(model.identityType);
            sessionPolicyArn(model.sessionPolicyArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        @Transient
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getIdentityName() {
            return identityName;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        @Override
        @Transient
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        @Transient
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        @Transient
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getSessionPolicyArn() {
            return sessionPolicyArn;
        }

        public final void setSessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
        }

        @Override
        @Transient
        public final Builder sessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public SessionMappingDetail build() {
            return new SessionMappingDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
