/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Policy for customizing shrink operations. Allows configuration of decommissioning timeout and targeted instance
 * shrinking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShrinkPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ShrinkPolicy.Builder, ShrinkPolicy> {
    private static final SdkField<Integer> DECOMMISSION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DecommissionTimeout").getter(getter(ShrinkPolicy::decommissionTimeout))
            .setter(setter(Builder::decommissionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecommissionTimeout").build())
            .build();

    private static final SdkField<InstanceResizePolicy> INSTANCE_RESIZE_POLICY_FIELD = SdkField
            .<InstanceResizePolicy> builder(MarshallingType.SDK_POJO).memberName("InstanceResizePolicy")
            .getter(getter(ShrinkPolicy::instanceResizePolicy)).setter(setter(Builder::instanceResizePolicy))
            .constructor(InstanceResizePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceResizePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECOMMISSION_TIMEOUT_FIELD,
            INSTANCE_RESIZE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer decommissionTimeout;

    private final InstanceResizePolicy instanceResizePolicy;

    private ShrinkPolicy(BuilderImpl builder) {
        this.decommissionTimeout = builder.decommissionTimeout;
        this.instanceResizePolicy = builder.instanceResizePolicy;
    }

    /**
     * <p>
     * The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning timeout.
     * </p>
     * 
     * @return The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning timeout.
     */
    public final Integer decommissionTimeout() {
        return decommissionTimeout;
    }

    /**
     * <p>
     * Custom policy for requesting termination protection or termination of specific instances when shrinking an
     * instance group.
     * </p>
     * 
     * @return Custom policy for requesting termination protection or termination of specific instances when shrinking
     *         an instance group.
     */
    public final InstanceResizePolicy instanceResizePolicy() {
        return instanceResizePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decommissionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(instanceResizePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShrinkPolicy)) {
            return false;
        }
        ShrinkPolicy other = (ShrinkPolicy) obj;
        return Objects.equals(decommissionTimeout(), other.decommissionTimeout())
                && Objects.equals(instanceResizePolicy(), other.instanceResizePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShrinkPolicy").add("DecommissionTimeout", decommissionTimeout())
                .add("InstanceResizePolicy", instanceResizePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecommissionTimeout":
            return Optional.ofNullable(clazz.cast(decommissionTimeout()));
        case "InstanceResizePolicy":
            return Optional.ofNullable(clazz.cast(instanceResizePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShrinkPolicy, T> g) {
        return obj -> g.apply((ShrinkPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShrinkPolicy> {
        /**
         * <p>
         * The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning timeout.
         * </p>
         * 
         * @param decommissionTimeout
         *        The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning
         *        timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decommissionTimeout(Integer decommissionTimeout);

        /**
         * <p>
         * Custom policy for requesting termination protection or termination of specific instances when shrinking an
         * instance group.
         * </p>
         * 
         * @param instanceResizePolicy
         *        Custom policy for requesting termination protection or termination of specific instances when
         *        shrinking an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceResizePolicy(InstanceResizePolicy instanceResizePolicy);

        /**
         * <p>
         * Custom policy for requesting termination protection or termination of specific instances when shrinking an
         * instance group.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceResizePolicy.Builder} avoiding the need
         * to create one manually via {@link InstanceResizePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceResizePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceResizePolicy(InstanceResizePolicy)}.
         * 
         * @param instanceResizePolicy
         *        a consumer that will call methods on {@link InstanceResizePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceResizePolicy(InstanceResizePolicy)
         */
        default Builder instanceResizePolicy(Consumer<InstanceResizePolicy.Builder> instanceResizePolicy) {
            return instanceResizePolicy(InstanceResizePolicy.builder().applyMutation(instanceResizePolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer decommissionTimeout;

        private InstanceResizePolicy instanceResizePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ShrinkPolicy model) {
            decommissionTimeout(model.decommissionTimeout);
            instanceResizePolicy(model.instanceResizePolicy);
        }

        public final Integer getDecommissionTimeout() {
            return decommissionTimeout;
        }

        public final void setDecommissionTimeout(Integer decommissionTimeout) {
            this.decommissionTimeout = decommissionTimeout;
        }

        @Override
        @Transient
        public final Builder decommissionTimeout(Integer decommissionTimeout) {
            this.decommissionTimeout = decommissionTimeout;
            return this;
        }

        public final InstanceResizePolicy.Builder getInstanceResizePolicy() {
            return instanceResizePolicy != null ? instanceResizePolicy.toBuilder() : null;
        }

        public final void setInstanceResizePolicy(InstanceResizePolicy.BuilderImpl instanceResizePolicy) {
            this.instanceResizePolicy = instanceResizePolicy != null ? instanceResizePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceResizePolicy(InstanceResizePolicy instanceResizePolicy) {
            this.instanceResizePolicy = instanceResizePolicy;
            return this;
        }

        @Override
        public ShrinkPolicy build() {
            return new ShrinkPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
