/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This represents a step in a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Step::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Step::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<HadoopStepConfig> CONFIG_FIELD = SdkField.<HadoopStepConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Config").getter(getter(Step::config)).setter(setter(Builder::config))
            .constructor(HadoopStepConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()).build();

    private static final SdkField<String> ACTION_ON_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionOnFailure").getter(getter(Step::actionOnFailureAsString)).setter(setter(Builder::actionOnFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOnFailure").build()).build();

    private static final SdkField<StepStatus> STATUS_FIELD = SdkField.<StepStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(Step::status)).setter(setter(Builder::status)).constructor(StepStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CONFIG_FIELD, ACTION_ON_FAILURE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final HadoopStepConfig config;

    private final String actionOnFailure;

    private final StepStatus status;

    private Step(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
        this.actionOnFailure = builder.actionOnFailure;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the cluster step.
     * </p>
     * 
     * @return The identifier of the cluster step.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the cluster step.
     * </p>
     * 
     * @return The name of the cluster step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Hadoop job configuration of the cluster step.
     * </p>
     * 
     * @return The Hadoop job configuration of the cluster step.
     */
    public final HadoopStepConfig config() {
        return config;
    }

    /**
     * <p>
     * The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
     * <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward
     * compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.
     * </p>
     * <p>
     * If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
     * <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
     * <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
     * <code>ActionOnFailure</code> setting is not valid.
     * </p>
     * <p>
     * If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the
     * <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with
     * this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a
     * step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnFailure}
     * will return {@link ActionOnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionOnFailureAsString}.
     * </p>
     * 
     * @return The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
     *         <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for
     *         backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
     *         <p>
     *         If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
     *         <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
     *         <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
     *         <code>ActionOnFailure</code> setting is not valid.
     *         </p>
     *         <p>
     *         If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running,
     *         the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that
     *         fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not
     *         canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster
     *         does not terminate.
     * @see ActionOnFailure
     */
    public final ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(actionOnFailure);
    }

    /**
     * <p>
     * The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
     * <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward
     * compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.
     * </p>
     * <p>
     * If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
     * <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
     * <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
     * <code>ActionOnFailure</code> setting is not valid.
     * </p>
     * <p>
     * If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the
     * <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with
     * this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a
     * step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnFailure}
     * will return {@link ActionOnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionOnFailureAsString}.
     * </p>
     * 
     * @return The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
     *         <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for
     *         backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
     *         <p>
     *         If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
     *         <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
     *         <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
     *         <code>ActionOnFailure</code> setting is not valid.
     *         </p>
     *         <p>
     *         If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running,
     *         the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that
     *         fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not
     *         canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster
     *         does not terminate.
     * @see ActionOnFailure
     */
    public final String actionOnFailureAsString() {
        return actionOnFailure;
    }

    /**
     * <p>
     * The current execution status details of the cluster step.
     * </p>
     * 
     * @return The current execution status details of the cluster step.
     */
    public final StepStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(actionOnFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(config(), other.config())
                && Objects.equals(actionOnFailureAsString(), other.actionOnFailureAsString())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Step").add("Id", id()).add("Name", name()).add("Config", config())
                .add("ActionOnFailure", actionOnFailureAsString()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "ActionOnFailure":
            return Optional.ofNullable(clazz.cast(actionOnFailureAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * The identifier of the cluster step.
         * </p>
         * 
         * @param id
         *        The identifier of the cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the cluster step.
         * </p>
         * 
         * @param name
         *        The name of the cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Hadoop job configuration of the cluster step.
         * </p>
         * 
         * @param config
         *        The Hadoop job configuration of the cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HadoopStepConfig config);

        /**
         * <p>
         * The Hadoop job configuration of the cluster step.
         * </p>
         * This is a convenience that creates an instance of the {@link HadoopStepConfig.Builder} avoiding the need to
         * create one manually via {@link HadoopStepConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HadoopStepConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(HadoopStepConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link HadoopStepConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(HadoopStepConfig)
         */
        default Builder config(Consumer<HadoopStepConfig.Builder> config) {
            return config(HadoopStepConfig.builder().applyMutation(config).build());
        }

        /**
         * <p>
         * The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
         * <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for
         * backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.
         * </p>
         * <p>
         * If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
         * <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
         * <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
         * <code>ActionOnFailure</code> setting is not valid.
         * </p>
         * <p>
         * If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the
         * <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with
         * this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for
         * a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.
         * </p>
         * 
         * @param actionOnFailure
         *        The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
         *        <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided
         *        for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
         *        <p>
         *        If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
         *        <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code>
         *        or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that
         *        the <code>ActionOnFailure</code> setting is not valid.
         *        </p>
         *        <p>
         *        If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is
         *        running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a
         *        step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running
         *        step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>
         *        , the cluster does not terminate.
         * @see ActionOnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOnFailure
         */
        Builder actionOnFailure(String actionOnFailure);

        /**
         * <p>
         * The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
         * <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for
         * backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.
         * </p>
         * <p>
         * If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
         * <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or
         * <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the
         * <code>ActionOnFailure</code> setting is not valid.
         * </p>
         * <p>
         * If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the
         * <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with
         * this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for
         * a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.
         * </p>
         * 
         * @param actionOnFailure
         *        The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>,
         *        <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided
         *        for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p>
         *        <p>
         *        If a cluster's <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use
         *        <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code>
         *        or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that
         *        the <code>ActionOnFailure</code> setting is not valid.
         *        </p>
         *        <p>
         *        If you change a cluster's <code>StepConcurrencyLevel</code> to be greater than 1 while a step is
         *        running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a
         *        step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running
         *        step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>
         *        , the cluster does not terminate.
         * @see ActionOnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOnFailure
         */
        Builder actionOnFailure(ActionOnFailure actionOnFailure);

        /**
         * <p>
         * The current execution status details of the cluster step.
         * </p>
         * 
         * @param status
         *        The current execution status details of the cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(StepStatus status);

        /**
         * <p>
         * The current execution status details of the cluster step.
         * </p>
         * This is a convenience that creates an instance of the {@link StepStatus.Builder} avoiding the need to create
         * one manually via {@link StepStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link StepStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #status(StepStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link StepStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(StepStatus)
         */
        default Builder status(Consumer<StepStatus.Builder> status) {
            return status(StepStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private HadoopStepConfig config;

        private String actionOnFailure;

        private StepStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            id(model.id);
            name(model.name);
            config(model.config);
            actionOnFailure(model.actionOnFailure);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HadoopStepConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(HadoopStepConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        @Transient
        public final Builder config(HadoopStepConfig config) {
            this.config = config;
            return this;
        }

        public final String getActionOnFailure() {
            return actionOnFailure;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        @Override
        @Transient
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        @Transient
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure == null ? null : actionOnFailure.toString());
            return this;
        }

        public final StepStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(StepStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(StepStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
