/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
 * attached to an EC2 instance in the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeSpecification.Builder, VolumeSpecification> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(VolumeSpecification::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(VolumeSpecification::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInGB").getter(getter(VolumeSpecification::sizeInGB)).setter(setter(Builder::sizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD, IOPS_FIELD,
            SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeType;

    private final Integer iops;

    private final Integer sizeInGB;

    private VolumeSpecification(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.sizeInGB = builder.sizeInGB;
    }

    /**
     * <p>
     * The volume type. Volume types supported are gp2, io1, standard.
     * </p>
     * 
     * @return The volume type. Volume types supported are gp2, io1, standard.
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) that the volume supports.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) that the volume supports.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the
     * minimum value is 10.
     * </p>
     * 
     * @return The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is
     *         EBS-optimized, the minimum value is 10.
     */
    public final Integer sizeInGB() {
        return sizeInGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeSpecification)) {
            return false;
        }
        VolumeSpecification other = (VolumeSpecification) obj;
        return Objects.equals(volumeType(), other.volumeType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(sizeInGB(), other.sizeInGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeSpecification").add("VolumeType", volumeType()).add("Iops", iops())
                .add("SizeInGB", sizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "SizeInGB":
            return Optional.ofNullable(clazz.cast(sizeInGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeSpecification, T> g) {
        return obj -> g.apply((VolumeSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeSpecification> {
        /**
         * <p>
         * The volume type. Volume types supported are gp2, io1, standard.
         * </p>
         * 
         * @param volumeType
         *        The volume type. Volume types supported are gp2, io1, standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) that the volume supports.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) that the volume supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized,
         * the minimum value is 10.
         * </p>
         * 
         * @param sizeInGB
         *        The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is
         *        EBS-optimized, the minimum value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGB(Integer sizeInGB);
    }

    static final class BuilderImpl implements Builder {
        private String volumeType;

        private Integer iops;

        private Integer sizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeSpecification model) {
            volumeType(model.volumeType);
            iops(model.iops);
            sizeInGB(model.sizeInGB);
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        @Transient
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getSizeInGB() {
            return sizeInGB;
        }

        public final void setSizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        @Override
        @Transient
        public final Builder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        @Override
        public VolumeSpecification build() {
            return new VolumeSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
