/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of an automatic scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingPolicyStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingPolicyStatus.Builder, AutoScalingPolicyStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AutoScalingPolicyStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<AutoScalingPolicyStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<AutoScalingPolicyStateChangeReason> builder(MarshallingType.SDK_POJO).memberName("StateChangeReason")
            .getter(getter(AutoScalingPolicyStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .constructor(AutoScalingPolicyStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final AutoScalingPolicyStateChangeReason stateChangeReason;

    private AutoScalingPolicyStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    /**
     * <p>
     * Indicates the status of the automatic scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AutoScalingPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the status of the automatic scaling policy.
     * @see AutoScalingPolicyState
     */
    public final AutoScalingPolicyState state() {
        return AutoScalingPolicyState.fromValue(state);
    }

    /**
     * <p>
     * Indicates the status of the automatic scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AutoScalingPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the status of the automatic scaling policy.
     * @see AutoScalingPolicyState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for a change in status.
     * </p>
     * 
     * @return The reason for a change in status.
     */
    public final AutoScalingPolicyStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyStatus)) {
            return false;
        }
        AutoScalingPolicyStatus other = (AutoScalingPolicyStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingPolicyStatus").add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicyStatus, T> g) {
        return obj -> g.apply((AutoScalingPolicyStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingPolicyStatus> {
        /**
         * <p>
         * Indicates the status of the automatic scaling policy.
         * </p>
         * 
         * @param state
         *        Indicates the status of the automatic scaling policy.
         * @see AutoScalingPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingPolicyState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates the status of the automatic scaling policy.
         * </p>
         * 
         * @param state
         *        Indicates the status of the automatic scaling policy.
         * @see AutoScalingPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingPolicyState
         */
        Builder state(AutoScalingPolicyState state);

        /**
         * <p>
         * The reason for a change in status.
         * </p>
         * 
         * @param stateChangeReason
         *        The reason for a change in status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason);

        /**
         * <p>
         * The reason for a change in status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoScalingPolicyStateChangeReason.Builder} avoiding the need to create one manually via
         * {@link AutoScalingPolicyStateChangeReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingPolicyStateChangeReason.Builder#build()} is called
         * immediately and its result is passed to {@link #stateChangeReason(AutoScalingPolicyStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link AutoScalingPolicyStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(AutoScalingPolicyStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<AutoScalingPolicyStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(AutoScalingPolicyStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private AutoScalingPolicyStateChangeReason stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoScalingPolicyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AutoScalingPolicyStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(AutoScalingPolicyStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        @Override
        public AutoScalingPolicyStatus build() {
            return new AutoScalingPolicyStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
