/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReleaseLabelResponse extends EmrResponse implements
        ToCopyableBuilder<DescribeReleaseLabelResponse.Builder, DescribeReleaseLabelResponse> {
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseLabel").getter(getter(DescribeReleaseLabelResponse::releaseLabel))
            .setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()).build();

    private static final SdkField<List<SimplifiedApplication>> APPLICATIONS_FIELD = SdkField
            .<List<SimplifiedApplication>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(DescribeReleaseLabelResponse::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimplifiedApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimplifiedApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReleaseLabelResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_LABEL_FIELD,
            APPLICATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final String releaseLabel;

    private final List<SimplifiedApplication> applications;

    private final String nextToken;

    private DescribeReleaseLabelResponse(BuilderImpl builder) {
        super(builder);
        this.releaseLabel = builder.releaseLabel;
        this.applications = builder.applications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The target release label described in the response.
     * </p>
     * 
     * @return The target release label described in the response.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of applications available for the target release label. <code>Name</code> is the name of the
     * application. <code>Version</code> is the concise version of the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return The list of applications available for the target release label. <code>Name</code> is the name of the
     *         application. <code>Version</code> is the concise version of the application.
     */
    public final List<SimplifiedApplication> applications() {
        return applications;
    }

    /**
     * <p>
     * The pagination token. Reserved for future use. Currently set to null.
     * </p>
     * 
     * @return The pagination token. Reserved for future use. Currently set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReleaseLabelResponse)) {
            return false;
        }
        DescribeReleaseLabelResponse other = (DescribeReleaseLabelResponse) obj;
        return Objects.equals(releaseLabel(), other.releaseLabel()) && hasApplications() == other.hasApplications()
                && Objects.equals(applications(), other.applications()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReleaseLabelResponse").add("ReleaseLabel", releaseLabel())
                .add("Applications", hasApplications() ? applications() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReleaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReleaseLabelResponse, T> g) {
        return obj -> g.apply((DescribeReleaseLabelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReleaseLabelResponse> {
        /**
         * <p>
         * The target release label described in the response.
         * </p>
         * 
         * @param releaseLabel
         *        The target release label described in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The list of applications available for the target release label. <code>Name</code> is the name of the
         * application. <code>Version</code> is the concise version of the application.
         * </p>
         * 
         * @param applications
         *        The list of applications available for the target release label. <code>Name</code> is the name of the
         *        application. <code>Version</code> is the concise version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<SimplifiedApplication> applications);

        /**
         * <p>
         * The list of applications available for the target release label. <code>Name</code> is the name of the
         * application. <code>Version</code> is the concise version of the application.
         * </p>
         * 
         * @param applications
         *        The list of applications available for the target release label. <code>Name</code> is the name of the
         *        application. <code>Version</code> is the concise version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(SimplifiedApplication... applications);

        /**
         * <p>
         * The list of applications available for the target release label. <code>Name</code> is the name of the
         * application. <code>Version</code> is the concise version of the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SimplifiedApplication>.Builder}
         * avoiding the need to create one manually via {@link List<SimplifiedApplication>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimplifiedApplication>.Builder#build()} is called
         * immediately and its result is passed to {@link #applications(List<SimplifiedApplication>)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link List<SimplifiedApplication>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(List<SimplifiedApplication>)
         */
        Builder applications(Consumer<SimplifiedApplication.Builder>... applications);

        /**
         * <p>
         * The pagination token. Reserved for future use. Currently set to null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token. Reserved for future use. Currently set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String releaseLabel;

        private List<SimplifiedApplication> applications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReleaseLabelResponse model) {
            super(model);
            releaseLabel(model.releaseLabel);
            applications(model.applications);
            nextToken(model.nextToken);
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final List<SimplifiedApplication.Builder> getApplications() {
            List<SimplifiedApplication.Builder> result = SimplifiedApplicationListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<SimplifiedApplication.BuilderImpl> applications) {
            this.applications = SimplifiedApplicationListCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<SimplifiedApplication> applications) {
            this.applications = SimplifiedApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(SimplifiedApplication... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<SimplifiedApplication.Builder>... applications) {
            applications(Stream.of(applications).map(c -> SimplifiedApplication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReleaseLabelResponse build() {
            return new DescribeReleaseLabelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
