/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of requested EBS block device associated with the instance group with count of volumes that will be
 * associated to every instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsBlockDeviceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsBlockDeviceConfig.Builder, EbsBlockDeviceConfig> {
    private static final SdkField<VolumeSpecification> VOLUME_SPECIFICATION_FIELD = SdkField
            .<VolumeSpecification> builder(MarshallingType.SDK_POJO).memberName("VolumeSpecification")
            .getter(getter(EbsBlockDeviceConfig::volumeSpecification)).setter(setter(Builder::volumeSpecification))
            .constructor(VolumeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSpecification").build())
            .build();

    private static final SdkField<Integer> VOLUMES_PER_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumesPerInstance").getter(getter(EbsBlockDeviceConfig::volumesPerInstance))
            .setter(setter(Builder::volumesPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumesPerInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SPECIFICATION_FIELD,
            VOLUMES_PER_INSTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final VolumeSpecification volumeSpecification;

    private final Integer volumesPerInstance;

    private EbsBlockDeviceConfig(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.volumesPerInstance = builder.volumesPerInstance;
    }

    /**
     * <p>
     * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
     * attached to an EC2 instance in the cluster.
     * </p>
     * 
     * @return EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS
     *         volume attached to an EC2 instance in the cluster.
     */
    public final VolumeSpecification volumeSpecification() {
        return volumeSpecification;
    }

    /**
     * <p>
     * Number of EBS volumes with a specific volume configuration that will be associated with every instance in the
     * instance group
     * </p>
     * 
     * @return Number of EBS volumes with a specific volume configuration that will be associated with every instance in
     *         the instance group
     */
    public final Integer volumesPerInstance() {
        return volumesPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(volumesPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDeviceConfig)) {
            return false;
        }
        EbsBlockDeviceConfig other = (EbsBlockDeviceConfig) obj;
        return Objects.equals(volumeSpecification(), other.volumeSpecification())
                && Objects.equals(volumesPerInstance(), other.volumesPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsBlockDeviceConfig").add("VolumeSpecification", volumeSpecification())
                .add("VolumesPerInstance", volumesPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeSpecification":
            return Optional.ofNullable(clazz.cast(volumeSpecification()));
        case "VolumesPerInstance":
            return Optional.ofNullable(clazz.cast(volumesPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDeviceConfig, T> g) {
        return obj -> g.apply((EbsBlockDeviceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsBlockDeviceConfig> {
        /**
         * <p>
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
         * attached to an EC2 instance in the cluster.
         * </p>
         * 
         * @param volumeSpecification
         *        EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS
         *        volume attached to an EC2 instance in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSpecification(VolumeSpecification volumeSpecification);

        /**
         * <p>
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
         * attached to an EC2 instance in the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeSpecification.Builder} avoiding the
         * need to create one manually via {@link VolumeSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeSpecification(VolumeSpecification)}.
         * 
         * @param volumeSpecification
         *        a consumer that will call methods on {@link VolumeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeSpecification(VolumeSpecification)
         */
        default Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return volumeSpecification(VolumeSpecification.builder().applyMutation(volumeSpecification).build());
        }

        /**
         * <p>
         * Number of EBS volumes with a specific volume configuration that will be associated with every instance in the
         * instance group
         * </p>
         * 
         * @param volumesPerInstance
         *        Number of EBS volumes with a specific volume configuration that will be associated with every instance
         *        in the instance group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesPerInstance(Integer volumesPerInstance);
    }

    static final class BuilderImpl implements Builder {
        private VolumeSpecification volumeSpecification;

        private Integer volumesPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDeviceConfig model) {
            volumeSpecification(model.volumeSpecification);
            volumesPerInstance(model.volumesPerInstance);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return volumeSpecification != null ? volumeSpecification.toBuilder() : null;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final Integer getVolumesPerInstance() {
            return volumesPerInstance;
        }

        public final void setVolumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
        }

        @Override
        public final Builder volumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
            return this;
        }

        @Override
        public EbsBlockDeviceConfig build() {
            return new EbsBlockDeviceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
