/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStudioSessionMappingResponse extends EmrResponse implements
        ToCopyableBuilder<GetStudioSessionMappingResponse.Builder, GetStudioSessionMappingResponse> {
    private static final SdkField<SessionMappingDetail> SESSION_MAPPING_FIELD = SdkField
            .<SessionMappingDetail> builder(MarshallingType.SDK_POJO).memberName("SessionMapping")
            .getter(getter(GetStudioSessionMappingResponse::sessionMapping)).setter(setter(Builder::sessionMapping))
            .constructor(SessionMappingDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionMapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_MAPPING_FIELD));

    private final SessionMappingDetail sessionMapping;

    private GetStudioSessionMappingResponse(BuilderImpl builder) {
        super(builder);
        this.sessionMapping = builder.sessionMapping;
    }

    /**
     * <p>
     * The session mapping details for the specified Amazon EMR Studio and identity, including session policy ARN and
     * creation time.
     * </p>
     * 
     * @return The session mapping details for the specified Amazon EMR Studio and identity, including session policy
     *         ARN and creation time.
     */
    public final SessionMappingDetail sessionMapping() {
        return sessionMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionMapping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStudioSessionMappingResponse)) {
            return false;
        }
        GetStudioSessionMappingResponse other = (GetStudioSessionMappingResponse) obj;
        return Objects.equals(sessionMapping(), other.sessionMapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStudioSessionMappingResponse").add("SessionMapping", sessionMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionMapping":
            return Optional.ofNullable(clazz.cast(sessionMapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStudioSessionMappingResponse, T> g) {
        return obj -> g.apply((GetStudioSessionMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStudioSessionMappingResponse> {
        /**
         * <p>
         * The session mapping details for the specified Amazon EMR Studio and identity, including session policy ARN
         * and creation time.
         * </p>
         * 
         * @param sessionMapping
         *        The session mapping details for the specified Amazon EMR Studio and identity, including session policy
         *        ARN and creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionMapping(SessionMappingDetail sessionMapping);

        /**
         * <p>
         * The session mapping details for the specified Amazon EMR Studio and identity, including session policy ARN
         * and creation time.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionMappingDetail.Builder} avoiding
         * the need to create one manually via {@link SessionMappingDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionMappingDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionMapping(SessionMappingDetail)}.
         * 
         * @param sessionMapping
         *        a consumer that will call methods on {@link SessionMappingDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionMapping(SessionMappingDetail)
         */
        default Builder sessionMapping(Consumer<SessionMappingDetail.Builder> sessionMapping) {
            return sessionMapping(SessionMappingDetail.builder().applyMutation(sessionMapping).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private SessionMappingDetail sessionMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStudioSessionMappingResponse model) {
            super(model);
            sessionMapping(model.sessionMapping);
        }

        public final SessionMappingDetail.Builder getSessionMapping() {
            return sessionMapping != null ? sessionMapping.toBuilder() : null;
        }

        public final void setSessionMapping(SessionMappingDetail.BuilderImpl sessionMapping) {
            this.sessionMapping = sessionMapping != null ? sessionMapping.build() : null;
        }

        @Override
        public final Builder sessionMapping(SessionMappingDetail sessionMapping) {
            this.sessionMapping = sessionMapping;
            return this;
        }

        @Override
        public GetStudioSessionMappingResponse build() {
            return new GetStudioSessionMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
