/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityConfigurationsResponse extends EmrResponse implements
        ToCopyableBuilder<ListSecurityConfigurationsResponse.Builder, ListSecurityConfigurationsResponse> {
    private static final SdkField<List<SecurityConfigurationSummary>> SECURITY_CONFIGURATIONS_FIELD = SdkField
            .<List<SecurityConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("SecurityConfigurations")
            .getter(getter(ListSecurityConfigurationsResponse::securityConfigurations))
            .setter(setter(Builder::securityConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListSecurityConfigurationsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIGURATIONS_FIELD,
            MARKER_FIELD));

    private final List<SecurityConfigurationSummary> securityConfigurations;

    private final String marker;

    private ListSecurityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigurations = builder.securityConfigurations;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityConfigurations() {
        return securityConfigurations != null && !(securityConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The creation date and time, and name, of each security configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityConfigurations} method.
     * </p>
     * 
     * @return The creation date and time, and name, of each security configuration.
     */
    public final List<SecurityConfigurationSummary> securityConfigurations() {
        return securityConfigurations;
    }

    /**
     * <p>
     * A pagination token that indicates the next set of results to retrieve. Include the marker in the next
     * ListSecurityConfiguration call to retrieve the next page of results, if required.
     * </p>
     * 
     * @return A pagination token that indicates the next set of results to retrieve. Include the marker in the next
     *         ListSecurityConfiguration call to retrieve the next page of results, if required.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityConfigurations() ? securityConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigurationsResponse)) {
            return false;
        }
        ListSecurityConfigurationsResponse other = (ListSecurityConfigurationsResponse) obj;
        return hasSecurityConfigurations() == other.hasSecurityConfigurations()
                && Objects.equals(securityConfigurations(), other.securityConfigurations())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityConfigurationsResponse")
                .add("SecurityConfigurations", hasSecurityConfigurations() ? securityConfigurations() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityConfigurations":
            return Optional.ofNullable(clazz.cast(securityConfigurations()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSecurityConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
        /**
         * <p>
         * The creation date and time, and name, of each security configuration.
         * </p>
         * 
         * @param securityConfigurations
         *        The creation date and time, and name, of each security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations);

        /**
         * <p>
         * The creation date and time, and name, of each security configuration.
         * </p>
         * 
         * @param securityConfigurations
         *        The creation date and time, and name, of each security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigurations(SecurityConfigurationSummary... securityConfigurations);

        /**
         * <p>
         * The creation date and time, and name, of each security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <SecurityConfigurationSummary>.Builder} avoiding the need to create one manually via {@link List
         * <SecurityConfigurationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityConfigurationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityConfigurations(List<SecurityConfigurationSummary>)}.
         * 
         * @param securityConfigurations
         *        a consumer that will call methods on {@link List<SecurityConfigurationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfigurations(List<SecurityConfigurationSummary>)
         */
        Builder securityConfigurations(Consumer<SecurityConfigurationSummary.Builder>... securityConfigurations);

        /**
         * <p>
         * A pagination token that indicates the next set of results to retrieve. Include the marker in the next
         * ListSecurityConfiguration call to retrieve the next page of results, if required.
         * </p>
         * 
         * @param marker
         *        A pagination token that indicates the next set of results to retrieve. Include the marker in the next
         *        ListSecurityConfiguration call to retrieve the next page of results, if required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<SecurityConfigurationSummary> securityConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigurationsResponse model) {
            super(model);
            securityConfigurations(model.securityConfigurations);
            marker(model.marker);
        }

        public final List<SecurityConfigurationSummary.Builder> getSecurityConfigurations() {
            List<SecurityConfigurationSummary.Builder> result = SecurityConfigurationListCopier
                    .copyToBuilder(this.securityConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityConfigurations(Collection<SecurityConfigurationSummary.BuilderImpl> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copyFromBuilder(securityConfigurations);
        }

        @Override
        public final Builder securityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copy(securityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(SecurityConfigurationSummary... securityConfigurations) {
            securityConfigurations(Arrays.asList(securityConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(Consumer<SecurityConfigurationSummary.Builder>... securityConfigurations) {
            securityConfigurations(Stream.of(securityConfigurations)
                    .map(c -> SecurityConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListSecurityConfigurationsResponse build() {
            return new ListSecurityConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
