/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This output contains the list of steps returned in reverse order. This means that the last step is the first element
 * in the list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStepsResponse extends EmrResponse implements
        ToCopyableBuilder<ListStepsResponse.Builder, ListStepsResponse> {
    private static final SdkField<List<StepSummary>> STEPS_FIELD = SdkField
            .<List<StepSummary>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(ListStepsResponse::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListStepsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, MARKER_FIELD));

    private final List<StepSummary> steps;

    private final String marker;

    private ListStepsResponse(BuilderImpl builder) {
        super(builder);
        this.steps = builder.steps;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filtered list of steps for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The filtered list of steps for the cluster.
     */
    public final List<StepSummary> steps() {
        return steps;
    }

    /**
     * <p>
     * The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of
     * steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a
     * pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer
     *         list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter,
     *         which is a pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsResponse)) {
            return false;
        }
        ListStepsResponse other = (ListStepsResponse) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStepsResponse").add("Steps", hasSteps() ? steps() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStepsResponse, T> g) {
        return obj -> g.apply((ListStepsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStepsResponse> {
        /**
         * <p>
         * The filtered list of steps for the cluster.
         * </p>
         * 
         * @param steps
         *        The filtered list of steps for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<StepSummary> steps);

        /**
         * <p>
         * The filtered list of steps for the cluster.
         * </p>
         * 
         * @param steps
         *        The filtered list of steps for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(StepSummary... steps);

        /**
         * <p>
         * The filtered list of steps for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StepSummary>.Builder} avoiding the
         * need to create one manually via {@link List<StepSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<StepSummary>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<StepSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<StepSummary>)
         */
        Builder steps(Consumer<StepSummary.Builder>... steps);

        /**
         * <p>
         * The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer
         * list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter,
         * which is a pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a
         *        longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code>
         *        parameter, which is a pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<StepSummary> steps = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsResponse model) {
            super(model);
            steps(model.steps);
            marker(model.marker);
        }

        public final List<StepSummary.Builder> getSteps() {
            List<StepSummary.Builder> result = StepSummaryListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<StepSummary.BuilderImpl> steps) {
            this.steps = StepSummaryListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<StepSummary> steps) {
            this.steps = StepSummaryListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepSummary... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepSummary.Builder>... steps) {
            steps(Stream.of(steps).map(c -> StepSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListStepsResponse build() {
            return new ListStepsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
