/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNotebookExecutionRequest extends EmrRequest implements
        ToCopyableBuilder<StartNotebookExecutionRequest.Builder, StartNotebookExecutionRequest> {
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EditorId").getter(getter(StartNotebookExecutionRequest::editorId)).setter(setter(Builder::editorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()).build();

    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelativePath").getter(getter(StartNotebookExecutionRequest::relativePath))
            .setter(setter(Builder::relativePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePath").build()).build();

    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookExecutionName").getter(getter(StartNotebookExecutionRequest::notebookExecutionName))
            .setter(setter(Builder::notebookExecutionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build())
            .build();

    private static final SdkField<String> NOTEBOOK_PARAMS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookParams").getter(getter(StartNotebookExecutionRequest::notebookParams))
            .setter(setter(Builder::notebookParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookParams").build()).build();

    private static final SdkField<ExecutionEngineConfig> EXECUTION_ENGINE_FIELD = SdkField
            .<ExecutionEngineConfig> builder(MarshallingType.SDK_POJO).memberName("ExecutionEngine")
            .getter(getter(StartNotebookExecutionRequest::executionEngine)).setter(setter(Builder::executionEngine))
            .constructor(ExecutionEngineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngine").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(StartNotebookExecutionRequest::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceSecurityGroupId")
            .getter(getter(StartNotebookExecutionRequest::notebookInstanceSecurityGroupId))
            .setter(setter(Builder::notebookInstanceSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceSecurityGroupId")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartNotebookExecutionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITOR_ID_FIELD,
            RELATIVE_PATH_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, NOTEBOOK_PARAMS_FIELD, EXECUTION_ENGINE_FIELD,
            SERVICE_ROLE_FIELD, NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD, TAGS_FIELD));

    private final String editorId;

    private final String relativePath;

    private final String notebookExecutionName;

    private final String notebookParams;

    private final ExecutionEngineConfig executionEngine;

    private final String serviceRole;

    private final String notebookInstanceSecurityGroupId;

    private final List<Tag> tags;

    private StartNotebookExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.editorId = builder.editorId;
        this.relativePath = builder.relativePath;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.notebookParams = builder.notebookParams;
        this.executionEngine = builder.executionEngine;
        this.serviceRole = builder.serviceRole;
        this.notebookInstanceSecurityGroupId = builder.notebookInstanceSecurityGroupId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the EMR Notebook to use for notebook execution.
     * </p>
     * 
     * @return The unique identifier of the EMR Notebook to use for notebook execution.
     */
    public final String editorId() {
        return editorId;
    }

    /**
     * <p>
     * The path and file name of the notebook file for this execution, relative to the path specified for the EMR
     * Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR
     * Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this
     * request), and you specify a <code>RelativePath</code> of
     * <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook execution
     * is
     * <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>
     * .
     * </p>
     * 
     * @return The path and file name of the notebook file for this execution, relative to the path specified for the
     *         EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you
     *         create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the
     *         <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of
     *         <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook
     *         execution is
     *         <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>
     *         .
     */
    public final String relativePath() {
        return relativePath;
    }

    /**
     * <p>
     * An optional name for the notebook execution.
     * </p>
     * 
     * @return An optional name for the notebook execution.
     */
    public final String notebookExecutionName() {
        return notebookExecutionName;
    }

    /**
     * <p>
     * Input parameters in JSON format passed to the EMR Notebook at runtime for execution.
     * </p>
     * 
     * @return Input parameters in JSON format passed to the EMR Notebook at runtime for execution.
     */
    public final String notebookParams() {
        return notebookParams;
    }

    /**
     * <p>
     * Specifies the execution engine (cluster) that runs the notebook execution.
     * </p>
     * 
     * @return Specifies the execution engine (cluster) that runs the notebook execution.
     */
    public final ExecutionEngineConfig executionEngine() {
        return executionEngine;
    }

    /**
     * <p>
     * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook
     * execution.
     * </p>
     * 
     * @return The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the
     *         notebook execution.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook
     * execution.
     * </p>
     * 
     * @return The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this
     *         notebook execution.
     */
    public final String notebookInstanceSecurityGroupId() {
        return notebookInstanceSecurityGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a
     * required key string with a maximum of 128 characters and an optional value string with a maximum of 256
     * characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist
     *         of a required key string with a maximum of 128 characters and an optional value string with a maximum of
     *         256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(editorId());
        hashCode = 31 * hashCode + Objects.hashCode(relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookParams());
        hashCode = 31 * hashCode + Objects.hashCode(executionEngine());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNotebookExecutionRequest)) {
            return false;
        }
        StartNotebookExecutionRequest other = (StartNotebookExecutionRequest) obj;
        return Objects.equals(editorId(), other.editorId()) && Objects.equals(relativePath(), other.relativePath())
                && Objects.equals(notebookExecutionName(), other.notebookExecutionName())
                && Objects.equals(notebookParams(), other.notebookParams())
                && Objects.equals(executionEngine(), other.executionEngine())
                && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(notebookInstanceSecurityGroupId(), other.notebookInstanceSecurityGroupId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartNotebookExecutionRequest").add("EditorId", editorId()).add("RelativePath", relativePath())
                .add("NotebookExecutionName", notebookExecutionName()).add("NotebookParams", notebookParams())
                .add("ExecutionEngine", executionEngine()).add("ServiceRole", serviceRole())
                .add("NotebookInstanceSecurityGroupId", notebookInstanceSecurityGroupId()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EditorId":
            return Optional.ofNullable(clazz.cast(editorId()));
        case "RelativePath":
            return Optional.ofNullable(clazz.cast(relativePath()));
        case "NotebookExecutionName":
            return Optional.ofNullable(clazz.cast(notebookExecutionName()));
        case "NotebookParams":
            return Optional.ofNullable(clazz.cast(notebookParams()));
        case "ExecutionEngine":
            return Optional.ofNullable(clazz.cast(executionEngine()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "NotebookInstanceSecurityGroupId":
            return Optional.ofNullable(clazz.cast(notebookInstanceSecurityGroupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNotebookExecutionRequest, T> g) {
        return obj -> g.apply((StartNotebookExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartNotebookExecutionRequest> {
        /**
         * <p>
         * The unique identifier of the EMR Notebook to use for notebook execution.
         * </p>
         * 
         * @param editorId
         *        The unique identifier of the EMR Notebook to use for notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editorId(String editorId);

        /**
         * <p>
         * The path and file name of the notebook file for this execution, relative to the path specified for the EMR
         * Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR
         * Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of
         * this request), and you specify a <code>RelativePath</code> of
         * <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook
         * execution is
         * <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>
         * .
         * </p>
         * 
         * @param relativePath
         *        The path and file name of the notebook file for this execution, relative to the path specified for the
         *        EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you
         *        create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the
         *        <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of
         *        <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the
         *        notebook execution is
         *        <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativePath(String relativePath);

        /**
         * <p>
         * An optional name for the notebook execution.
         * </p>
         * 
         * @param notebookExecutionName
         *        An optional name for the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookExecutionName(String notebookExecutionName);

        /**
         * <p>
         * Input parameters in JSON format passed to the EMR Notebook at runtime for execution.
         * </p>
         * 
         * @param notebookParams
         *        Input parameters in JSON format passed to the EMR Notebook at runtime for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookParams(String notebookParams);

        /**
         * <p>
         * Specifies the execution engine (cluster) that runs the notebook execution.
         * </p>
         * 
         * @param executionEngine
         *        Specifies the execution engine (cluster) that runs the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEngine(ExecutionEngineConfig executionEngine);

        /**
         * <p>
         * Specifies the execution engine (cluster) that runs the notebook execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionEngineConfig.Builder} avoiding
         * the need to create one manually via {@link ExecutionEngineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionEngineConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #executionEngine(ExecutionEngineConfig)}.
         * 
         * @param executionEngine
         *        a consumer that will call methods on {@link ExecutionEngineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionEngine(ExecutionEngineConfig)
         */
        default Builder executionEngine(Consumer<ExecutionEngineConfig.Builder> executionEngine) {
            return executionEngine(ExecutionEngineConfig.builder().applyMutation(executionEngine).build());
        }

        /**
         * <p>
         * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the
         * notebook execution.
         * </p>
         * 
         * @param serviceRole
         *        The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the
         *        notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook
         * execution.
         * </p>
         * 
         * @param notebookInstanceSecurityGroupId
         *        The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this
         *        notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId);

        /**
         * <p>
         * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a
         * required key string with a maximum of 128 characters and an optional value string with a maximum of 256
         * characters.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that
         *        consist of a required key string with a maximum of 128 characters and an optional value string with a
         *        maximum of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a
         * required key string with a maximum of 128 characters and an optional value string with a maximum of 256
         * characters.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that
         *        consist of a required key string with a maximum of 128 characters and an optional value string with a
         *        maximum of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a
         * required key string with a maximum of 128 characters and an optional value string with a maximum of 256
         * characters.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String editorId;

        private String relativePath;

        private String notebookExecutionName;

        private String notebookParams;

        private ExecutionEngineConfig executionEngine;

        private String serviceRole;

        private String notebookInstanceSecurityGroupId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartNotebookExecutionRequest model) {
            super(model);
            editorId(model.editorId);
            relativePath(model.relativePath);
            notebookExecutionName(model.notebookExecutionName);
            notebookParams(model.notebookParams);
            executionEngine(model.executionEngine);
            serviceRole(model.serviceRole);
            notebookInstanceSecurityGroupId(model.notebookInstanceSecurityGroupId);
            tags(model.tags);
        }

        public final String getEditorId() {
            return editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final String getRelativePath() {
            return relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final String getNotebookExecutionName() {
            return notebookExecutionName;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final String getNotebookParams() {
            return notebookParams;
        }

        public final void setNotebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
        }

        @Override
        public final Builder notebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
            return this;
        }

        public final ExecutionEngineConfig.Builder getExecutionEngine() {
            return executionEngine != null ? executionEngine.toBuilder() : null;
        }

        public final void setExecutionEngine(ExecutionEngineConfig.BuilderImpl executionEngine) {
            this.executionEngine = executionEngine != null ? executionEngine.build() : null;
        }

        @Override
        public final Builder executionEngine(ExecutionEngineConfig executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getNotebookInstanceSecurityGroupId() {
            return notebookInstanceSecurityGroupId;
        }

        public final void setNotebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
        }

        @Override
        public final Builder notebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNotebookExecutionRequest build() {
            return new StartNotebookExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
