/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.StepIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddJobFlowStepsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, AddJobFlowStepsResponse> {
    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepIds").getter(AddJobFlowStepsResponse.getter(AddJobFlowStepsResponse::stepIds)).setter(AddJobFlowStepsResponse.setter(Builder::stepIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_IDS_FIELD));
    private final List<String> stepIds;

    private AddJobFlowStepsResponse(BuilderImpl builder) {
        super(builder);
        this.stepIds = builder.stepIds;
    }

    public final boolean hasStepIds() {
        return this.stepIds != null && !(this.stepIds instanceof SdkAutoConstructList);
    }

    public final List<String> stepIds() {
        return this.stepIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepIds() ? this.stepIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsResponse)) {
            return false;
        }
        AddJobFlowStepsResponse other = (AddJobFlowStepsResponse)((Object)obj);
        return this.hasStepIds() == other.hasStepIds() && Objects.equals(this.stepIds(), other.stepIds());
    }

    public final String toString() {
        return ToString.builder((String)"AddJobFlowStepsResponse").add("StepIds", this.hasStepIds() ? this.stepIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepIds": {
                return Optional.ofNullable(clazz.cast(this.stepIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddJobFlowStepsResponse, T> g) {
        return obj -> g.apply((AddJobFlowStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsResponse model) {
            super(model);
            this.stepIds(model.stepIds);
        }

        public final Collection<String> getStepIds() {
            if (this.stepIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepIds;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        @Override
        @Transient
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            this.stepIds(Arrays.asList(stepIds));
            return this;
        }

        @Override
        public AddJobFlowStepsResponse build() {
            return new AddJobFlowStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddJobFlowStepsResponse> {
        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);
    }
}

