/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EbsBlockDeviceConfigListCopier {
    static List<EbsBlockDeviceConfig> copy(Collection<? extends EbsBlockDeviceConfig> ebsBlockDeviceConfigListParam) {
        List<EbsBlockDeviceConfig> list;
        if (ebsBlockDeviceConfigListParam == null || ebsBlockDeviceConfigListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EbsBlockDeviceConfig> modifiableList = new ArrayList<>();
            ebsBlockDeviceConfigListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EbsBlockDeviceConfig> copyFromBuilder(
            Collection<? extends EbsBlockDeviceConfig.Builder> ebsBlockDeviceConfigListParam) {
        List<EbsBlockDeviceConfig> list;
        if (ebsBlockDeviceConfigListParam == null || ebsBlockDeviceConfigListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EbsBlockDeviceConfig> modifiableList = new ArrayList<>();
            ebsBlockDeviceConfigListParam.forEach(entry -> {
                EbsBlockDeviceConfig member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EbsBlockDeviceConfig.Builder> copyToBuilder(
            Collection<? extends EbsBlockDeviceConfig> ebsBlockDeviceConfigListParam) {
        List<EbsBlockDeviceConfig.Builder> list;
        if (ebsBlockDeviceConfigListParam == null || ebsBlockDeviceConfigListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EbsBlockDeviceConfig.Builder> modifiableList = new ArrayList<>();
            ebsBlockDeviceConfigListParam.forEach(entry -> {
                EbsBlockDeviceConfig.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
