/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers
 * activity, how EC2 instances are added or removed, and the periodicity of adjustments. The automatic scaling policy
 * for an instance group can comprise one or more automatic scaling rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingRule implements SdkPojo, Serializable, ToCopyableBuilder<ScalingRule.Builder, ScalingRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ScalingRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ScalingRule::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ScalingAction> ACTION_FIELD = SdkField.<ScalingAction> builder(MarshallingType.SDK_POJO)
            .memberName("Action").getter(getter(ScalingRule::action)).setter(setter(Builder::action))
            .constructor(ScalingAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<ScalingTrigger> TRIGGER_FIELD = SdkField.<ScalingTrigger> builder(MarshallingType.SDK_POJO)
            .memberName("Trigger").getter(getter(ScalingRule::trigger)).setter(setter(Builder::trigger))
            .constructor(ScalingTrigger::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ACTION_FIELD, TRIGGER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final ScalingAction action;

    private final ScalingTrigger trigger;

    private ScalingRule(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.trigger = builder.trigger;
    }

    /**
     * <p>
     * The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.
     * </p>
     * 
     * @return The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A friendly, more verbose description of the automatic scaling rule.
     * </p>
     * 
     * @return A friendly, more verbose description of the automatic scaling rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The conditions that trigger an automatic scaling activity.
     * </p>
     * 
     * @return The conditions that trigger an automatic scaling activity.
     */
    public final ScalingAction action() {
        return action;
    }

    /**
     * <p>
     * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
     * </p>
     * 
     * @return The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
     */
    public final ScalingTrigger trigger() {
        return trigger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(trigger());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingRule)) {
            return false;
        }
        ScalingRule other = (ScalingRule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(action(), other.action()) && Objects.equals(trigger(), other.trigger());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingRule").add("Name", name()).add("Description", description()).add("Action", action())
                .add("Trigger", trigger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Trigger":
            return Optional.ofNullable(clazz.cast(trigger()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingRule, T> g) {
        return obj -> g.apply((ScalingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingRule> {
        /**
         * <p>
         * The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.
         * </p>
         * 
         * @param name
         *        The name used to identify an automatic scaling rule. Rule names must be unique within a scaling
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A friendly, more verbose description of the automatic scaling rule.
         * </p>
         * 
         * @param description
         *        A friendly, more verbose description of the automatic scaling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The conditions that trigger an automatic scaling activity.
         * </p>
         * 
         * @param action
         *        The conditions that trigger an automatic scaling activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ScalingAction action);

        /**
         * <p>
         * The conditions that trigger an automatic scaling activity.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingAction.Builder} avoiding the need
         * to create one manually via {@link ScalingAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ScalingAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ScalingAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ScalingAction)
         */
        default Builder action(Consumer<ScalingAction.Builder> action) {
            return action(ScalingAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         * </p>
         * 
         * @param trigger
         *        The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trigger(ScalingTrigger trigger);

        /**
         * <p>
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingTrigger.Builder} avoiding the need
         * to create one manually via {@link ScalingTrigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingTrigger.Builder#build()} is called immediately and its
         * result is passed to {@link #trigger(ScalingTrigger)}.
         * 
         * @param trigger
         *        a consumer that will call methods on {@link ScalingTrigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trigger(ScalingTrigger)
         */
        default Builder trigger(Consumer<ScalingTrigger.Builder> trigger) {
            return trigger(ScalingTrigger.builder().applyMutation(trigger).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private ScalingAction action;

        private ScalingTrigger trigger;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingRule model) {
            name(model.name);
            description(model.description);
            action(model.action);
            trigger(model.trigger);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ScalingAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ScalingAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ScalingAction action) {
            this.action = action;
            return this;
        }

        public final ScalingTrigger.Builder getTrigger() {
            return trigger != null ? trigger.toBuilder() : null;
        }

        public final void setTrigger(ScalingTrigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        @Override
        public final Builder trigger(ScalingTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public ScalingRule build() {
            return new ScalingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
