/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emr.DefaultEmrBaseClientBuilder;
import software.amazon.awssdk.services.emr.DefaultEmrClient;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.EmrClientBuilder;
import software.amazon.awssdk.services.emr.EmrServiceClientConfiguration;
import software.amazon.awssdk.services.emr.endpoints.EmrEndpointProvider;

@SdkInternalApi
final class DefaultEmrClientBuilder
extends DefaultEmrBaseClientBuilder<EmrClientBuilder, EmrClient>
implements EmrClientBuilder {
    DefaultEmrClientBuilder() {
    }

    @Override
    public DefaultEmrClientBuilder endpointProvider(EmrEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EmrClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEmrClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EmrServiceClientConfiguration serviceClientConfiguration = EmrServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEmrClient(serviceClientConfiguration, clientConfiguration);
    }
}

