/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <a>RunJobFlow</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunJobFlowRequest extends EmrRequest implements
        ToCopyableBuilder<RunJobFlowRequest.Builder, RunJobFlowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RunJobFlowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LogUri")
            .getter(getter(RunJobFlowRequest::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()).build();

    private static final SdkField<String> LOG_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogEncryptionKmsKeyId").getter(getter(RunJobFlowRequest::logEncryptionKmsKeyId))
            .setter(setter(Builder::logEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEncryptionKmsKeyId").build())
            .build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo").getter(getter(RunJobFlowRequest::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()).build();

    private static final SdkField<String> AMI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmiVersion").getter(getter(RunJobFlowRequest::amiVersion)).setter(setter(Builder::amiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiVersion").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseLabel").getter(getter(RunJobFlowRequest::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()).build();

    private static final SdkField<JobFlowInstancesConfig> INSTANCES_FIELD = SdkField
            .<JobFlowInstancesConfig> builder(MarshallingType.SDK_POJO).memberName("Instances")
            .getter(getter(RunJobFlowRequest::instances)).setter(setter(Builder::instances))
            .constructor(JobFlowInstancesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build()).build();

    private static final SdkField<List<StepConfig>> STEPS_FIELD = SdkField
            .<List<StepConfig>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(RunJobFlowRequest::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BootstrapActionConfig>> BOOTSTRAP_ACTIONS_FIELD = SdkField
            .<List<BootstrapActionConfig>> builder(MarshallingType.LIST)
            .memberName("BootstrapActions")
            .getter(getter(RunJobFlowRequest::bootstrapActions))
            .setter(setter(Builder::bootstrapActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootstrapActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BootstrapActionConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(BootstrapActionConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedProducts")
            .getter(getter(RunJobFlowRequest::supportedProducts))
            .setter(setter(Builder::supportedProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SupportedProductConfig>> NEW_SUPPORTED_PRODUCTS_FIELD = SdkField
            .<List<SupportedProductConfig>> builder(MarshallingType.LIST)
            .memberName("NewSupportedProducts")
            .getter(getter(RunJobFlowRequest::newSupportedProducts))
            .setter(setter(Builder::newSupportedProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSupportedProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedProductConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedProductConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField
            .<List<Application>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(RunJobFlowRequest::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Application> builder(MarshallingType.SDK_POJO)
                                            .constructor(Application::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("Configurations")
            .getter(getter(RunJobFlowRequest::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> VISIBLE_TO_ALL_USERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VisibleToAllUsers").getter(getter(RunJobFlowRequest::visibleToAllUsers))
            .setter(setter(Builder::visibleToAllUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleToAllUsers").build()).build();

    private static final SdkField<String> JOB_FLOW_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFlowRole").getter(getter(RunJobFlowRequest::jobFlowRole)).setter(setter(Builder::jobFlowRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowRole").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(RunJobFlowRequest::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RunJobFlowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(RunJobFlowRequest::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingRole").getter(getter(RunJobFlowRequest::autoScalingRole))
            .setter(setter(Builder::autoScalingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRole").build()).build();

    private static final SdkField<String> SCALE_DOWN_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScaleDownBehavior").getter(getter(RunJobFlowRequest::scaleDownBehaviorAsString))
            .setter(setter(Builder::scaleDownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownBehavior").build()).build();

    private static final SdkField<String> CUSTOM_AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomAmiId").getter(getter(RunJobFlowRequest::customAmiId)).setter(setter(Builder::customAmiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiId").build()).build();

    private static final SdkField<Integer> EBS_ROOT_VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EbsRootVolumeSize").getter(getter(RunJobFlowRequest::ebsRootVolumeSize))
            .setter(setter(Builder::ebsRootVolumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsRootVolumeSize").build()).build();

    private static final SdkField<String> REPO_UPGRADE_ON_BOOT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepoUpgradeOnBoot").getter(getter(RunJobFlowRequest::repoUpgradeOnBootAsString))
            .setter(setter(Builder::repoUpgradeOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepoUpgradeOnBoot").build()).build();

    private static final SdkField<KerberosAttributes> KERBEROS_ATTRIBUTES_FIELD = SdkField
            .<KerberosAttributes> builder(MarshallingType.SDK_POJO).memberName("KerberosAttributes")
            .getter(getter(RunJobFlowRequest::kerberosAttributes)).setter(setter(Builder::kerberosAttributes))
            .constructor(KerberosAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosAttributes").build())
            .build();

    private static final SdkField<Integer> STEP_CONCURRENCY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StepConcurrencyLevel").getter(getter(RunJobFlowRequest::stepConcurrencyLevel))
            .setter(setter(Builder::stepConcurrencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepConcurrencyLevel").build())
            .build();

    private static final SdkField<ManagedScalingPolicy> MANAGED_SCALING_POLICY_FIELD = SdkField
            .<ManagedScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("ManagedScalingPolicy")
            .getter(getter(RunJobFlowRequest::managedScalingPolicy)).setter(setter(Builder::managedScalingPolicy))
            .constructor(ManagedScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedScalingPolicy").build())
            .build();

    private static final SdkField<List<PlacementGroupConfig>> PLACEMENT_GROUP_CONFIGS_FIELD = SdkField
            .<List<PlacementGroupConfig>> builder(MarshallingType.LIST)
            .memberName("PlacementGroupConfigs")
            .getter(getter(RunJobFlowRequest::placementGroupConfigs))
            .setter(setter(Builder::placementGroupConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementGroupConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementGroupConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoTerminationPolicy> AUTO_TERMINATION_POLICY_FIELD = SdkField
            .<AutoTerminationPolicy> builder(MarshallingType.SDK_POJO).memberName("AutoTerminationPolicy")
            .getter(getter(RunJobFlowRequest::autoTerminationPolicy)).setter(setter(Builder::autoTerminationPolicy))
            .constructor(AutoTerminationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTerminationPolicy").build())
            .build();

    private static final SdkField<String> OS_RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OSReleaseLabel").getter(getter(RunJobFlowRequest::osReleaseLabel))
            .setter(setter(Builder::osReleaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSReleaseLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LOG_URI_FIELD,
            LOG_ENCRYPTION_KMS_KEY_ID_FIELD, ADDITIONAL_INFO_FIELD, AMI_VERSION_FIELD, RELEASE_LABEL_FIELD, INSTANCES_FIELD,
            STEPS_FIELD, BOOTSTRAP_ACTIONS_FIELD, SUPPORTED_PRODUCTS_FIELD, NEW_SUPPORTED_PRODUCTS_FIELD, APPLICATIONS_FIELD,
            CONFIGURATIONS_FIELD, VISIBLE_TO_ALL_USERS_FIELD, JOB_FLOW_ROLE_FIELD, SERVICE_ROLE_FIELD, TAGS_FIELD,
            SECURITY_CONFIGURATION_FIELD, AUTO_SCALING_ROLE_FIELD, SCALE_DOWN_BEHAVIOR_FIELD, CUSTOM_AMI_ID_FIELD,
            EBS_ROOT_VOLUME_SIZE_FIELD, REPO_UPGRADE_ON_BOOT_FIELD, KERBEROS_ATTRIBUTES_FIELD, STEP_CONCURRENCY_LEVEL_FIELD,
            MANAGED_SCALING_POLICY_FIELD, PLACEMENT_GROUP_CONFIGS_FIELD, AUTO_TERMINATION_POLICY_FIELD, OS_RELEASE_LABEL_FIELD));

    private final String name;

    private final String logUri;

    private final String logEncryptionKmsKeyId;

    private final String additionalInfo;

    private final String amiVersion;

    private final String releaseLabel;

    private final JobFlowInstancesConfig instances;

    private final List<StepConfig> steps;

    private final List<BootstrapActionConfig> bootstrapActions;

    private final List<String> supportedProducts;

    private final List<SupportedProductConfig> newSupportedProducts;

    private final List<Application> applications;

    private final List<Configuration> configurations;

    private final Boolean visibleToAllUsers;

    private final String jobFlowRole;

    private final String serviceRole;

    private final List<Tag> tags;

    private final String securityConfiguration;

    private final String autoScalingRole;

    private final String scaleDownBehavior;

    private final String customAmiId;

    private final Integer ebsRootVolumeSize;

    private final String repoUpgradeOnBoot;

    private final KerberosAttributes kerberosAttributes;

    private final Integer stepConcurrencyLevel;

    private final ManagedScalingPolicy managedScalingPolicy;

    private final List<PlacementGroupConfig> placementGroupConfigs;

    private final AutoTerminationPolicy autoTerminationPolicy;

    private final String osReleaseLabel;

    private RunJobFlowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.logUri = builder.logUri;
        this.logEncryptionKmsKeyId = builder.logEncryptionKmsKeyId;
        this.additionalInfo = builder.additionalInfo;
        this.amiVersion = builder.amiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.instances = builder.instances;
        this.steps = builder.steps;
        this.bootstrapActions = builder.bootstrapActions;
        this.supportedProducts = builder.supportedProducts;
        this.newSupportedProducts = builder.newSupportedProducts;
        this.applications = builder.applications;
        this.configurations = builder.configurations;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.jobFlowRole = builder.jobFlowRole;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
        this.customAmiId = builder.customAmiId;
        this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
        this.repoUpgradeOnBoot = builder.repoUpgradeOnBoot;
        this.kerberosAttributes = builder.kerberosAttributes;
        this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
        this.managedScalingPolicy = builder.managedScalingPolicy;
        this.placementGroupConfigs = builder.placementGroupConfigs;
        this.autoTerminationPolicy = builder.autoTerminationPolicy;
        this.osReleaseLabel = builder.osReleaseLabel;
    }

    /**
     * <p>
     * The name of the job flow.
     * </p>
     * 
     * @return The name of the job flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not
     * created.
     * </p>
     * 
     * @return The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are
     *         not created.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This
     * attribute is only available with Amazon EMR releases 5.30.0 and later, excluding Amazon EMR 6.0.0.
     * </p>
     * 
     * @return The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by
     *         AES-256. This attribute is only available with Amazon EMR releases 5.30.0 and later, excluding Amazon EMR
     *         6.0.0.
     */
    public final String logEncryptionKmsKeyId() {
        return logEncryptionKmsKeyId;
    }

    /**
     * <p>
     * A JSON string for selecting additional features.
     * </p>
     * 
     * @return A JSON string for selecting additional features.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later,
     * <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.
     * </p>
     * 
     * @return Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later,
     *         <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.
     */
    public final String amiVersion() {
        return amiVersion;
    }

    /**
     * <p>
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the
     * cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such
     * as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application
     * versions and features, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.
     * com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later.
     * Earlier versions use <code>AmiVersion</code>.
     * </p>
     * 
     * @return The Amazon EMR release label, which determines the version of open-source application packages installed
     *         on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR
     *         release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions
     *         and included application versions and features, see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"
     *         >https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR
     *         releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * A specification of the number and type of Amazon EC2 instances.
     * </p>
     * 
     * @return A specification of the number and type of Amazon EC2 instances.
     */
    public final JobFlowInstancesConfig instances() {
        return instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of steps to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return A list of steps to run.
     */
    public final List<StepConfig> steps() {
        return steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the BootstrapActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBootstrapActions() {
        return bootstrapActions != null && !(bootstrapActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBootstrapActions} method.
     * </p>
     * 
     * @return A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    public final List<BootstrapActionConfig> bootstrapActions() {
        return bootstrapActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedProducts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedProducts() {
        return supportedProducts != null && !(supportedProducts instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     * </p>
     * </note>
     * <p>
     * A list of strings that indicates third-party software to use. For more information, see the <a
     * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Currently
     * supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "mapr-m3" - launch the job flow using MapR M3 Edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * "mapr-m5" - launch the job flow using MapR M5 Edition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedProducts} method.
     * </p>
     * 
     * @return <p>
     *         For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     *         </p>
     *         </note>
     *         <p>
     *         A list of strings that indicates third-party software to use. For more information, see the <a
     *         href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
     *         Currently supported values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "mapr-m3" - launch the job flow using MapR M3 Edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mapr-m5" - launch the job flow using MapR M5 Edition.
     *         </p>
     *         </li>
     */
    public final List<String> supportedProducts() {
        return supportedProducts;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewSupportedProducts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewSupportedProducts() {
        return newSupportedProducts != null && !(newSupportedProducts instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     * </p>
     * </note>
     * <p>
     * A list of strings that indicates third-party software to use with the job flow that accepts a user argument list.
     * Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action
     * arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
     * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported
     * values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "mapr-m3" - launch the cluster using MapR M3 Edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * "mapr-m5" - launch the cluster using MapR M5 Edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or
     * M5 Edition respectively.
     * </p>
     * </li>
     * <li>
     * <p>
     * "mapr-m7" - launch the cluster using MapR M7 Edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * "hue"- launch the cluster with Hue installed.
     * </p>
     * </li>
     * <li>
     * <p>
     * "spark" - launch the cluster with Apache Spark installed.
     * </p>
     * </li>
     * <li>
     * <p>
     * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewSupportedProducts} method.
     * </p>
     * 
     * @return <p>
     *         For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
     *         </p>
     *         </note>
     *         <p>
     *         A list of strings that indicates third-party software to use with the job flow that accepts a user
     *         argument list. Amazon EMR accepts and forwards the argument list to the corresponding installation script
     *         as bootstrap action arguments. For more information, see
     *         "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
     *         href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
     *         Supported values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "mapr-m3" - launch the cluster using MapR M3 Edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mapr-m5" - launch the cluster using MapR M5 Edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using
     *         MapR M3 or M5 Edition respectively.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mapr-m7" - launch the cluster using MapR M7 Edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "hue"- launch the cluster with Hue installed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "spark" - launch the cluster with Apache Spark installed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
     *         </p>
     *         </li>
     */
    public final List<SupportedProductConfig> newSupportedProducts() {
        return newSupportedProducts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install
     * and configure when launching the cluster. For a list of applications available for each Amazon EMR release
     * version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to
     *         install and configure when launching the cluster. For a list of applications available for each Amazon
     *         EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon
     *         EMRRelease Guide</a>.
     */
    public final List<Application> applications() {
        return applications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster that you
     * are creating.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster
     *         that you are creating.
     */
    public final List<Configuration> configurations() {
        return configurations;
    }

    /**
     * <important>
     * <p>
     * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>.
     * Setting it to <code>false</code> now has no effect.
     * </p>
     * </important>
     * <p>
     * Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the
     * cluster can perform Amazon EMR actions on the cluster that their IAM policies allow. This value defaults to
     * <code>true</code> for clusters created using the Amazon EMR API or the CLI <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.
     * </p>
     * <p>
     * When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services
     * account root user can perform Amazon EMR actions for the cluster, regardless of the IAM permissions policies
     * attached to other IAM principals. For more information, see <a href=
     * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_IAM_emr-with-IAM.html#security_set_visible_to_all_users"
     * >Understanding the Amazon EMR cluster VisibleToAllUsers setting</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * 
     * @return <p>
     *         The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>
     *         . Setting it to <code>false</code> now has no effect.
     *         </p>
     *         </important>
     *         <p>
     *         Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated
     *         with the cluster can perform Amazon EMR actions on the cluster that their IAM policies allow. This value
     *         defaults to <code>true</code> for clusters created using the Amazon EMR API or the CLI <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a>
     *         command.
     *         </p>
     *         <p>
     *         When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web
     *         Services account root user can perform Amazon EMR actions for the cluster, regardless of the IAM
     *         permissions policies attached to other IAM principals. For more information, see <a href=
     *         "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_IAM_emr-with-IAM.html#security_set_visible_to_all_users"
     *         >Understanding the Amazon EMR cluster VisibleToAllUsers setting</a> in the <i>Amazon EMR Management
     *         Guide</i>.
     */
    public final Boolean visibleToAllUsers() {
        return visibleToAllUsers;
    }

    /**
     * <p>
     * Also called instance profile and Amazon EC2 role. An IAM role for an Amazon EMR cluster. The Amazon EC2 instances
     * of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to use the
     * default role, you must have already created it using the CLI or console.
     * </p>
     * 
     * @return Also called instance profile and Amazon EC2 role. An IAM role for an Amazon EMR cluster. The Amazon EC2
     *         instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order
     *         to use the default role, you must have already created it using the CLI or console.
     */
    public final String jobFlowRole() {
        return jobFlowRole;
    }

    /**
     * <p>
     * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf. If you've
     * created a custom service role path, you must specify it for the service role when you launch your cluster.
     * </p>
     * 
     * @return The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf. If
     *         you've created a custom service role path, you must specify it for the service role when you launch your
     *         cluster.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of a security configuration to apply to the cluster.
     * </p>
     * 
     * @return The name of a security configuration to apply to the cluster.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM
     * role provides permissions that the automatic scaling feature requires to launch and terminate Amazon EC2
     * instances in an instance group.
     * </p>
     * 
     * @return An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>.
     *         The IAM role provides permissions that the automatic scaling feature requires to launch and terminate
     *         Amazon EC2 instances in an instance group.
     */
    public final String autoScalingRole() {
        return autoScalingRole;
    }

    /**
     * <p>
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
     * instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
     * the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option
     * is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
     * <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks
     * from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
     * behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to
     * HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later,
     * and is the default for releases of Amazon EMR earlier than 5.1.0.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleDownBehavior}
     * will return {@link ScaleDownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scaleDownBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity
     *         occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR
     *         terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance
     *         was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for
     *         clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR
     *         adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances,
     *         regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
     *         first and blocks instance termination if it could lead to HDFS corruption.
     *         <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later, and is
     *         the default for releases of Amazon EMR earlier than 5.1.0.
     * @see ScaleDownBehavior
     */
    public final ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(scaleDownBehavior);
    }

    /**
     * <p>
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
     * instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at
     * the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option
     * is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
     * <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks
     * from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
     * behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to
     * HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later,
     * and is the default for releases of Amazon EMR earlier than 5.1.0.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleDownBehavior}
     * will return {@link ScaleDownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scaleDownBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity
     *         occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR
     *         terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance
     *         was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for
     *         clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR
     *         adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances,
     *         regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
     *         first and blocks instance termination if it could lead to HDFS corruption.
     *         <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later, and is
     *         the default for releases of Amazon EMR earlier than 5.1.0.
     * @see ScaleDownBehavior
     */
    public final String scaleDownBehaviorAsString() {
        return scaleDownBehavior;
    }

    /**
     * <p>
     * Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If
     * specified, Amazon EMR uses this AMI when it launches cluster Amazon EC2 instances. For more information about
     * custom AMIs in Amazon EMR, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in the
     * <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the
     * <code>ReleaseLabel</code> specified. For Amazon EMR releases 2.x and 3.x, use <code>AmiVersion</code> instead.
     * </p>
     * <p>
     * For information about creating a custom AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For information about
     * finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding
     * a Linux AMI</a>.
     * </p>
     * 
     * @return Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If
     *         specified, Amazon EMR uses this AMI when it launches cluster Amazon EC2 instances. For more information
     *         about custom AMIs in Amazon EMR, see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a>
     *         in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the
     *         <code>ReleaseLabel</code> specified. For Amazon EMR releases 2.x and 3.x, use <code>AmiVersion</code>
     *         instead.</p>
     *         <p>
     *         For information about creating a custom AMI, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon
     *         EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For
     *         information about finding an AMI ID, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>.
     */
    public final String customAmiId() {
        return customAmiId;
    }

    /**
     * <p>
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2
     * instance. Available in Amazon EMR releases 4.x and later.
     * </p>
     * 
     * @return The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2
     *         instance. Available in Amazon EMR releases 4.x and later.
     */
    public final Integer ebsRootVolumeSize() {
        return ebsRootVolumeSize;
    }

    /**
     * <p>
     * Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package
     * repositories to apply automatically when the instance boots using the AMI. If omitted, the default is
     * <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified,
     * no updates are applied, and all updates must be applied manually.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repoUpgradeOnBoot}
     * will return {@link RepoUpgradeOnBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #repoUpgradeOnBootAsString}.
     * </p>
     * 
     * @return Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI
     *         package repositories to apply automatically when the instance boots using the AMI. If omitted, the
     *         default is <code>SECURITY</code>, which indicates that only security updates are applied. If
     *         <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.
     * @see RepoUpgradeOnBoot
     */
    public final RepoUpgradeOnBoot repoUpgradeOnBoot() {
        return RepoUpgradeOnBoot.fromValue(repoUpgradeOnBoot);
    }

    /**
     * <p>
     * Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package
     * repositories to apply automatically when the instance boots using the AMI. If omitted, the default is
     * <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified,
     * no updates are applied, and all updates must be applied manually.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repoUpgradeOnBoot}
     * will return {@link RepoUpgradeOnBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #repoUpgradeOnBootAsString}.
     * </p>
     * 
     * @return Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI
     *         package repositories to apply automatically when the instance boots using the AMI. If omitted, the
     *         default is <code>SECURITY</code>, which indicates that only security updates are applied. If
     *         <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.
     * @see RepoUpgradeOnBoot
     */
    public final String repoUpgradeOnBootAsString() {
        return repoUpgradeOnBoot;
    }

    /**
     * <p>
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For
     * more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use
     * Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * 
     * @return Attributes for Kerberos configuration when Kerberos authentication is enabled using a security
     *         configuration. For more information see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
     *         Authentication</a> in the <i>Amazon EMR Management Guide</i>.
     */
    public final KerberosAttributes kerberosAttributes() {
        return kerberosAttributes;
    }

    /**
     * <p>
     * Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The maximum
     * value is <code>256</code>.
     * </p>
     * 
     * @return Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The
     *         maximum value is <code>256</code>.
     */
    public final Integer stepConcurrencyLevel() {
        return stepConcurrencyLevel;
    }

    /**
     * <p>
     * The specified managed scaling policy for an Amazon EMR cluster.
     * </p>
     * 
     * @return The specified managed scaling policy for an Amazon EMR cluster.
     */
    public final ManagedScalingPolicy managedScalingPolicy() {
        return managedScalingPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementGroupConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPlacementGroupConfigs() {
        return placementGroupConfigs != null && !(placementGroupConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specified placement group configuration for an Amazon EMR cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementGroupConfigs} method.
     * </p>
     * 
     * @return The specified placement group configuration for an Amazon EMR cluster.
     */
    public final List<PlacementGroupConfig> placementGroupConfigs() {
        return placementGroupConfigs;
    }

    /**
     * Returns the value of the AutoTerminationPolicy property for this object.
     * 
     * @return The value of the AutoTerminationPolicy property for this object.
     */
    public final AutoTerminationPolicy autoTerminationPolicy() {
        return autoTerminationPolicy;
    }

    /**
     * <p>
     * Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a release is
     * not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
     * </p>
     * 
     * @return Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a
     *         release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
     */
    public final String osReleaseLabel() {
        return osReleaseLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(logEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(amiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBootstrapActions() ? bootstrapActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedProducts() ? supportedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNewSupportedProducts() ? newSupportedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowRole());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(scaleDownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsRootVolumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(repoUpgradeOnBootAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kerberosAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(stepConcurrencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(managedScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementGroupConfigs() ? placementGroupConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoTerminationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(osReleaseLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(logUri(), other.logUri())
                && Objects.equals(logEncryptionKmsKeyId(), other.logEncryptionKmsKeyId())
                && Objects.equals(additionalInfo(), other.additionalInfo()) && Objects.equals(amiVersion(), other.amiVersion())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(instances(), other.instances())
                && hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps())
                && hasBootstrapActions() == other.hasBootstrapActions()
                && Objects.equals(bootstrapActions(), other.bootstrapActions())
                && hasSupportedProducts() == other.hasSupportedProducts()
                && Objects.equals(supportedProducts(), other.supportedProducts())
                && hasNewSupportedProducts() == other.hasNewSupportedProducts()
                && Objects.equals(newSupportedProducts(), other.newSupportedProducts())
                && hasApplications() == other.hasApplications() && Objects.equals(applications(), other.applications())
                && hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations())
                && Objects.equals(visibleToAllUsers(), other.visibleToAllUsers())
                && Objects.equals(jobFlowRole(), other.jobFlowRole()) && Objects.equals(serviceRole(), other.serviceRole())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(autoScalingRole(), other.autoScalingRole())
                && Objects.equals(scaleDownBehaviorAsString(), other.scaleDownBehaviorAsString())
                && Objects.equals(customAmiId(), other.customAmiId())
                && Objects.equals(ebsRootVolumeSize(), other.ebsRootVolumeSize())
                && Objects.equals(repoUpgradeOnBootAsString(), other.repoUpgradeOnBootAsString())
                && Objects.equals(kerberosAttributes(), other.kerberosAttributes())
                && Objects.equals(stepConcurrencyLevel(), other.stepConcurrencyLevel())
                && Objects.equals(managedScalingPolicy(), other.managedScalingPolicy())
                && hasPlacementGroupConfigs() == other.hasPlacementGroupConfigs()
                && Objects.equals(placementGroupConfigs(), other.placementGroupConfigs())
                && Objects.equals(autoTerminationPolicy(), other.autoTerminationPolicy())
                && Objects.equals(osReleaseLabel(), other.osReleaseLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunJobFlowRequest").add("Name", name()).add("LogUri", logUri())
                .add("LogEncryptionKmsKeyId", logEncryptionKmsKeyId()).add("AdditionalInfo", additionalInfo())
                .add("AmiVersion", amiVersion()).add("ReleaseLabel", releaseLabel()).add("Instances", instances())
                .add("Steps", hasSteps() ? steps() : null)
                .add("BootstrapActions", hasBootstrapActions() ? bootstrapActions() : null)
                .add("SupportedProducts", hasSupportedProducts() ? supportedProducts() : null)
                .add("NewSupportedProducts", hasNewSupportedProducts() ? newSupportedProducts() : null)
                .add("Applications", hasApplications() ? applications() : null)
                .add("Configurations", hasConfigurations() ? configurations() : null)
                .add("VisibleToAllUsers", visibleToAllUsers()).add("JobFlowRole", jobFlowRole())
                .add("ServiceRole", serviceRole()).add("Tags", hasTags() ? tags() : null)
                .add("SecurityConfiguration", securityConfiguration()).add("AutoScalingRole", autoScalingRole())
                .add("ScaleDownBehavior", scaleDownBehaviorAsString()).add("CustomAmiId", customAmiId())
                .add("EbsRootVolumeSize", ebsRootVolumeSize()).add("RepoUpgradeOnBoot", repoUpgradeOnBootAsString())
                .add("KerberosAttributes", kerberosAttributes()).add("StepConcurrencyLevel", stepConcurrencyLevel())
                .add("ManagedScalingPolicy", managedScalingPolicy())
                .add("PlacementGroupConfigs", hasPlacementGroupConfigs() ? placementGroupConfigs() : null)
                .add("AutoTerminationPolicy", autoTerminationPolicy()).add("OSReleaseLabel", osReleaseLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LogUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "LogEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(logEncryptionKmsKeyId()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "AmiVersion":
            return Optional.ofNullable(clazz.cast(amiVersion()));
        case "ReleaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "BootstrapActions":
            return Optional.ofNullable(clazz.cast(bootstrapActions()));
        case "SupportedProducts":
            return Optional.ofNullable(clazz.cast(supportedProducts()));
        case "NewSupportedProducts":
            return Optional.ofNullable(clazz.cast(newSupportedProducts()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "VisibleToAllUsers":
            return Optional.ofNullable(clazz.cast(visibleToAllUsers()));
        case "JobFlowRole":
            return Optional.ofNullable(clazz.cast(jobFlowRole()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "AutoScalingRole":
            return Optional.ofNullable(clazz.cast(autoScalingRole()));
        case "ScaleDownBehavior":
            return Optional.ofNullable(clazz.cast(scaleDownBehaviorAsString()));
        case "CustomAmiId":
            return Optional.ofNullable(clazz.cast(customAmiId()));
        case "EbsRootVolumeSize":
            return Optional.ofNullable(clazz.cast(ebsRootVolumeSize()));
        case "RepoUpgradeOnBoot":
            return Optional.ofNullable(clazz.cast(repoUpgradeOnBootAsString()));
        case "KerberosAttributes":
            return Optional.ofNullable(clazz.cast(kerberosAttributes()));
        case "StepConcurrencyLevel":
            return Optional.ofNullable(clazz.cast(stepConcurrencyLevel()));
        case "ManagedScalingPolicy":
            return Optional.ofNullable(clazz.cast(managedScalingPolicy()));
        case "PlacementGroupConfigs":
            return Optional.ofNullable(clazz.cast(placementGroupConfigs()));
        case "AutoTerminationPolicy":
            return Optional.ofNullable(clazz.cast(autoTerminationPolicy()));
        case "OSReleaseLabel":
            return Optional.ofNullable(clazz.cast(osReleaseLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunJobFlowRequest, T> g) {
        return obj -> g.apply((RunJobFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, RunJobFlowRequest> {
        /**
         * <p>
         * The name of the job flow.
         * </p>
         * 
         * @param name
         *        The name of the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not
         * created.
         * </p>
         * 
         * @param logUri
         *        The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are
         *        not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256.
         * This attribute is only available with Amazon EMR releases 5.30.0 and later, excluding Amazon EMR 6.0.0.
         * </p>
         * 
         * @param logEncryptionKmsKeyId
         *        The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by
         *        AES-256. This attribute is only available with Amazon EMR releases 5.30.0 and later, excluding Amazon
         *        EMR 6.0.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId);

        /**
         * <p>
         * A JSON string for selecting additional features.
         * </p>
         * 
         * @param additionalInfo
         *        A JSON string for selecting additional features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later,
         * <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.
         * </p>
         * 
         * @param amiVersion
         *        Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later,
         *        <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiVersion(String amiVersion);

        /**
         * <p>
         * The Amazon EMR release label, which determines the version of open-source application packages installed on
         * the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release
         * version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included
         * application versions and features, see <a
         * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://
         * docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases
         * version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release label, which determines the version of open-source application packages
         *        installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an
         *        Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR
         *        release versions and included application versions and features, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"
         *        >https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon
         *        EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * A specification of the number and type of Amazon EC2 instances.
         * </p>
         * 
         * @param instances
         *        A specification of the number and type of Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(JobFlowInstancesConfig instances);

        /**
         * <p>
         * A specification of the number and type of Amazon EC2 instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobFlowInstancesConfig.Builder} avoiding
         * the need to create one manually via {@link JobFlowInstancesConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobFlowInstancesConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(JobFlowInstancesConfig)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link JobFlowInstancesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(JobFlowInstancesConfig)
         */
        default Builder instances(Consumer<JobFlowInstancesConfig.Builder> instances) {
            return instances(JobFlowInstancesConfig.builder().applyMutation(instances).build());
        }

        /**
         * <p>
         * A list of steps to run.
         * </p>
         * 
         * @param steps
         *        A list of steps to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<StepConfig> steps);

        /**
         * <p>
         * A list of steps to run.
         * </p>
         * 
         * @param steps
         *        A list of steps to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(StepConfig... steps);

        /**
         * <p>
         * A list of steps to run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.StepConfig.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.emr.model.StepConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.StepConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<StepConfig>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.StepConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<StepConfig>)
         */
        Builder steps(Consumer<StepConfig.Builder>... steps);

        /**
         * <p>
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * </p>
         * 
         * @param bootstrapActions
         *        A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapActions(Collection<BootstrapActionConfig> bootstrapActions);

        /**
         * <p>
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * </p>
         * 
         * @param bootstrapActions
         *        A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapActions(BootstrapActionConfig... bootstrapActions);

        /**
         * <p>
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.BootstrapActionConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.BootstrapActionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.BootstrapActionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #bootstrapActions(List<BootstrapActionConfig>)}.
         * 
         * @param bootstrapActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.BootstrapActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bootstrapActions(java.util.Collection<BootstrapActionConfig>)
         */
        Builder bootstrapActions(Consumer<BootstrapActionConfig.Builder>... bootstrapActions);

        /**
         * <note>
         * <p>
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         * </p>
         * </note>
         * <p>
         * A list of strings that indicates third-party software to use. For more information, see the <a
         * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
         * Currently supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "mapr-m3" - launch the job flow using MapR M3 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m5" - launch the job flow using MapR M5 Edition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param supportedProducts
         *        <p>
         *        For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *        </p>
         *        </note>
         *        <p>
         *        A list of strings that indicates third-party software to use. For more information, see the <a
         *        href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer
         *        Guide</a>. Currently supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "mapr-m3" - launch the job flow using MapR M3 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m5" - launch the job flow using MapR M5 Edition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedProducts(Collection<String> supportedProducts);

        /**
         * <note>
         * <p>
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         * </p>
         * </note>
         * <p>
         * A list of strings that indicates third-party software to use. For more information, see the <a
         * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
         * Currently supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "mapr-m3" - launch the job flow using MapR M3 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m5" - launch the job flow using MapR M5 Edition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param supportedProducts
         *        <p>
         *        For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *        </p>
         *        </note>
         *        <p>
         *        A list of strings that indicates third-party software to use. For more information, see the <a
         *        href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer
         *        Guide</a>. Currently supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "mapr-m3" - launch the job flow using MapR M3 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m5" - launch the job flow using MapR M5 Edition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedProducts(String... supportedProducts);

        /**
         * <note>
         * <p>
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         * </p>
         * </note>
         * <p>
         * A list of strings that indicates third-party software to use with the job flow that accepts a user argument
         * list. Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap
         * action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
         * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
         * Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "mapr-m3" - launch the cluster using MapR M3 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m5" - launch the cluster using MapR M5 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR
         * M3 or M5 Edition respectively.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m7" - launch the cluster using MapR M7 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hue"- launch the cluster with Hue installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "spark" - launch the cluster with Apache Spark installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newSupportedProducts
         *        <p>
         *        For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *        </p>
         *        </note>
         *        <p>
         *        A list of strings that indicates third-party software to use with the job flow that accepts a user
         *        argument list. Amazon EMR accepts and forwards the argument list to the corresponding installation
         *        script as bootstrap action arguments. For more information, see
         *        "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
         *        href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer
         *        Guide</a>. Supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "mapr-m3" - launch the cluster using MapR M3 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m5" - launch the cluster using MapR M5 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using
         *        MapR M3 or M5 Edition respectively.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m7" - launch the cluster using MapR M7 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "hue"- launch the cluster with Hue installed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "spark" - launch the cluster with Apache Spark installed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts);

        /**
         * <note>
         * <p>
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         * </p>
         * </note>
         * <p>
         * A list of strings that indicates third-party software to use with the job flow that accepts a user argument
         * list. Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap
         * action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
         * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
         * Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "mapr-m3" - launch the cluster using MapR M3 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m5" - launch the cluster using MapR M5 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR
         * M3 or M5 Edition respectively.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m7" - launch the cluster using MapR M7 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hue"- launch the cluster with Hue installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "spark" - launch the cluster with Apache Spark installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newSupportedProducts
         *        <p>
         *        For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         *        </p>
         *        </note>
         *        <p>
         *        A list of strings that indicates third-party software to use with the job flow that accepts a user
         *        argument list. Amazon EMR accepts and forwards the argument list to the corresponding installation
         *        script as bootstrap action arguments. For more information, see
         *        "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
         *        href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer
         *        Guide</a>. Supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "mapr-m3" - launch the cluster using MapR M3 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m5" - launch the cluster using MapR M5 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using
         *        MapR M3 or M5 Edition respectively.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mapr-m7" - launch the cluster using MapR M7 Edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "hue"- launch the cluster with Hue installed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "spark" - launch the cluster with Apache Spark installed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newSupportedProducts(SupportedProductConfig... newSupportedProducts);

        /**
         * <note>
         * <p>
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.
         * </p>
         * </note>
         * <p>
         * A list of strings that indicates third-party software to use with the job flow that accepts a user argument
         * list. Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap
         * action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a
         * href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>.
         * Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "mapr-m3" - launch the cluster using MapR M3 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m5" - launch the cluster using MapR M5 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR
         * M3 or M5 Edition respectively.
         * </p>
         * </li>
         * <li>
         * <p>
         * "mapr-m7" - launch the cluster using MapR M7 Edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * "hue"- launch the cluster with Hue installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "spark" - launch the cluster with Apache Spark installed.
         * </p>
         * </li>
         * <li>
         * <p>
         * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.SupportedProductConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.SupportedProductConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.SupportedProductConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #newSupportedProducts(List<SupportedProductConfig>)}.
         * 
         * @param newSupportedProducts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.SupportedProductConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newSupportedProducts(java.util.Collection<SupportedProductConfig>)
         */
        Builder newSupportedProducts(Consumer<SupportedProductConfig.Builder>... newSupportedProducts);

        /**
         * <p>
         * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to
         * install and configure when launching the cluster. For a list of applications available for each Amazon EMR
         * release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease
         * Guide</a>.
         * </p>
         * 
         * @param applications
         *        Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR
         *        to install and configure when launching the cluster. For a list of applications available for each
         *        Amazon EMR release version, see the <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<Application> applications);

        /**
         * <p>
         * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to
         * install and configure when launching the cluster. For a list of applications available for each Amazon EMR
         * release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease
         * Guide</a>.
         * </p>
         * 
         * @param applications
         *        Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR
         *        to install and configure when launching the cluster. For a list of applications available for each
         *        Amazon EMR release version, see the <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Application... applications);

        /**
         * <p>
         * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to
         * install and configure when launching the cluster. For a list of applications available for each Amazon EMR
         * release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease
         * Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Application.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.Application#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.Application.Builder#build()} is called immediately and its
         * result is passed to {@link #applications(List<Application>)}.
         * 
         * @param applications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.Application.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(java.util.Collection<Application>)
         */
        Builder applications(Consumer<Application.Builder>... applications);

        /**
         * <p>
         * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster that
         * you are creating.
         * </p>
         * 
         * @param configurations
         *        For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster
         *        that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<Configuration> configurations);

        /**
         * <p>
         * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster that
         * you are creating.
         * </p>
         * 
         * @param configurations
         *        For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster
         *        that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Configuration... configurations);

        /**
         * <p>
         * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the Amazon EMR cluster that
         * you are creating.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Configuration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configurations(List<Configuration>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(java.util.Collection<Configuration>)
         */
        Builder configurations(Consumer<Configuration.Builder>... configurations);

        /**
         * <important>
         * <p>
         * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>.
         * Setting it to <code>false</code> now has no effect.
         * </p>
         * </important>
         * <p>
         * Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with
         * the cluster can perform Amazon EMR actions on the cluster that their IAM policies allow. This value defaults
         * to <code>true</code> for clusters created using the Amazon EMR API or the CLI <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.
         * </p>
         * <p>
         * When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services
         * account root user can perform Amazon EMR actions for the cluster, regardless of the IAM permissions policies
         * attached to other IAM principals. For more information, see <a href=
         * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_IAM_emr-with-IAM.html#security_set_visible_to_all_users"
         * >Understanding the Amazon EMR cluster VisibleToAllUsers setting</a> in the <i>Amazon EMR Management
         * Guide</i>.
         * </p>
         * 
         * @param visibleToAllUsers
         *        <p>
         *        The VisibleToAllUsers parameter is no longer supported. By default, the value is set to
         *        <code>true</code>. Setting it to <code>false</code> now has no effect.
         *        </p>
         *        </important>
         *        <p>
         *        Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account
         *        associated with the cluster can perform Amazon EMR actions on the cluster that their IAM policies
         *        allow. This value defaults to <code>true</code> for clusters created using the Amazon EMR API or the
         *        CLI <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a>
         *        command.
         *        </p>
         *        <p>
         *        When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web
         *        Services account root user can perform Amazon EMR actions for the cluster, regardless of the IAM
         *        permissions policies attached to other IAM principals. For more information, see <a href=
         *        "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_IAM_emr-with-IAM.html#security_set_visible_to_all_users"
         *        >Understanding the Amazon EMR cluster VisibleToAllUsers setting</a> in the <i>Amazon EMR Management
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibleToAllUsers(Boolean visibleToAllUsers);

        /**
         * <p>
         * Also called instance profile and Amazon EC2 role. An IAM role for an Amazon EMR cluster. The Amazon EC2
         * instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to
         * use the default role, you must have already created it using the CLI or console.
         * </p>
         * 
         * @param jobFlowRole
         *        Also called instance profile and Amazon EC2 role. An IAM role for an Amazon EMR cluster. The Amazon
         *        EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>.
         *        In order to use the default role, you must have already created it using the CLI or console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowRole(String jobFlowRole);

        /**
         * <p>
         * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf. If
         * you've created a custom service role path, you must specify it for the service role when you launch your
         * cluster.
         * </p>
         * 
         * @param serviceRole
         *        The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.
         *        If you've created a custom service role path, you must specify it for the service role when you launch
         *        your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.emr.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.emr.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.emr.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of a security configuration to apply to the cluster.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of a security configuration to apply to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The
         * IAM role provides permissions that the automatic scaling feature requires to launch and terminate Amazon EC2
         * instances in an instance group.
         * </p>
         * 
         * @param autoScalingRole
         *        An IAM role for automatic scaling policies. The default role is
         *        <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling
         *        feature requires to launch and terminate Amazon EC2 instances in an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingRole(String autoScalingRole);

        /**
         * <p>
         * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs
         * or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates
         * nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted.
         * This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using
         * that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list
         * and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour
         * boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance
         * termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in
         * Amazon EMR releases 4.1.0 and later, and is the default for releases of Amazon EMR earlier than 5.1.0.
         * </p>
         * 
         * @param scaleDownBehavior
         *        Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity
         *        occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon
         *        EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the
         *        instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the
         *        default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates
         *        that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon
         *        EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the
         *        least active nodes first and blocks instance termination if it could lead to HDFS corruption.
         *        <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later, and
         *        is the default for releases of Amazon EMR earlier than 5.1.0.
         * @see ScaleDownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleDownBehavior
         */
        Builder scaleDownBehavior(String scaleDownBehavior);

        /**
         * <p>
         * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs
         * or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates
         * nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted.
         * This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using
         * that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list
         * and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour
         * boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance
         * termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in
         * Amazon EMR releases 4.1.0 and later, and is the default for releases of Amazon EMR earlier than 5.1.0.
         * </p>
         * 
         * @param scaleDownBehavior
         *        Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity
         *        occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon
         *        EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the
         *        instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the
         *        default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates
         *        that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon
         *        EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the
         *        least active nodes first and blocks instance termination if it could lead to HDFS corruption.
         *        <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR releases 4.1.0 and later, and
         *        is the default for releases of Amazon EMR earlier than 5.1.0.
         * @see ScaleDownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleDownBehavior
         */
        Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior);

        /**
         * <p>
         * Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If
         * specified, Amazon EMR uses this AMI when it launches cluster Amazon EC2 instances. For more information about
         * custom AMIs in Amazon EMR, see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in
         * the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the
         * <code>ReleaseLabel</code> specified. For Amazon EMR releases 2.x and 3.x, use <code>AmiVersion</code>
         * instead.
         * </p>
         * <p>
         * For information about creating a custom AMI, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon
         * EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For
         * information about finding an AMI ID, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>.
         * </p>
         * 
         * @param customAmiId
         *        Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI.
         *        If specified, Amazon EMR uses this AMI when it launches cluster Amazon EC2 instances. For more
         *        information about custom AMIs in Amazon EMR, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
         *        AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for
         *        the <code>ReleaseLabel</code> specified. For Amazon EMR releases 2.x and 3.x, use
         *        <code>AmiVersion</code> instead.</p>
         *        <p>
         *        For information about creating a custom AMI, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon
         *        EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.
         *        For information about finding an AMI ID, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
         *        AMI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiId(String customAmiId);

        /**
         * <p>
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2
         * instance. Available in Amazon EMR releases 4.x and later.
         * </p>
         * 
         * @param ebsRootVolumeSize
         *        The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon
         *        EC2 instance. Available in Amazon EMR releases 4.x and later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsRootVolumeSize(Integer ebsRootVolumeSize);

        /**
         * <p>
         * Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package
         * repositories to apply automatically when the instance boots using the AMI. If omitted, the default is
         * <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is
         * specified, no updates are applied, and all updates must be applied manually.
         * </p>
         * 
         * @param repoUpgradeOnBoot
         *        Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI
         *        package repositories to apply automatically when the instance boots using the AMI. If omitted, the
         *        default is <code>SECURITY</code>, which indicates that only security updates are applied. If
         *        <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.
         * @see RepoUpgradeOnBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepoUpgradeOnBoot
         */
        Builder repoUpgradeOnBoot(String repoUpgradeOnBoot);

        /**
         * <p>
         * Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package
         * repositories to apply automatically when the instance boots using the AMI. If omitted, the default is
         * <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is
         * specified, no updates are applied, and all updates must be applied manually.
         * </p>
         * 
         * @param repoUpgradeOnBoot
         *        Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI
         *        package repositories to apply automatically when the instance boots using the AMI. If omitted, the
         *        default is <code>SECURITY</code>, which indicates that only security updates are applied. If
         *        <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.
         * @see RepoUpgradeOnBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepoUpgradeOnBoot
         */
        Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot);

        /**
         * <p>
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * For more information see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         * Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * </p>
         * 
         * @param kerberosAttributes
         *        Attributes for Kerberos configuration when Kerberos authentication is enabled using a security
         *        configuration. For more information see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         *        Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kerberosAttributes(KerberosAttributes kerberosAttributes);

        /**
         * <p>
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * For more information see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         * Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link KerberosAttributes.Builder} avoiding the
         * need to create one manually via {@link KerberosAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KerberosAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #kerberosAttributes(KerberosAttributes)}.
         * 
         * @param kerberosAttributes
         *        a consumer that will call methods on {@link KerberosAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kerberosAttributes(KerberosAttributes)
         */
        default Builder kerberosAttributes(Consumer<KerberosAttributes.Builder> kerberosAttributes) {
            return kerberosAttributes(KerberosAttributes.builder().applyMutation(kerberosAttributes).build());
        }

        /**
         * <p>
         * Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The
         * maximum value is <code>256</code>.
         * </p>
         * 
         * @param stepConcurrencyLevel
         *        Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>.
         *        The maximum value is <code>256</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepConcurrencyLevel(Integer stepConcurrencyLevel);

        /**
         * <p>
         * The specified managed scaling policy for an Amazon EMR cluster.
         * </p>
         * 
         * @param managedScalingPolicy
         *        The specified managed scaling policy for an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy);

        /**
         * <p>
         * The specified managed scaling policy for an Amazon EMR cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedScalingPolicy.Builder} avoiding
         * the need to create one manually via {@link ManagedScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedScalingPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #managedScalingPolicy(ManagedScalingPolicy)}.
         * 
         * @param managedScalingPolicy
         *        a consumer that will call methods on {@link ManagedScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedScalingPolicy(ManagedScalingPolicy)
         */
        default Builder managedScalingPolicy(Consumer<ManagedScalingPolicy.Builder> managedScalingPolicy) {
            return managedScalingPolicy(ManagedScalingPolicy.builder().applyMutation(managedScalingPolicy).build());
        }

        /**
         * <p>
         * The specified placement group configuration for an Amazon EMR cluster.
         * </p>
         * 
         * @param placementGroupConfigs
         *        The specified placement group configuration for an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupConfigs(Collection<PlacementGroupConfig> placementGroupConfigs);

        /**
         * <p>
         * The specified placement group configuration for an Amazon EMR cluster.
         * </p>
         * 
         * @param placementGroupConfigs
         *        The specified placement group configuration for an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupConfigs(PlacementGroupConfig... placementGroupConfigs);

        /**
         * <p>
         * The specified placement group configuration for an Amazon EMR cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.PlacementGroupConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.PlacementGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.PlacementGroupConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #placementGroupConfigs(List<PlacementGroupConfig>)}.
         * 
         * @param placementGroupConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.PlacementGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementGroupConfigs(java.util.Collection<PlacementGroupConfig>)
         */
        Builder placementGroupConfigs(Consumer<PlacementGroupConfig.Builder>... placementGroupConfigs);

        /**
         * Sets the value of the AutoTerminationPolicy property for this object.
         *
         * @param autoTerminationPolicy
         *        The new value for the AutoTerminationPolicy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTerminationPolicy(AutoTerminationPolicy autoTerminationPolicy);

        /**
         * Sets the value of the AutoTerminationPolicy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoTerminationPolicy.Builder} avoiding
         * the need to create one manually via {@link AutoTerminationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTerminationPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTerminationPolicy(AutoTerminationPolicy)}.
         * 
         * @param autoTerminationPolicy
         *        a consumer that will call methods on {@link AutoTerminationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTerminationPolicy(AutoTerminationPolicy)
         */
        default Builder autoTerminationPolicy(Consumer<AutoTerminationPolicy.Builder> autoTerminationPolicy) {
            return autoTerminationPolicy(AutoTerminationPolicy.builder().applyMutation(autoTerminationPolicy).build());
        }

        /**
         * <p>
         * Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a
         * release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.
         * </p>
         * 
         * @param osReleaseLabel
         *        Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a
         *        release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster
         *        launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osReleaseLabel(String osReleaseLabel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String name;

        private String logUri;

        private String logEncryptionKmsKeyId;

        private String additionalInfo;

        private String amiVersion;

        private String releaseLabel;

        private JobFlowInstancesConfig instances;

        private List<StepConfig> steps = DefaultSdkAutoConstructList.getInstance();

        private List<BootstrapActionConfig> bootstrapActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedProducts = DefaultSdkAutoConstructList.getInstance();

        private List<SupportedProductConfig> newSupportedProducts = DefaultSdkAutoConstructList.getInstance();

        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();

        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean visibleToAllUsers;

        private String jobFlowRole;

        private String serviceRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String securityConfiguration;

        private String autoScalingRole;

        private String scaleDownBehavior;

        private String customAmiId;

        private Integer ebsRootVolumeSize;

        private String repoUpgradeOnBoot;

        private KerberosAttributes kerberosAttributes;

        private Integer stepConcurrencyLevel;

        private ManagedScalingPolicy managedScalingPolicy;

        private List<PlacementGroupConfig> placementGroupConfigs = DefaultSdkAutoConstructList.getInstance();

        private AutoTerminationPolicy autoTerminationPolicy;

        private String osReleaseLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(RunJobFlowRequest model) {
            super(model);
            name(model.name);
            logUri(model.logUri);
            logEncryptionKmsKeyId(model.logEncryptionKmsKeyId);
            additionalInfo(model.additionalInfo);
            amiVersion(model.amiVersion);
            releaseLabel(model.releaseLabel);
            instances(model.instances);
            steps(model.steps);
            bootstrapActions(model.bootstrapActions);
            supportedProducts(model.supportedProducts);
            newSupportedProducts(model.newSupportedProducts);
            applications(model.applications);
            configurations(model.configurations);
            visibleToAllUsers(model.visibleToAllUsers);
            jobFlowRole(model.jobFlowRole);
            serviceRole(model.serviceRole);
            tags(model.tags);
            securityConfiguration(model.securityConfiguration);
            autoScalingRole(model.autoScalingRole);
            scaleDownBehavior(model.scaleDownBehavior);
            customAmiId(model.customAmiId);
            ebsRootVolumeSize(model.ebsRootVolumeSize);
            repoUpgradeOnBoot(model.repoUpgradeOnBoot);
            kerberosAttributes(model.kerberosAttributes);
            stepConcurrencyLevel(model.stepConcurrencyLevel);
            managedScalingPolicy(model.managedScalingPolicy);
            placementGroupConfigs(model.placementGroupConfigs);
            autoTerminationPolicy(model.autoTerminationPolicy);
            osReleaseLabel(model.osReleaseLabel);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getLogEncryptionKmsKeyId() {
            return logEncryptionKmsKeyId;
        }

        public final void setLogEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
        }

        @Override
        public final Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final String getAmiVersion() {
            return amiVersion;
        }

        public final void setAmiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
        }

        @Override
        public final Builder amiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final JobFlowInstancesConfig.Builder getInstances() {
            return instances != null ? instances.toBuilder() : null;
        }

        public final void setInstances(JobFlowInstancesConfig.BuilderImpl instances) {
            this.instances = instances != null ? instances.build() : null;
        }

        @Override
        public final Builder instances(JobFlowInstancesConfig instances) {
            this.instances = instances;
            return this;
        }

        public final List<StepConfig.Builder> getSteps() {
            List<StepConfig.Builder> result = StepConfigListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepConfig.Builder>... steps) {
            steps(Stream.of(steps).map(c -> StepConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BootstrapActionConfig.Builder> getBootstrapActions() {
            List<BootstrapActionConfig.Builder> result = BootstrapActionConfigListCopier.copyToBuilder(this.bootstrapActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBootstrapActions(Collection<BootstrapActionConfig.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copyFromBuilder(bootstrapActions);
        }

        @Override
        public final Builder bootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(BootstrapActionConfig... bootstrapActions) {
            bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Consumer<BootstrapActionConfig.Builder>... bootstrapActions) {
            bootstrapActions(Stream.of(bootstrapActions).map(c -> BootstrapActionConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedProducts() {
            if (supportedProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedProducts;
        }

        public final void setSupportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
        }

        @Override
        public final Builder supportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedProducts(String... supportedProducts) {
            supportedProducts(Arrays.asList(supportedProducts));
            return this;
        }

        public final List<SupportedProductConfig.Builder> getNewSupportedProducts() {
            List<SupportedProductConfig.Builder> result = NewSupportedProductsListCopier.copyToBuilder(this.newSupportedProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNewSupportedProducts(Collection<SupportedProductConfig.BuilderImpl> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copyFromBuilder(newSupportedProducts);
        }

        @Override
        public final Builder newSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copy(newSupportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(SupportedProductConfig... newSupportedProducts) {
            newSupportedProducts(Arrays.asList(newSupportedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(Consumer<SupportedProductConfig.Builder>... newSupportedProducts) {
            newSupportedProducts(Stream.of(newSupportedProducts)
                    .map(c -> SupportedProductConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Application.Builder> getApplications() {
            List<Application.Builder> result = ApplicationListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationListCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder>... applications) {
            applications(Stream.of(applications).map(c -> Application.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder>... configurations) {
            configurations(Stream.of(configurations).map(c -> Configuration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getVisibleToAllUsers() {
            return visibleToAllUsers;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final String getJobFlowRole() {
            return jobFlowRole;
        }

        public final void setJobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
        }

        @Override
        public final Builder jobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getAutoScalingRole() {
            return autoScalingRole;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final String getScaleDownBehavior() {
            return scaleDownBehavior;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior == null ? null : scaleDownBehavior.toString());
            return this;
        }

        public final String getCustomAmiId() {
            return customAmiId;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final Integer getEbsRootVolumeSize() {
            return ebsRootVolumeSize;
        }

        public final void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
        }

        @Override
        public final Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        public final String getRepoUpgradeOnBoot() {
            return repoUpgradeOnBoot;
        }

        public final void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
        }

        @Override
        public final Builder repoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
            return this;
        }

        @Override
        public final Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot(repoUpgradeOnBoot == null ? null : repoUpgradeOnBoot.toString());
            return this;
        }

        public final KerberosAttributes.Builder getKerberosAttributes() {
            return kerberosAttributes != null ? kerberosAttributes.toBuilder() : null;
        }

        public final void setKerberosAttributes(KerberosAttributes.BuilderImpl kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes != null ? kerberosAttributes.build() : null;
        }

        @Override
        public final Builder kerberosAttributes(KerberosAttributes kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        public final Integer getStepConcurrencyLevel() {
            return stepConcurrencyLevel;
        }

        public final void setStepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
        }

        @Override
        public final Builder stepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        public final ManagedScalingPolicy.Builder getManagedScalingPolicy() {
            return managedScalingPolicy != null ? managedScalingPolicy.toBuilder() : null;
        }

        public final void setManagedScalingPolicy(ManagedScalingPolicy.BuilderImpl managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy != null ? managedScalingPolicy.build() : null;
        }

        @Override
        public final Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        public final List<PlacementGroupConfig.Builder> getPlacementGroupConfigs() {
            List<PlacementGroupConfig.Builder> result = PlacementGroupConfigListCopier.copyToBuilder(this.placementGroupConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementGroupConfigs(Collection<PlacementGroupConfig.BuilderImpl> placementGroupConfigs) {
            this.placementGroupConfigs = PlacementGroupConfigListCopier.copyFromBuilder(placementGroupConfigs);
        }

        @Override
        public final Builder placementGroupConfigs(Collection<PlacementGroupConfig> placementGroupConfigs) {
            this.placementGroupConfigs = PlacementGroupConfigListCopier.copy(placementGroupConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroupConfigs(PlacementGroupConfig... placementGroupConfigs) {
            placementGroupConfigs(Arrays.asList(placementGroupConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroupConfigs(Consumer<PlacementGroupConfig.Builder>... placementGroupConfigs) {
            placementGroupConfigs(Stream.of(placementGroupConfigs)
                    .map(c -> PlacementGroupConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoTerminationPolicy.Builder getAutoTerminationPolicy() {
            return autoTerminationPolicy != null ? autoTerminationPolicy.toBuilder() : null;
        }

        public final void setAutoTerminationPolicy(AutoTerminationPolicy.BuilderImpl autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy != null ? autoTerminationPolicy.build() : null;
        }

        @Override
        public final Builder autoTerminationPolicy(AutoTerminationPolicy autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        public final String getOsReleaseLabel() {
            return osReleaseLabel;
        }

        public final void setOsReleaseLabel(String osReleaseLabel) {
            this.osReleaseLabel = osReleaseLabel;
        }

        @Override
        public final Builder osReleaseLabel(String osReleaseLabel) {
            this.osReleaseLabel = osReleaseLabel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunJobFlowRequest build() {
            return new RunJobFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
