/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for an instance fleet modification request.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetModifyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetModifyConfig.Builder, InstanceFleetModifyConfig> {
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFleetId").getter(getter(InstanceFleetModifyConfig::instanceFleetId))
            .setter(setter(Builder::instanceFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()).build();

    private static final SdkField<Integer> TARGET_ON_DEMAND_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetOnDemandCapacity").getter(getter(InstanceFleetModifyConfig::targetOnDemandCapacity))
            .setter(setter(Builder::targetOnDemandCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDemandCapacity").build())
            .build();

    private static final SdkField<Integer> TARGET_SPOT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetSpotCapacity").getter(getter(InstanceFleetModifyConfig::targetSpotCapacity))
            .setter(setter(Builder::targetSpotCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSpotCapacity").build())
            .build();

    private static final SdkField<InstanceFleetResizingSpecifications> RESIZE_SPECIFICATIONS_FIELD = SdkField
            .<InstanceFleetResizingSpecifications> builder(MarshallingType.SDK_POJO).memberName("ResizeSpecifications")
            .getter(getter(InstanceFleetModifyConfig::resizeSpecifications)).setter(setter(Builder::resizeSpecifications))
            .constructor(InstanceFleetResizingSpecifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeSpecifications").build())
            .build();

    private static final SdkField<List<InstanceTypeConfig>> INSTANCE_TYPE_CONFIGS_FIELD = SdkField
            .<List<InstanceTypeConfig>> builder(MarshallingType.LIST)
            .memberName("InstanceTypeConfigs")
            .getter(getter(InstanceFleetModifyConfig::instanceTypeConfigs))
            .setter(setter(Builder::instanceTypeConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_FLEET_ID_FIELD, TARGET_ON_DEMAND_CAPACITY_FIELD, TARGET_SPOT_CAPACITY_FIELD,
                    RESIZE_SPECIFICATIONS_FIELD, INSTANCE_TYPE_CONFIGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceFleetId;

    private final Integer targetOnDemandCapacity;

    private final Integer targetSpotCapacity;

    private final InstanceFleetResizingSpecifications resizeSpecifications;

    private final List<InstanceTypeConfig> instanceTypeConfigs;

    private InstanceFleetModifyConfig(BuilderImpl builder) {
        this.instanceFleetId = builder.instanceFleetId;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.resizeSpecifications = builder.resizeSpecifications;
        this.instanceTypeConfigs = builder.instanceTypeConfigs;
    }

    /**
     * <p>
     * A unique identifier for the instance fleet.
     * </p>
     * 
     * @return A unique identifier for the instance fleet.
     */
    public final String instanceFleetId() {
        return instanceFleetId;
    }

    /**
     * <p>
     * The target capacity of On-Demand units for the instance fleet. For more information see
     * <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
     * </p>
     * 
     * @return The target capacity of On-Demand units for the instance fleet. For more information see
     *         <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
     */
    public final Integer targetOnDemandCapacity() {
        return targetOnDemandCapacity;
    }

    /**
     * <p>
     * The target capacity of Spot units for the instance fleet. For more information, see
     * <a>InstanceFleetConfig$TargetSpotCapacity</a>.
     * </p>
     * 
     * @return The target capacity of Spot units for the instance fleet. For more information, see
     *         <a>InstanceFleetConfig$TargetSpotCapacity</a>.
     */
    public final Integer targetSpotCapacity() {
        return targetSpotCapacity;
    }

    /**
     * <p>
     * The resize specification for the instance fleet.
     * </p>
     * 
     * @return The resize specification for the instance fleet.
     */
    public final InstanceFleetResizingSpecifications resizeSpecifications() {
        return resizeSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypeConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypeConfigs() {
        return instanceTypeConfigs != null && !(instanceTypeConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances when it
     * fulfills On-Demand and Spot capacities. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html">InstanceTypeConfig</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypeConfigs} method.
     * </p>
     * 
     * @return An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances when
     *         it fulfills On-Demand and Spot capacities. For more information, see <a
     *         href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
     *         >InstanceTypeConfig</a>.
     */
    public final List<InstanceTypeConfig> instanceTypeConfigs() {
        return instanceTypeConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(resizeSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypeConfigs() ? instanceTypeConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetModifyConfig)) {
            return false;
        }
        InstanceFleetModifyConfig other = (InstanceFleetModifyConfig) obj;
        return Objects.equals(instanceFleetId(), other.instanceFleetId())
                && Objects.equals(targetOnDemandCapacity(), other.targetOnDemandCapacity())
                && Objects.equals(targetSpotCapacity(), other.targetSpotCapacity())
                && Objects.equals(resizeSpecifications(), other.resizeSpecifications())
                && hasInstanceTypeConfigs() == other.hasInstanceTypeConfigs()
                && Objects.equals(instanceTypeConfigs(), other.instanceTypeConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceFleetModifyConfig").add("InstanceFleetId", instanceFleetId())
                .add("TargetOnDemandCapacity", targetOnDemandCapacity()).add("TargetSpotCapacity", targetSpotCapacity())
                .add("ResizeSpecifications", resizeSpecifications())
                .add("InstanceTypeConfigs", hasInstanceTypeConfigs() ? instanceTypeConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFleetId":
            return Optional.ofNullable(clazz.cast(instanceFleetId()));
        case "TargetOnDemandCapacity":
            return Optional.ofNullable(clazz.cast(targetOnDemandCapacity()));
        case "TargetSpotCapacity":
            return Optional.ofNullable(clazz.cast(targetSpotCapacity()));
        case "ResizeSpecifications":
            return Optional.ofNullable(clazz.cast(resizeSpecifications()));
        case "InstanceTypeConfigs":
            return Optional.ofNullable(clazz.cast(instanceTypeConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetModifyConfig, T> g) {
        return obj -> g.apply((InstanceFleetModifyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetModifyConfig> {
        /**
         * <p>
         * A unique identifier for the instance fleet.
         * </p>
         * 
         * @param instanceFleetId
         *        A unique identifier for the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleetId(String instanceFleetId);

        /**
         * <p>
         * The target capacity of On-Demand units for the instance fleet. For more information see
         * <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
         * </p>
         * 
         * @param targetOnDemandCapacity
         *        The target capacity of On-Demand units for the instance fleet. For more information see
         *        <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOnDemandCapacity(Integer targetOnDemandCapacity);

        /**
         * <p>
         * The target capacity of Spot units for the instance fleet. For more information, see
         * <a>InstanceFleetConfig$TargetSpotCapacity</a>.
         * </p>
         * 
         * @param targetSpotCapacity
         *        The target capacity of Spot units for the instance fleet. For more information, see
         *        <a>InstanceFleetConfig$TargetSpotCapacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSpotCapacity(Integer targetSpotCapacity);

        /**
         * <p>
         * The resize specification for the instance fleet.
         * </p>
         * 
         * @param resizeSpecifications
         *        The resize specification for the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeSpecifications(InstanceFleetResizingSpecifications resizeSpecifications);

        /**
         * <p>
         * The resize specification for the instance fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceFleetResizingSpecifications.Builder} avoiding the need to create one manually via
         * {@link InstanceFleetResizingSpecifications#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceFleetResizingSpecifications.Builder#build()} is called
         * immediately and its result is passed to {@link #resizeSpecifications(InstanceFleetResizingSpecifications)}.
         * 
         * @param resizeSpecifications
         *        a consumer that will call methods on {@link InstanceFleetResizingSpecifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resizeSpecifications(InstanceFleetResizingSpecifications)
         */
        default Builder resizeSpecifications(Consumer<InstanceFleetResizingSpecifications.Builder> resizeSpecifications) {
            return resizeSpecifications(InstanceFleetResizingSpecifications.builder().applyMutation(resizeSpecifications).build());
        }

        /**
         * <p>
         * An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances when it
         * fulfills On-Demand and Spot capacities. For more information, see <a
         * href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
         * >InstanceTypeConfig</a>.
         * </p>
         * 
         * @param instanceTypeConfigs
         *        An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances
         *        when it fulfills On-Demand and Spot capacities. For more information, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
         *        >InstanceTypeConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs);

        /**
         * <p>
         * An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances when it
         * fulfills On-Demand and Spot capacities. For more information, see <a
         * href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
         * >InstanceTypeConfig</a>.
         * </p>
         * 
         * @param instanceTypeConfigs
         *        An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances
         *        when it fulfills On-Demand and Spot capacities. For more information, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
         *        >InstanceTypeConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeConfigs(InstanceTypeConfig... instanceTypeConfigs);

        /**
         * <p>
         * An array of InstanceTypeConfig objects that specify how Amazon EMR provisions Amazon EC2 instances when it
         * fulfills On-Demand and Spot capacities. For more information, see <a
         * href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html"
         * >InstanceTypeConfig</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.InstanceTypeConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.InstanceTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.InstanceTypeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceTypeConfigs(List<InstanceTypeConfig>)}.
         * 
         * @param instanceTypeConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.InstanceTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTypeConfigs(java.util.Collection<InstanceTypeConfig>)
         */
        Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder>... instanceTypeConfigs);
    }

    static final class BuilderImpl implements Builder {
        private String instanceFleetId;

        private Integer targetOnDemandCapacity;

        private Integer targetSpotCapacity;

        private InstanceFleetResizingSpecifications resizeSpecifications;

        private List<InstanceTypeConfig> instanceTypeConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetModifyConfig model) {
            instanceFleetId(model.instanceFleetId);
            targetOnDemandCapacity(model.targetOnDemandCapacity);
            targetSpotCapacity(model.targetSpotCapacity);
            resizeSpecifications(model.resizeSpecifications);
            instanceTypeConfigs(model.instanceTypeConfigs);
        }

        public final String getInstanceFleetId() {
            return instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final Integer getTargetOnDemandCapacity() {
            return targetOnDemandCapacity;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final Integer getTargetSpotCapacity() {
            return targetSpotCapacity;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final InstanceFleetResizingSpecifications.Builder getResizeSpecifications() {
            return resizeSpecifications != null ? resizeSpecifications.toBuilder() : null;
        }

        public final void setResizeSpecifications(InstanceFleetResizingSpecifications.BuilderImpl resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications != null ? resizeSpecifications.build() : null;
        }

        @Override
        public final Builder resizeSpecifications(InstanceFleetResizingSpecifications resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications;
            return this;
        }

        public final List<InstanceTypeConfig.Builder> getInstanceTypeConfigs() {
            List<InstanceTypeConfig.Builder> result = InstanceTypeConfigListCopier.copyToBuilder(this.instanceTypeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeConfigs(Collection<InstanceTypeConfig.BuilderImpl> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copyFromBuilder(instanceTypeConfigs);
        }

        @Override
        public final Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(InstanceTypeConfig... instanceTypeConfigs) {
            instanceTypeConfigs(Arrays.asList(instanceTypeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder>... instanceTypeConfigs) {
            instanceTypeConfigs(Stream.of(instanceTypeConfigs).map(c -> InstanceTypeConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceFleetModifyConfig build() {
            return new InstanceFleetModifyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
