/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resize specification for On-Demand and Spot Instances in the fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetResizingSpecifications implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetResizingSpecifications.Builder, InstanceFleetResizingSpecifications> {
    private static final SdkField<SpotResizingSpecification> SPOT_RESIZE_SPECIFICATION_FIELD = SdkField
            .<SpotResizingSpecification> builder(MarshallingType.SDK_POJO).memberName("SpotResizeSpecification")
            .getter(getter(InstanceFleetResizingSpecifications::spotResizeSpecification))
            .setter(setter(Builder::spotResizeSpecification)).constructor(SpotResizingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotResizeSpecification").build())
            .build();

    private static final SdkField<OnDemandResizingSpecification> ON_DEMAND_RESIZE_SPECIFICATION_FIELD = SdkField
            .<OnDemandResizingSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("OnDemandResizeSpecification")
            .getter(getter(InstanceFleetResizingSpecifications::onDemandResizeSpecification))
            .setter(setter(Builder::onDemandResizeSpecification))
            .constructor(OnDemandResizingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandResizeSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SPOT_RESIZE_SPECIFICATION_FIELD, ON_DEMAND_RESIZE_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SpotResizingSpecification spotResizeSpecification;

    private final OnDemandResizingSpecification onDemandResizeSpecification;

    private InstanceFleetResizingSpecifications(BuilderImpl builder) {
        this.spotResizeSpecification = builder.spotResizeSpecification;
        this.onDemandResizeSpecification = builder.onDemandResizeSpecification;
    }

    /**
     * <p>
     * The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and the
     * resize timeout period.
     * </p>
     * 
     * @return The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy
     *         and the resize timeout period.
     */
    public final SpotResizingSpecification spotResizeSpecification() {
        return spotResizeSpecification;
    }

    /**
     * <p>
     * The resize specification for On-Demand Instances in the instance fleet, which contains the allocation strategy,
     * capacity reservation options, and the resize timeout period.
     * </p>
     * 
     * @return The resize specification for On-Demand Instances in the instance fleet, which contains the allocation
     *         strategy, capacity reservation options, and the resize timeout period.
     */
    public final OnDemandResizingSpecification onDemandResizeSpecification() {
        return onDemandResizeSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotResizeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandResizeSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetResizingSpecifications)) {
            return false;
        }
        InstanceFleetResizingSpecifications other = (InstanceFleetResizingSpecifications) obj;
        return Objects.equals(spotResizeSpecification(), other.spotResizeSpecification())
                && Objects.equals(onDemandResizeSpecification(), other.onDemandResizeSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceFleetResizingSpecifications").add("SpotResizeSpecification", spotResizeSpecification())
                .add("OnDemandResizeSpecification", onDemandResizeSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotResizeSpecification":
            return Optional.ofNullable(clazz.cast(spotResizeSpecification()));
        case "OnDemandResizeSpecification":
            return Optional.ofNullable(clazz.cast(onDemandResizeSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetResizingSpecifications, T> g) {
        return obj -> g.apply((InstanceFleetResizingSpecifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetResizingSpecifications> {
        /**
         * <p>
         * The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and
         * the resize timeout period.
         * </p>
         * 
         * @param spotResizeSpecification
         *        The resize specification for Spot Instances in the instance fleet, which contains the allocation
         *        strategy and the resize timeout period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotResizeSpecification(SpotResizingSpecification spotResizeSpecification);

        /**
         * <p>
         * The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and
         * the resize timeout period.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotResizingSpecification.Builder}
         * avoiding the need to create one manually via {@link SpotResizingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotResizingSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #spotResizeSpecification(SpotResizingSpecification)}.
         * 
         * @param spotResizeSpecification
         *        a consumer that will call methods on {@link SpotResizingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotResizeSpecification(SpotResizingSpecification)
         */
        default Builder spotResizeSpecification(Consumer<SpotResizingSpecification.Builder> spotResizeSpecification) {
            return spotResizeSpecification(SpotResizingSpecification.builder().applyMutation(spotResizeSpecification).build());
        }

        /**
         * <p>
         * The resize specification for On-Demand Instances in the instance fleet, which contains the allocation
         * strategy, capacity reservation options, and the resize timeout period.
         * </p>
         * 
         * @param onDemandResizeSpecification
         *        The resize specification for On-Demand Instances in the instance fleet, which contains the allocation
         *        strategy, capacity reservation options, and the resize timeout period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandResizeSpecification(OnDemandResizingSpecification onDemandResizeSpecification);

        /**
         * <p>
         * The resize specification for On-Demand Instances in the instance fleet, which contains the allocation
         * strategy, capacity reservation options, and the resize timeout period.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDemandResizingSpecification.Builder}
         * avoiding the need to create one manually via {@link OnDemandResizingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandResizingSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #onDemandResizeSpecification(OnDemandResizingSpecification)}.
         * 
         * @param onDemandResizeSpecification
         *        a consumer that will call methods on {@link OnDemandResizingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandResizeSpecification(OnDemandResizingSpecification)
         */
        default Builder onDemandResizeSpecification(Consumer<OnDemandResizingSpecification.Builder> onDemandResizeSpecification) {
            return onDemandResizeSpecification(OnDemandResizingSpecification.builder().applyMutation(onDemandResizeSpecification)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpotResizingSpecification spotResizeSpecification;

        private OnDemandResizingSpecification onDemandResizeSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetResizingSpecifications model) {
            spotResizeSpecification(model.spotResizeSpecification);
            onDemandResizeSpecification(model.onDemandResizeSpecification);
        }

        public final SpotResizingSpecification.Builder getSpotResizeSpecification() {
            return spotResizeSpecification != null ? spotResizeSpecification.toBuilder() : null;
        }

        public final void setSpotResizeSpecification(SpotResizingSpecification.BuilderImpl spotResizeSpecification) {
            this.spotResizeSpecification = spotResizeSpecification != null ? spotResizeSpecification.build() : null;
        }

        @Override
        public final Builder spotResizeSpecification(SpotResizingSpecification spotResizeSpecification) {
            this.spotResizeSpecification = spotResizeSpecification;
            return this;
        }

        public final OnDemandResizingSpecification.Builder getOnDemandResizeSpecification() {
            return onDemandResizeSpecification != null ? onDemandResizeSpecification.toBuilder() : null;
        }

        public final void setOnDemandResizeSpecification(OnDemandResizingSpecification.BuilderImpl onDemandResizeSpecification) {
            this.onDemandResizeSpecification = onDemandResizeSpecification != null ? onDemandResizeSpecification.build() : null;
        }

        @Override
        public final Builder onDemandResizeSpecification(OnDemandResizingSpecification onDemandResizeSpecification) {
            this.onDemandResizeSpecification = onDemandResizeSpecification;
            return this;
        }

        @Override
        public InstanceFleetResizingSpecifications build() {
            return new InstanceFleetResizingSpecifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
