/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetStatus;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecification;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFleet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InstanceFleet.getter(InstanceFleet::id)).setter(InstanceFleet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InstanceFleet.getter(InstanceFleet::name)).setter(InstanceFleet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<InstanceFleetStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(InstanceFleet.getter(InstanceFleet::status)).setter(InstanceFleet.setter(Builder::status)).constructor(InstanceFleetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetType").getter(InstanceFleet.getter(InstanceFleet::instanceFleetTypeAsString)).setter(InstanceFleet.setter(Builder::instanceFleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetType").build()}).build();
    private static final SdkField<Integer> TARGET_ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetOnDemandCapacity").getter(InstanceFleet.getter(InstanceFleet::targetOnDemandCapacity)).setter(InstanceFleet.setter(Builder::targetOnDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDemandCapacity").build()}).build();
    private static final SdkField<Integer> TARGET_SPOT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetSpotCapacity").getter(InstanceFleet.getter(InstanceFleet::targetSpotCapacity)).setter(InstanceFleet.setter(Builder::targetSpotCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSpotCapacity").build()}).build();
    private static final SdkField<Integer> PROVISIONED_ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProvisionedOnDemandCapacity").getter(InstanceFleet.getter(InstanceFleet::provisionedOnDemandCapacity)).setter(InstanceFleet.setter(Builder::provisionedOnDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedOnDemandCapacity").build()}).build();
    private static final SdkField<Integer> PROVISIONED_SPOT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProvisionedSpotCapacity").getter(InstanceFleet.getter(InstanceFleet::provisionedSpotCapacity)).setter(InstanceFleet.setter(Builder::provisionedSpotCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedSpotCapacity").build()}).build();
    private static final SdkField<List<InstanceTypeSpecification>> INSTANCE_TYPE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypeSpecifications").getter(InstanceFleet.getter(InstanceFleet::instanceTypeSpecifications)).setter(InstanceFleet.setter(Builder::instanceTypeSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceFleetProvisioningSpecifications> LAUNCH_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchSpecifications").getter(InstanceFleet.getter(InstanceFleet::launchSpecifications)).setter(InstanceFleet.setter(Builder::launchSpecifications)).constructor(InstanceFleetProvisioningSpecifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecifications").build()}).build();
    private static final SdkField<InstanceFleetResizingSpecifications> RESIZE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResizeSpecifications").getter(InstanceFleet.getter(InstanceFleet::resizeSpecifications)).setter(InstanceFleet.setter(Builder::resizeSpecifications)).constructor(InstanceFleetResizingSpecifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeSpecifications").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(InstanceFleet.getter(InstanceFleet::context)).setter(InstanceFleet.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATUS_FIELD, INSTANCE_FLEET_TYPE_FIELD, TARGET_ON_DEMAND_CAPACITY_FIELD, TARGET_SPOT_CAPACITY_FIELD, PROVISIONED_ON_DEMAND_CAPACITY_FIELD, PROVISIONED_SPOT_CAPACITY_FIELD, INSTANCE_TYPE_SPECIFICATIONS_FIELD, LAUNCH_SPECIFICATIONS_FIELD, RESIZE_SPECIFICATIONS_FIELD, CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("InstanceFleetType", INSTANCE_FLEET_TYPE_FIELD);
            this.put("TargetOnDemandCapacity", TARGET_ON_DEMAND_CAPACITY_FIELD);
            this.put("TargetSpotCapacity", TARGET_SPOT_CAPACITY_FIELD);
            this.put("ProvisionedOnDemandCapacity", PROVISIONED_ON_DEMAND_CAPACITY_FIELD);
            this.put("ProvisionedSpotCapacity", PROVISIONED_SPOT_CAPACITY_FIELD);
            this.put("InstanceTypeSpecifications", INSTANCE_TYPE_SPECIFICATIONS_FIELD);
            this.put("LaunchSpecifications", LAUNCH_SPECIFICATIONS_FIELD);
            this.put("ResizeSpecifications", RESIZE_SPECIFICATIONS_FIELD);
            this.put("Context", CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final InstanceFleetStatus status;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final Integer provisionedOnDemandCapacity;
    private final Integer provisionedSpotCapacity;
    private final List<InstanceTypeSpecification> instanceTypeSpecifications;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;
    private final InstanceFleetResizingSpecifications resizeSpecifications;
    private final String context;

    private InstanceFleet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.provisionedOnDemandCapacity = builder.provisionedOnDemandCapacity;
        this.provisionedSpotCapacity = builder.provisionedSpotCapacity;
        this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
        this.launchSpecifications = builder.launchSpecifications;
        this.resizeSpecifications = builder.resizeSpecifications;
        this.context = builder.context;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final InstanceFleetStatus status() {
        return this.status;
    }

    public final InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public final String instanceFleetTypeAsString() {
        return this.instanceFleetType;
    }

    public final Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public final Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public final Integer provisionedOnDemandCapacity() {
        return this.provisionedOnDemandCapacity;
    }

    public final Integer provisionedSpotCapacity() {
        return this.provisionedSpotCapacity;
    }

    public final boolean hasInstanceTypeSpecifications() {
        return this.instanceTypeSpecifications != null && !(this.instanceTypeSpecifications instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeSpecification> instanceTypeSpecifications() {
        return this.instanceTypeSpecifications;
    }

    public final InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public final InstanceFleetResizingSpecifications resizeSpecifications() {
        return this.resizeSpecifications;
    }

    public final String context() {
        return this.context;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.resizeSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleet)) {
            return false;
        }
        InstanceFleet other = (InstanceFleet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.instanceFleetTypeAsString(), other.instanceFleetTypeAsString()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity()) && Objects.equals(this.provisionedOnDemandCapacity(), other.provisionedOnDemandCapacity()) && Objects.equals(this.provisionedSpotCapacity(), other.provisionedSpotCapacity()) && this.hasInstanceTypeSpecifications() == other.hasInstanceTypeSpecifications() && Objects.equals(this.instanceTypeSpecifications(), other.instanceTypeSpecifications()) && Objects.equals(this.launchSpecifications(), other.launchSpecifications()) && Objects.equals(this.resizeSpecifications(), other.resizeSpecifications()) && Objects.equals(this.context(), other.context());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceFleet").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("InstanceFleetType", (Object)this.instanceFleetTypeAsString()).add("TargetOnDemandCapacity", (Object)this.targetOnDemandCapacity()).add("TargetSpotCapacity", (Object)this.targetSpotCapacity()).add("ProvisionedOnDemandCapacity", (Object)this.provisionedOnDemandCapacity()).add("ProvisionedSpotCapacity", (Object)this.provisionedSpotCapacity()).add("InstanceTypeSpecifications", this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null).add("LaunchSpecifications", (Object)this.launchSpecifications()).add("ResizeSpecifications", (Object)this.resizeSpecifications()).add("Context", (Object)this.context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "InstanceFleetType": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetTypeAsString()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetSpotCapacity()));
            }
            case "ProvisionedOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedOnDemandCapacity()));
            }
            case "ProvisionedSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedSpotCapacity()));
            }
            case "InstanceTypeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeSpecifications()));
            }
            case "LaunchSpecifications": {
                return Optional.ofNullable(clazz.cast(this.launchSpecifications()));
            }
            case "ResizeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.resizeSpecifications()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleet, T> g) {
        return obj -> g.apply((InstanceFleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private InstanceFleetStatus status;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private Integer provisionedOnDemandCapacity;
        private Integer provisionedSpotCapacity;
        private List<InstanceTypeSpecification> instanceTypeSpecifications = DefaultSdkAutoConstructList.getInstance();
        private InstanceFleetProvisioningSpecifications launchSpecifications;
        private InstanceFleetResizingSpecifications resizeSpecifications;
        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleet model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.instanceFleetType(model.instanceFleetType);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.provisionedOnDemandCapacity(model.provisionedOnDemandCapacity);
            this.provisionedSpotCapacity(model.provisionedSpotCapacity);
            this.instanceTypeSpecifications(model.instanceTypeSpecifications);
            this.launchSpecifications(model.launchSpecifications);
            this.resizeSpecifications(model.resizeSpecifications);
            this.context(model.context);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InstanceFleetStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(InstanceFleetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(InstanceFleetStatus status) {
            this.status = status;
            return this;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType == null ? null : instanceFleetType.toString());
            return this;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final Integer getProvisionedOnDemandCapacity() {
            return this.provisionedOnDemandCapacity;
        }

        public final void setProvisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
        }

        @Override
        public final Builder provisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
            return this;
        }

        public final Integer getProvisionedSpotCapacity() {
            return this.provisionedSpotCapacity;
        }

        public final void setProvisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
        }

        @Override
        public final Builder provisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
            return this;
        }

        public final List<InstanceTypeSpecification.Builder> getInstanceTypeSpecifications() {
            List<InstanceTypeSpecification.Builder> result = InstanceTypeSpecificationListCopier.copyToBuilder(this.instanceTypeSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeSpecifications(Collection<InstanceTypeSpecification.BuilderImpl> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copyFromBuilder(instanceTypeSpecifications);
        }

        @Override
        public final Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copy(instanceTypeSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(InstanceTypeSpecification ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Arrays.asList(instanceTypeSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(Consumer<InstanceTypeSpecification.Builder> ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Stream.of(instanceTypeSpecifications).map(c -> (InstanceTypeSpecification)((InstanceTypeSpecification.Builder)InstanceTypeSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceFleetProvisioningSpecifications.Builder getLaunchSpecifications() {
            return this.launchSpecifications != null ? this.launchSpecifications.toBuilder() : null;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications.BuilderImpl launchSpecifications) {
            this.launchSpecifications = launchSpecifications != null ? launchSpecifications.build() : null;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final InstanceFleetResizingSpecifications.Builder getResizeSpecifications() {
            return this.resizeSpecifications != null ? this.resizeSpecifications.toBuilder() : null;
        }

        public final void setResizeSpecifications(InstanceFleetResizingSpecifications.BuilderImpl resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications != null ? resizeSpecifications.build() : null;
        }

        @Override
        public final Builder resizeSpecifications(InstanceFleetResizingSpecifications resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public InstanceFleet build() {
            return new InstanceFleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFleet> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(InstanceFleetStatus var1);

        default public Builder status(Consumer<InstanceFleetStatus.Builder> status) {
            return this.status((InstanceFleetStatus)((InstanceFleetStatus.Builder)InstanceFleetStatus.builder().applyMutation(status)).build());
        }

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder provisionedOnDemandCapacity(Integer var1);

        public Builder provisionedSpotCapacity(Integer var1);

        public Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> var1);

        public Builder instanceTypeSpecifications(InstanceTypeSpecification ... var1);

        public Builder instanceTypeSpecifications(Consumer<InstanceTypeSpecification.Builder> ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);

        default public Builder launchSpecifications(Consumer<InstanceFleetProvisioningSpecifications.Builder> launchSpecifications) {
            return this.launchSpecifications((InstanceFleetProvisioningSpecifications)((InstanceFleetProvisioningSpecifications.Builder)InstanceFleetProvisioningSpecifications.builder().applyMutation(launchSpecifications)).build());
        }

        public Builder resizeSpecifications(InstanceFleetResizingSpecifications var1);

        default public Builder resizeSpecifications(Consumer<InstanceFleetResizingSpecifications.Builder> resizeSpecifications) {
            return this.resizeSpecifications((InstanceFleetResizingSpecifications)((InstanceFleetResizingSpecifications.Builder)InstanceFleetResizingSpecifications.builder().applyMutation(resizeSpecifications)).build());
        }

        public Builder context(String var1);
    }
}

