/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions;
import software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandProvisioningSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandProvisioningSpecification> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(OnDemandProvisioningSpecification.getter(OnDemandProvisioningSpecification::allocationStrategyAsString)).setter(OnDemandProvisioningSpecification.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").build()}).build();
    private static final SdkField<OnDemandCapacityReservationOptions> CAPACITY_RESERVATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationOptions").getter(OnDemandProvisioningSpecification.getter(OnDemandProvisioningSpecification::capacityReservationOptions)).setter(OnDemandProvisioningSpecification.setter(Builder::capacityReservationOptions)).constructor(OnDemandCapacityReservationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, CAPACITY_RESERVATION_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllocationStrategy", ALLOCATION_STRATEGY_FIELD);
            this.put("CapacityReservationOptions", CAPACITY_RESERVATION_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final OnDemandCapacityReservationOptions capacityReservationOptions;

    private OnDemandProvisioningSpecification(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.capacityReservationOptions = builder.capacityReservationOptions;
    }

    public final OnDemandProvisioningAllocationStrategy allocationStrategy() {
        return OnDemandProvisioningAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final OnDemandCapacityReservationOptions capacityReservationOptions() {
        return this.capacityReservationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandProvisioningSpecification)) {
            return false;
        }
        OnDemandProvisioningSpecification other = (OnDemandProvisioningSpecification)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.capacityReservationOptions(), other.capacityReservationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"OnDemandProvisioningSpecification").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("CapacityReservationOptions", (Object)this.capacityReservationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "CapacityReservationOptions": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandProvisioningSpecification, T> g) {
        return obj -> g.apply((OnDemandProvisioningSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private OnDemandCapacityReservationOptions capacityReservationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandProvisioningSpecification model) {
            this.allocationStrategy(model.allocationStrategy);
            this.capacityReservationOptions(model.capacityReservationOptions);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(OnDemandProvisioningAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final OnDemandCapacityReservationOptions.Builder getCapacityReservationOptions() {
            return this.capacityReservationOptions != null ? this.capacityReservationOptions.toBuilder() : null;
        }

        public final void setCapacityReservationOptions(OnDemandCapacityReservationOptions.BuilderImpl capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions != null ? capacityReservationOptions.build() : null;
        }

        @Override
        public final Builder capacityReservationOptions(OnDemandCapacityReservationOptions capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions;
            return this;
        }

        public OnDemandProvisioningSpecification build() {
            return new OnDemandProvisioningSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandProvisioningSpecification> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(OnDemandProvisioningAllocationStrategy var1);

        public Builder capacityReservationOptions(OnDemandCapacityReservationOptions var1);

        default public Builder capacityReservationOptions(Consumer<OnDemandCapacityReservationOptions.Builder> capacityReservationOptions) {
            return this.capacityReservationOptions((OnDemandCapacityReservationOptions)((OnDemandCapacityReservationOptions.Builder)OnDemandCapacityReservationOptions.builder().applyMutation(capacityReservationOptions)).build());
        }
    }
}

