/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsBlockDeviceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsBlockDeviceConfig> {
    private static final SdkField<VolumeSpecification> VOLUME_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VolumeSpecification").getter(EbsBlockDeviceConfig.getter(EbsBlockDeviceConfig::volumeSpecification)).setter(EbsBlockDeviceConfig.setter(Builder::volumeSpecification)).constructor(VolumeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSpecification").build()}).build();
    private static final SdkField<Integer> VOLUMES_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumesPerInstance").getter(EbsBlockDeviceConfig.getter(EbsBlockDeviceConfig::volumesPerInstance)).setter(EbsBlockDeviceConfig.setter(Builder::volumesPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumesPerInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SPECIFICATION_FIELD, VOLUMES_PER_INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VolumeSpecification", VOLUME_SPECIFICATION_FIELD);
            this.put("VolumesPerInstance", VOLUMES_PER_INSTANCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VolumeSpecification volumeSpecification;
    private final Integer volumesPerInstance;

    private EbsBlockDeviceConfig(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.volumesPerInstance = builder.volumesPerInstance;
    }

    public final VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public final Integer volumesPerInstance() {
        return this.volumesPerInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumesPerInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDeviceConfig)) {
            return false;
        }
        EbsBlockDeviceConfig other = (EbsBlockDeviceConfig)obj;
        return Objects.equals(this.volumeSpecification(), other.volumeSpecification()) && Objects.equals(this.volumesPerInstance(), other.volumesPerInstance());
    }

    public final String toString() {
        return ToString.builder((String)"EbsBlockDeviceConfig").add("VolumeSpecification", (Object)this.volumeSpecification()).add("VolumesPerInstance", (Object)this.volumesPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSpecification": {
                return Optional.ofNullable(clazz.cast(this.volumeSpecification()));
            }
            case "VolumesPerInstance": {
                return Optional.ofNullable(clazz.cast(this.volumesPerInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDeviceConfig, T> g) {
        return obj -> g.apply((EbsBlockDeviceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private Integer volumesPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDeviceConfig model) {
            this.volumeSpecification(model.volumeSpecification);
            this.volumesPerInstance(model.volumesPerInstance);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return this.volumeSpecification != null ? this.volumeSpecification.toBuilder() : null;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final Integer getVolumesPerInstance() {
            return this.volumesPerInstance;
        }

        public final void setVolumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
        }

        @Override
        public final Builder volumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
            return this;
        }

        public EbsBlockDeviceConfig build() {
            return new EbsBlockDeviceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsBlockDeviceConfig> {
        public Builder volumeSpecification(VolumeSpecification var1);

        default public Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return this.volumeSpecification((VolumeSpecification)((VolumeSpecification.Builder)VolumeSpecification.builder().applyMutation(volumeSpecification)).build());
        }

        public Builder volumesPerInstance(Integer var1);
    }
}

