/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The credentials that you can use to connect to cluster endpoints. Credentials consist of a username and a password.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Credentials implements SdkPojo, Serializable, ToCopyableBuilder<Credentials.Builder, Credentials> {
    private static final SdkField<UsernamePassword> USERNAME_PASSWORD_FIELD = SdkField
            .<UsernamePassword> builder(MarshallingType.SDK_POJO).memberName("UsernamePassword")
            .getter(getter(Credentials::usernamePassword)).setter(setter(Builder::usernamePassword))
            .constructor(UsernamePassword::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernamePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UsernamePassword usernamePassword;

    private final Type type;

    private Credentials(BuilderImpl builder) {
        this.usernamePassword = builder.usernamePassword;
        this.type = builder.type;
    }

    /**
     * <p>
     * The username and password that you use to connect to cluster endpoints.
     * </p>
     * 
     * @return The username and password that you use to connect to cluster endpoints.
     */
    public final UsernamePassword usernamePassword() {
        return usernamePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usernamePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials) obj;
        return Objects.equals(usernamePassword(), other.usernamePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Credentials")
                .add("UsernamePassword", usernamePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsernamePassword":
            return Optional.ofNullable(clazz.cast(usernamePassword()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #usernamePassword()} initialized to the given value.
     *
     * <p>
     * The username and password that you use to connect to cluster endpoints.
     * </p>
     * 
     * @param usernamePassword
     *        The username and password that you use to connect to cluster endpoints.
     */
    public static Credentials fromUsernamePassword(UsernamePassword usernamePassword) {
        return builder().usernamePassword(usernamePassword).build();
    }

    /**
     * Create an instance of this class with {@link #usernamePassword()} initialized to the given value.
     *
     * <p>
     * The username and password that you use to connect to cluster endpoints.
     * </p>
     * 
     * @param usernamePassword
     *        The username and password that you use to connect to cluster endpoints.
     */
    public static Credentials fromUsernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
        UsernamePassword.Builder builder = UsernamePassword.builder();
        usernamePassword.accept(builder);
        return fromUsernamePassword(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsernamePassword", USERNAME_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Credentials, T> g) {
        return obj -> g.apply((Credentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Credentials> {
        /**
         * <p>
         * The username and password that you use to connect to cluster endpoints.
         * </p>
         * 
         * @param usernamePassword
         *        The username and password that you use to connect to cluster endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernamePassword(UsernamePassword usernamePassword);

        /**
         * <p>
         * The username and password that you use to connect to cluster endpoints.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsernamePassword.Builder} avoiding the
         * need to create one manually via {@link UsernamePassword#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernamePassword.Builder#build()} is called immediately and its
         * result is passed to {@link #usernamePassword(UsernamePassword)}.
         * 
         * @param usernamePassword
         *        a consumer that will call methods on {@link UsernamePassword.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernamePassword(UsernamePassword)
         */
        default Builder usernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
            return usernamePassword(UsernamePassword.builder().applyMutation(usernamePassword).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UsernamePassword usernamePassword;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            usernamePassword(model.usernamePassword);
        }

        public final UsernamePassword.Builder getUsernamePassword() {
            return usernamePassword != null ? usernamePassword.toBuilder() : null;
        }

        public final void setUsernamePassword(UsernamePassword.BuilderImpl usernamePassword) {
            Object oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword != null ? usernamePassword.build() : null;
            handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
        }

        @Override
        public final Builder usernamePassword(UsernamePassword usernamePassword) {
            Object oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword;
            handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
            return this;
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Credentials#type()
     */
    public enum Type {
        USERNAME_PASSWORD,

        UNKNOWN_TO_SDK_VERSION
    }
}
