/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the instance group status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceGroupStatus.Builder, InstanceGroupStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InstanceGroupStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<InstanceGroupStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<InstanceGroupStateChangeReason> builder(MarshallingType.SDK_POJO).memberName("StateChangeReason")
            .getter(getter(InstanceGroupStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .constructor(InstanceGroupStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<InstanceGroupTimeline> TIMELINE_FIELD = SdkField
            .<InstanceGroupTimeline> builder(MarshallingType.SDK_POJO).memberName("Timeline")
            .getter(getter(InstanceGroupStatus::timeline)).setter(setter(Builder::timeline))
            .constructor(InstanceGroupTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final InstanceGroupStateChangeReason stateChangeReason;

    private final InstanceGroupTimeline timeline;

    private InstanceGroupStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    /**
     * <p>
     * The current state of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the instance group.
     * @see InstanceGroupState
     */
    public final InstanceGroupState state() {
        return InstanceGroupState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the instance group.
     * @see InstanceGroupState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status change reason details for the instance group.
     * </p>
     * 
     * @return The status change reason details for the instance group.
     */
    public final InstanceGroupStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The timeline of the instance group status over time.
     * </p>
     * 
     * @return The timeline of the instance group status over time.
     */
    public final InstanceGroupTimeline timeline() {
        return timeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupStatus)) {
            return false;
        }
        InstanceGroupStatus other = (InstanceGroupStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason()) && Objects.equals(timeline(), other.timeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceGroupStatus").add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).add("Timeline", timeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("Timeline", TIMELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupStatus, T> g) {
        return obj -> g.apply((InstanceGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceGroupStatus> {
        /**
         * <p>
         * The current state of the instance group.
         * </p>
         * 
         * @param state
         *        The current state of the instance group.
         * @see InstanceGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the instance group.
         * </p>
         * 
         * @param state
         *        The current state of the instance group.
         * @see InstanceGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceGroupState
         */
        Builder state(InstanceGroupState state);

        /**
         * <p>
         * The status change reason details for the instance group.
         * </p>
         * 
         * @param stateChangeReason
         *        The status change reason details for the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(InstanceGroupStateChangeReason stateChangeReason);

        /**
         * <p>
         * The status change reason details for the instance group.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceGroupStateChangeReason.Builder}
         * avoiding the need to create one manually via {@link InstanceGroupStateChangeReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceGroupStateChangeReason.Builder#build()} is called
         * immediately and its result is passed to {@link #stateChangeReason(InstanceGroupStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link InstanceGroupStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(InstanceGroupStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<InstanceGroupStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(InstanceGroupStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }

        /**
         * <p>
         * The timeline of the instance group status over time.
         * </p>
         * 
         * @param timeline
         *        The timeline of the instance group status over time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(InstanceGroupTimeline timeline);

        /**
         * <p>
         * The timeline of the instance group status over time.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceGroupTimeline.Builder} avoiding
         * the need to create one manually via {@link InstanceGroupTimeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceGroupTimeline.Builder#build()} is called immediately and
         * its result is passed to {@link #timeline(InstanceGroupTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link InstanceGroupTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(InstanceGroupTimeline)
         */
        default Builder timeline(Consumer<InstanceGroupTimeline.Builder> timeline) {
            return timeline(InstanceGroupTimeline.builder().applyMutation(timeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private InstanceGroupStateChangeReason stateChangeReason;

        private InstanceGroupTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            timeline(model.timeline);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final InstanceGroupStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(InstanceGroupStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceGroupStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final InstanceGroupTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(InstanceGroupTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(InstanceGroupTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        @Override
        public InstanceGroupStatus build() {
            return new InstanceGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
