/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.emr.model.ExecutionEngineConfig;
import software.amazon.awssdk.services.emr.model.NotebookExecutionStatus;
import software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput;
import software.amazon.awssdk.services.emr.model.OutputNotebookFormat;
import software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationForOutput;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookExecution> {
    private static final SdkField<String> NOTEBOOK_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionId").getter(NotebookExecution.getter(NotebookExecution::notebookExecutionId)).setter(NotebookExecution.setter(Builder::notebookExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionId").build()}).build();
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EditorId").getter(NotebookExecution.getter(NotebookExecution::editorId)).setter(NotebookExecution.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<ExecutionEngineConfig> EXECUTION_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionEngine").getter(NotebookExecution.getter(NotebookExecution::executionEngine)).setter(NotebookExecution.setter(Builder::executionEngine)).constructor(ExecutionEngineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngine").build()}).build();
    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionName").getter(NotebookExecution.getter(NotebookExecution::notebookExecutionName)).setter(NotebookExecution.setter(Builder::notebookExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build()}).build();
    private static final SdkField<String> NOTEBOOK_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookParams").getter(NotebookExecution.getter(NotebookExecution::notebookParams)).setter(NotebookExecution.setter(Builder::notebookParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookParams").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NotebookExecution.getter(NotebookExecution::statusAsString)).setter(NotebookExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(NotebookExecution.getter(NotebookExecution::startTime)).setter(NotebookExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(NotebookExecution.getter(NotebookExecution::endTime)).setter(NotebookExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(NotebookExecution.getter(NotebookExecution::arn)).setter(NotebookExecution.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> OUTPUT_NOTEBOOK_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputNotebookURI").getter(NotebookExecution.getter(NotebookExecution::outputNotebookURI)).setter(NotebookExecution.setter(Builder::outputNotebookURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputNotebookURI").build()}).build();
    private static final SdkField<String> LAST_STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastStateChangeReason").getter(NotebookExecution.getter(NotebookExecution::lastStateChangeReason)).setter(NotebookExecution.setter(Builder::lastStateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStateChangeReason").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceSecurityGroupId").getter(NotebookExecution.getter(NotebookExecution::notebookInstanceSecurityGroupId)).setter(NotebookExecution.setter(Builder::notebookInstanceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceSecurityGroupId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NotebookExecution.getter(NotebookExecution::tags)).setter(NotebookExecution.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NotebookS3LocationForOutput> NOTEBOOK_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotebookS3Location").getter(NotebookExecution.getter(NotebookExecution::notebookS3Location)).setter(NotebookExecution.setter(Builder::notebookS3Location)).constructor(NotebookS3LocationForOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookS3Location").build()}).build();
    private static final SdkField<OutputNotebookS3LocationForOutput> OUTPUT_NOTEBOOK_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputNotebookS3Location").getter(NotebookExecution.getter(NotebookExecution::outputNotebookS3Location)).setter(NotebookExecution.setter(Builder::outputNotebookS3Location)).constructor(OutputNotebookS3LocationForOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputNotebookS3Location").build()}).build();
    private static final SdkField<String> OUTPUT_NOTEBOOK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputNotebookFormat").getter(NotebookExecution.getter(NotebookExecution::outputNotebookFormatAsString)).setter(NotebookExecution.setter(Builder::outputNotebookFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputNotebookFormat").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EnvironmentVariables").getter(NotebookExecution.getter(NotebookExecution::environmentVariables)).setter(NotebookExecution.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTION_ID_FIELD, EDITOR_ID_FIELD, EXECUTION_ENGINE_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, NOTEBOOK_PARAMS_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, ARN_FIELD, OUTPUT_NOTEBOOK_URI_FIELD, LAST_STATE_CHANGE_REASON_FIELD, NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD, TAGS_FIELD, NOTEBOOK_S3_LOCATION_FIELD, OUTPUT_NOTEBOOK_S3_LOCATION_FIELD, OUTPUT_NOTEBOOK_FORMAT_FIELD, ENVIRONMENT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotebookExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String notebookExecutionId;
    private final String editorId;
    private final ExecutionEngineConfig executionEngine;
    private final String notebookExecutionName;
    private final String notebookParams;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String arn;
    private final String outputNotebookURI;
    private final String lastStateChangeReason;
    private final String notebookInstanceSecurityGroupId;
    private final List<Tag> tags;
    private final NotebookS3LocationForOutput notebookS3Location;
    private final OutputNotebookS3LocationForOutput outputNotebookS3Location;
    private final String outputNotebookFormat;
    private final Map<String, String> environmentVariables;

    private NotebookExecution(BuilderImpl builder) {
        this.notebookExecutionId = builder.notebookExecutionId;
        this.editorId = builder.editorId;
        this.executionEngine = builder.executionEngine;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.notebookParams = builder.notebookParams;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.arn = builder.arn;
        this.outputNotebookURI = builder.outputNotebookURI;
        this.lastStateChangeReason = builder.lastStateChangeReason;
        this.notebookInstanceSecurityGroupId = builder.notebookInstanceSecurityGroupId;
        this.tags = builder.tags;
        this.notebookS3Location = builder.notebookS3Location;
        this.outputNotebookS3Location = builder.outputNotebookS3Location;
        this.outputNotebookFormat = builder.outputNotebookFormat;
        this.environmentVariables = builder.environmentVariables;
    }

    public final String notebookExecutionId() {
        return this.notebookExecutionId;
    }

    public final String editorId() {
        return this.editorId;
    }

    public final ExecutionEngineConfig executionEngine() {
        return this.executionEngine;
    }

    public final String notebookExecutionName() {
        return this.notebookExecutionName;
    }

    public final String notebookParams() {
        return this.notebookParams;
    }

    public final NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String outputNotebookURI() {
        return this.outputNotebookURI;
    }

    public final String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public final String notebookInstanceSecurityGroupId() {
        return this.notebookInstanceSecurityGroupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final NotebookS3LocationForOutput notebookS3Location() {
        return this.notebookS3Location;
    }

    public final OutputNotebookS3LocationForOutput outputNotebookS3Location() {
        return this.outputNotebookS3Location;
    }

    public final OutputNotebookFormat outputNotebookFormat() {
        return OutputNotebookFormat.fromValue(this.outputNotebookFormat);
    }

    public final String outputNotebookFormatAsString() {
        return this.outputNotebookFormat;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputNotebookURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputNotebookS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputNotebookFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookExecution)) {
            return false;
        }
        NotebookExecution other = (NotebookExecution)obj;
        return Objects.equals(this.notebookExecutionId(), other.notebookExecutionId()) && Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.executionEngine(), other.executionEngine()) && Objects.equals(this.notebookExecutionName(), other.notebookExecutionName()) && Objects.equals(this.notebookParams(), other.notebookParams()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.outputNotebookURI(), other.outputNotebookURI()) && Objects.equals(this.lastStateChangeReason(), other.lastStateChangeReason()) && Objects.equals(this.notebookInstanceSecurityGroupId(), other.notebookInstanceSecurityGroupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notebookS3Location(), other.notebookS3Location()) && Objects.equals(this.outputNotebookS3Location(), other.outputNotebookS3Location()) && Objects.equals(this.outputNotebookFormatAsString(), other.outputNotebookFormatAsString()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables());
    }

    public final String toString() {
        return ToString.builder((String)"NotebookExecution").add("NotebookExecutionId", (Object)this.notebookExecutionId()).add("EditorId", (Object)this.editorId()).add("ExecutionEngine", (Object)this.executionEngine()).add("NotebookExecutionName", (Object)this.notebookExecutionName()).add("NotebookParams", (Object)this.notebookParams()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Arn", (Object)this.arn()).add("OutputNotebookURI", (Object)this.outputNotebookURI()).add("LastStateChangeReason", (Object)this.lastStateChangeReason()).add("NotebookInstanceSecurityGroupId", (Object)this.notebookInstanceSecurityGroupId()).add("Tags", this.hasTags() ? this.tags() : null).add("NotebookS3Location", (Object)this.notebookS3Location()).add("OutputNotebookS3Location", (Object)this.outputNotebookS3Location()).add("OutputNotebookFormat", (Object)this.outputNotebookFormatAsString()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookExecutionId": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionId()));
            }
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "ExecutionEngine": {
                return Optional.ofNullable(clazz.cast(this.executionEngine()));
            }
            case "NotebookExecutionName": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionName()));
            }
            case "NotebookParams": {
                return Optional.ofNullable(clazz.cast(this.notebookParams()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OutputNotebookURI": {
                return Optional.ofNullable(clazz.cast(this.outputNotebookURI()));
            }
            case "LastStateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.lastStateChangeReason()));
            }
            case "NotebookInstanceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceSecurityGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotebookS3Location": {
                return Optional.ofNullable(clazz.cast(this.notebookS3Location()));
            }
            case "OutputNotebookS3Location": {
                return Optional.ofNullable(clazz.cast(this.outputNotebookS3Location()));
            }
            case "OutputNotebookFormat": {
                return Optional.ofNullable(clazz.cast(this.outputNotebookFormatAsString()));
            }
            case "EnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookExecutionId", NOTEBOOK_EXECUTION_ID_FIELD);
        map.put("EditorId", EDITOR_ID_FIELD);
        map.put("ExecutionEngine", EXECUTION_ENGINE_FIELD);
        map.put("NotebookExecutionName", NOTEBOOK_EXECUTION_NAME_FIELD);
        map.put("NotebookParams", NOTEBOOK_PARAMS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("OutputNotebookURI", OUTPUT_NOTEBOOK_URI_FIELD);
        map.put("LastStateChangeReason", LAST_STATE_CHANGE_REASON_FIELD);
        map.put("NotebookInstanceSecurityGroupId", NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NotebookS3Location", NOTEBOOK_S3_LOCATION_FIELD);
        map.put("OutputNotebookS3Location", OUTPUT_NOTEBOOK_S3_LOCATION_FIELD);
        map.put("OutputNotebookFormat", OUTPUT_NOTEBOOK_FORMAT_FIELD);
        map.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotebookExecution, T> g) {
        return obj -> g.apply((NotebookExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookExecutionId;
        private String editorId;
        private ExecutionEngineConfig executionEngine;
        private String notebookExecutionName;
        private String notebookParams;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String arn;
        private String outputNotebookURI;
        private String lastStateChangeReason;
        private String notebookInstanceSecurityGroupId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private NotebookS3LocationForOutput notebookS3Location;
        private OutputNotebookS3LocationForOutput outputNotebookS3Location;
        private String outputNotebookFormat;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookExecution model) {
            this.notebookExecutionId(model.notebookExecutionId);
            this.editorId(model.editorId);
            this.executionEngine(model.executionEngine);
            this.notebookExecutionName(model.notebookExecutionName);
            this.notebookParams(model.notebookParams);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.arn(model.arn);
            this.outputNotebookURI(model.outputNotebookURI);
            this.lastStateChangeReason(model.lastStateChangeReason);
            this.notebookInstanceSecurityGroupId(model.notebookInstanceSecurityGroupId);
            this.tags(model.tags);
            this.notebookS3Location(model.notebookS3Location);
            this.outputNotebookS3Location(model.outputNotebookS3Location);
            this.outputNotebookFormat(model.outputNotebookFormat);
            this.environmentVariables(model.environmentVariables);
        }

        public final String getNotebookExecutionId() {
            return this.notebookExecutionId;
        }

        public final void setNotebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
        }

        @Override
        public final Builder notebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
            return this;
        }

        public final String getEditorId() {
            return this.editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final ExecutionEngineConfig.Builder getExecutionEngine() {
            return this.executionEngine != null ? this.executionEngine.toBuilder() : null;
        }

        public final void setExecutionEngine(ExecutionEngineConfig.BuilderImpl executionEngine) {
            this.executionEngine = executionEngine != null ? executionEngine.build() : null;
        }

        @Override
        public final Builder executionEngine(ExecutionEngineConfig executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        public final String getNotebookExecutionName() {
            return this.notebookExecutionName;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final String getNotebookParams() {
            return this.notebookParams;
        }

        public final void setNotebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
        }

        @Override
        public final Builder notebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOutputNotebookURI() {
            return this.outputNotebookURI;
        }

        public final void setOutputNotebookURI(String outputNotebookURI) {
            this.outputNotebookURI = outputNotebookURI;
        }

        @Override
        public final Builder outputNotebookURI(String outputNotebookURI) {
            this.outputNotebookURI = outputNotebookURI;
            return this;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final String getNotebookInstanceSecurityGroupId() {
            return this.notebookInstanceSecurityGroupId;
        }

        public final void setNotebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
        }

        @Override
        public final Builder notebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NotebookS3LocationForOutput.Builder getNotebookS3Location() {
            return this.notebookS3Location != null ? this.notebookS3Location.toBuilder() : null;
        }

        public final void setNotebookS3Location(NotebookS3LocationForOutput.BuilderImpl notebookS3Location) {
            this.notebookS3Location = notebookS3Location != null ? notebookS3Location.build() : null;
        }

        @Override
        public final Builder notebookS3Location(NotebookS3LocationForOutput notebookS3Location) {
            this.notebookS3Location = notebookS3Location;
            return this;
        }

        public final OutputNotebookS3LocationForOutput.Builder getOutputNotebookS3Location() {
            return this.outputNotebookS3Location != null ? this.outputNotebookS3Location.toBuilder() : null;
        }

        public final void setOutputNotebookS3Location(OutputNotebookS3LocationForOutput.BuilderImpl outputNotebookS3Location) {
            this.outputNotebookS3Location = outputNotebookS3Location != null ? outputNotebookS3Location.build() : null;
        }

        @Override
        public final Builder outputNotebookS3Location(OutputNotebookS3LocationForOutput outputNotebookS3Location) {
            this.outputNotebookS3Location = outputNotebookS3Location;
            return this;
        }

        public final String getOutputNotebookFormat() {
            return this.outputNotebookFormat;
        }

        public final void setOutputNotebookFormat(String outputNotebookFormat) {
            this.outputNotebookFormat = outputNotebookFormat;
        }

        @Override
        public final Builder outputNotebookFormat(String outputNotebookFormat) {
            this.outputNotebookFormat = outputNotebookFormat;
            return this;
        }

        @Override
        public final Builder outputNotebookFormat(OutputNotebookFormat outputNotebookFormat) {
            this.outputNotebookFormat(outputNotebookFormat == null ? null : outputNotebookFormat.toString());
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public NotebookExecution build() {
            return new NotebookExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookExecution> {
        public Builder notebookExecutionId(String var1);

        public Builder editorId(String var1);

        public Builder executionEngine(ExecutionEngineConfig var1);

        default public Builder executionEngine(Consumer<ExecutionEngineConfig.Builder> executionEngine) {
            return this.executionEngine((ExecutionEngineConfig)((ExecutionEngineConfig.Builder)ExecutionEngineConfig.builder().applyMutation(executionEngine)).build());
        }

        public Builder notebookExecutionName(String var1);

        public Builder notebookParams(String var1);

        public Builder status(String var1);

        public Builder status(NotebookExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder arn(String var1);

        public Builder outputNotebookURI(String var1);

        public Builder lastStateChangeReason(String var1);

        public Builder notebookInstanceSecurityGroupId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notebookS3Location(NotebookS3LocationForOutput var1);

        default public Builder notebookS3Location(Consumer<NotebookS3LocationForOutput.Builder> notebookS3Location) {
            return this.notebookS3Location((NotebookS3LocationForOutput)((NotebookS3LocationForOutput.Builder)NotebookS3LocationForOutput.builder().applyMutation(notebookS3Location)).build());
        }

        public Builder outputNotebookS3Location(OutputNotebookS3LocationForOutput var1);

        default public Builder outputNotebookS3Location(Consumer<OutputNotebookS3LocationForOutput.Builder> outputNotebookS3Location) {
            return this.outputNotebookS3Location((OutputNotebookS3LocationForOutput)((OutputNotebookS3LocationForOutput.Builder)OutputNotebookS3LocationForOutput.builder().applyMutation(outputNotebookS3Location)).build());
        }

        public Builder outputNotebookFormat(String var1);

        public Builder outputNotebookFormat(OutputNotebookFormat var1);

        public Builder environmentVariables(Map<String, String> var1);
    }
}

