/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the step failure. The service attempts to detect the root cause for many common failures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureDetails implements SdkPojo, Serializable, ToCopyableBuilder<FailureDetails.Builder, FailureDetails> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(FailureDetails::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(FailureDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> LOG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFile").getter(getter(FailureDetails::logFile)).setter(setter(Builder::logFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, MESSAGE_FIELD,
            LOG_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String message;

    private final String logFile;

    private FailureDetails(BuilderImpl builder) {
        this.reason = builder.reason;
        this.message = builder.message;
        this.logFile = builder.logFile;
    }

    /**
     * <p>
     * The reason for the step failure. In the case where the service cannot successfully determine the root cause of
     * the failure, it returns "Unknown Error" as a reason.
     * </p>
     * 
     * @return The reason for the step failure. In the case where the service cannot successfully determine the root
     *         cause of the failure, it returns "Unknown Error" as a reason.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The descriptive message including the error the Amazon EMR service has identified as the cause of step failure.
     * This is text from an error log that describes the root cause of the failure.
     * </p>
     * 
     * @return The descriptive message including the error the Amazon EMR service has identified as the cause of step
     *         failure. This is text from an error log that describes the root cause of the failure.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The path to the log file where the step failure root cause was originally recorded.
     * </p>
     * 
     * @return The path to the log file where the step failure root cause was originally recorded.
     */
    public final String logFile() {
        return logFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(logFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(message(), other.message())
                && Objects.equals(logFile(), other.logFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailureDetails").add("Reason", reason()).add("Message", message()).add("LogFile", logFile())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "LogFile":
            return Optional.ofNullable(clazz.cast(logFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reason", REASON_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("LogFile", LOG_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailureDetails, T> g) {
        return obj -> g.apply((FailureDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureDetails> {
        /**
         * <p>
         * The reason for the step failure. In the case where the service cannot successfully determine the root cause
         * of the failure, it returns "Unknown Error" as a reason.
         * </p>
         * 
         * @param reason
         *        The reason for the step failure. In the case where the service cannot successfully determine the root
         *        cause of the failure, it returns "Unknown Error" as a reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The descriptive message including the error the Amazon EMR service has identified as the cause of step
         * failure. This is text from an error log that describes the root cause of the failure.
         * </p>
         * 
         * @param message
         *        The descriptive message including the error the Amazon EMR service has identified as the cause of step
         *        failure. This is text from an error log that describes the root cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The path to the log file where the step failure root cause was originally recorded.
         * </p>
         * 
         * @param logFile
         *        The path to the log file where the step failure root cause was originally recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFile(String logFile);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private String message;

        private String logFile;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            reason(model.reason);
            message(model.message);
            logFile(model.logFile);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getLogFile() {
            return logFile;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        @Override
        public FailureDetails build() {
            return new FailureDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
