/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStudioSessionMappingsRequest extends EmrRequest implements
        ToCopyableBuilder<ListStudioSessionMappingsRequest.Builder, ListStudioSessionMappingsRequest> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioId").getter(getter(ListStudioSessionMappingsRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(ListStudioSessionMappingsRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListStudioSessionMappingsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD,
            IDENTITY_TYPE_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String studioId;

    private final String identityType;

    private final String marker;

    private ListStudioSessionMappingsRequest(BuilderImpl builder) {
        super(builder);
        this.studioId = builder.studioId;
        this.identityType = builder.identityType;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio.
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * Specifies whether to return session mappings for users or groups. If not specified, the results include session
     * mapping details for both users and groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to return session mappings for users or groups. If not specified, the results include
     *         session mapping details for both users and groups.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * Specifies whether to return session mappings for users or groups. If not specified, the results include session
     * mapping details for both users and groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to return session mappings for users or groups. If not specified, the results include
     *         session mapping details for both users and groups.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The pagination token that indicates the set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioSessionMappingsRequest)) {
            return false;
        }
        ListStudioSessionMappingsRequest other = (ListStudioSessionMappingsRequest) obj;
        return Objects.equals(studioId(), other.studioId())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStudioSessionMappingsRequest").add("StudioId", studioId())
                .add("IdentityType", identityTypeAsString()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StudioId", STUDIO_ID_FIELD);
        map.put("IdentityType", IDENTITY_TYPE_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStudioSessionMappingsRequest, T> g) {
        return obj -> g.apply((ListStudioSessionMappingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStudioSessionMappingsRequest> {
        /**
         * <p>
         * The ID of the Amazon EMR Studio.
         * </p>
         * 
         * @param studioId
         *        The ID of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * Specifies whether to return session mappings for users or groups. If not specified, the results include
         * session mapping details for both users and groups.
         * </p>
         * 
         * @param identityType
         *        Specifies whether to return session mappings for users or groups. If not specified, the results
         *        include session mapping details for both users and groups.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * Specifies whether to return session mappings for users or groups. If not specified, the results include
         * session mapping details for both users and groups.
         * </p>
         * 
         * @param identityType
         *        Specifies whether to return session mappings for users or groups. If not specified, the results
         *        include session mapping details for both users and groups.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The pagination token that indicates the set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String studioId;

        private String identityType;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioSessionMappingsRequest model) {
            super(model);
            studioId(model.studioId);
            identityType(model.identityType);
            marker(model.marker);
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStudioSessionMappingsRequest build() {
            return new ListStudioSessionMappingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
