/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandCapacityReservationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDemandCapacityReservationOptions.Builder, OnDemandCapacityReservationOptions> {
    private static final SdkField<String> USAGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageStrategy").getter(getter(OnDemandCapacityReservationOptions::usageStrategyAsString))
            .setter(setter(Builder::usageStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageStrategy").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationPreference")
            .getter(getter(OnDemandCapacityReservationOptions::capacityReservationPreferenceAsString))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationResourceGroupArn")
            .getter(getter(OnDemandCapacityReservationOptions::capacityReservationResourceGroupArn))
            .setter(setter(Builder::capacityReservationResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityReservationResourceGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_STRATEGY_FIELD,
            CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usageStrategy;

    private final String capacityReservationPreference;

    private final String capacityReservationResourceGroupArn;

    private OnDemandCapacityReservationOptions(BuilderImpl builder) {
        this.usageStrategy = builder.usageStrategy;
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationResourceGroupArn = builder.capacityReservationResourceGroupArn;
    }

    /**
     * <p>
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
     * </p>
     * <p>
     * If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to
     * fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity
     * Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused
     * Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is
     * launched according to the On-Demand allocation strategy (<code>lowest-price</code>).
     * </p>
     * <p>
     * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand
     * allocation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageStrategy}
     * will return {@link OnDemandCapacityReservationUsageStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #usageStrategyAsString}.
     * </p>
     * 
     * @return Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
     *         <p>
     *         If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations
     *         to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused
     *         Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the
     *         number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
     *         On-Demand target capacity is launched according to the On-Demand allocation strategy (
     *         <code>lowest-price</code>).
     *         </p>
     *         <p>
     *         If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen
     *         On-Demand allocation strategy.
     * @see OnDemandCapacityReservationUsageStrategy
     */
    public final OnDemandCapacityReservationUsageStrategy usageStrategy() {
        return OnDemandCapacityReservationUsageStrategy.fromValue(usageStrategy);
    }

    /**
     * <p>
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
     * </p>
     * <p>
     * If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to
     * fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity
     * Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused
     * Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is
     * launched according to the On-Demand allocation strategy (<code>lowest-price</code>).
     * </p>
     * <p>
     * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand
     * allocation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageStrategy}
     * will return {@link OnDemandCapacityReservationUsageStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #usageStrategyAsString}.
     * </p>
     * 
     * @return Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
     *         <p>
     *         If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations
     *         to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused
     *         Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the
     *         number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
     *         On-Demand target capacity is launched according to the On-Demand allocation strategy (
     *         <code>lowest-price</code>).
     *         </p>
     *         <p>
     *         If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen
     *         On-Demand allocation strategy.
     * @see OnDemandCapacityReservationUsageStrategy
     */
    public final String usageStrategyAsString() {
        return usageStrategy;
    }

    /**
     * <p>
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance
     * type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs as an On-Demand Instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return
     * {@link OnDemandCapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
     *         (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs as an On-Demand Instance.
     *         </p>
     *         </li>
     * @see OnDemandCapacityReservationPreference
     */
    public final OnDemandCapacityReservationPreference capacityReservationPreference() {
        return OnDemandCapacityReservationPreference.fromValue(capacityReservationPreference);
    }

    /**
     * <p>
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance
     * type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs as an On-Demand Instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return
     * {@link OnDemandCapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
     *         (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs as an On-Demand Instance.
     *         </p>
     *         </li>
     * @see OnDemandCapacityReservationPreference
     */
    public final String capacityReservationPreferenceAsString() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * The ARN of the Capacity Reservation resource group in which to run the instance.
     * </p>
     * 
     * @return The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    public final String capacityReservationResourceGroupArn() {
        return capacityReservationResourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationResourceGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandCapacityReservationOptions)) {
            return false;
        }
        OnDemandCapacityReservationOptions other = (OnDemandCapacityReservationOptions) obj;
        return Objects.equals(usageStrategyAsString(), other.usageStrategyAsString())
                && Objects.equals(capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString())
                && Objects.equals(capacityReservationResourceGroupArn(), other.capacityReservationResourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDemandCapacityReservationOptions").add("UsageStrategy", usageStrategyAsString())
                .add("CapacityReservationPreference", capacityReservationPreferenceAsString())
                .add("CapacityReservationResourceGroupArn", capacityReservationResourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageStrategy":
            return Optional.ofNullable(clazz.cast(usageStrategyAsString()));
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreferenceAsString()));
        case "CapacityReservationResourceGroupArn":
            return Optional.ofNullable(clazz.cast(capacityReservationResourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageStrategy", USAGE_STRATEGY_FIELD);
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("CapacityReservationResourceGroupArn", CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnDemandCapacityReservationOptions, T> g) {
        return obj -> g.apply((OnDemandCapacityReservationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandCapacityReservationOptions> {
        /**
         * <p>
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * </p>
         * <p>
         * If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to
         * fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused
         * Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the
         * number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand
         * target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).
         * </p>
         * <p>
         * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand
         * allocation strategy.
         * </p>
         * 
         * @param usageStrategy
         *        Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
         *        <p>
         *        If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity
         *        Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance
         *        pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>)
         *        is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity,
         *        the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (
         *        <code>lowest-price</code>).
         *        </p>
         *        <p>
         *        If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen
         *        On-Demand allocation strategy.
         * @see OnDemandCapacityReservationUsageStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandCapacityReservationUsageStrategy
         */
        Builder usageStrategy(String usageStrategy);

        /**
         * <p>
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * </p>
         * <p>
         * If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to
         * fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused
         * Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the
         * number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand
         * target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).
         * </p>
         * <p>
         * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand
         * allocation strategy.
         * </p>
         * 
         * @param usageStrategy
         *        Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
         *        <p>
         *        If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity
         *        Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance
         *        pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>)
         *        is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity,
         *        the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (
         *        <code>lowest-price</code>).
         *        </p>
         *        <p>
         *        If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen
         *        On-Demand allocation strategy.
         * @see OnDemandCapacityReservationUsageStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandCapacityReservationUsageStrategy
         */
        Builder usageStrategy(OnDemandCapacityReservationUsageStrategy usageStrategy);

        /**
         * <p>
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
         * (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs as an On-Demand Instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
         *        (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs as an On-Demand Instance.
         *        </p>
         *        </li>
         * @see OnDemandCapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandCapacityReservationPreference
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
         * (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs as an On-Demand Instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes
         *        (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs as an On-Demand Instance.
         *        </p>
         *        </li>
         * @see OnDemandCapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandCapacityReservationPreference
         */
        Builder capacityReservationPreference(OnDemandCapacityReservationPreference capacityReservationPreference);

        /**
         * <p>
         * The ARN of the Capacity Reservation resource group in which to run the instance.
         * </p>
         * 
         * @param capacityReservationResourceGroupArn
         *        The ARN of the Capacity Reservation resource group in which to run the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String usageStrategy;

        private String capacityReservationPreference;

        private String capacityReservationResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandCapacityReservationOptions model) {
            usageStrategy(model.usageStrategy);
            capacityReservationPreference(model.capacityReservationPreference);
            capacityReservationResourceGroupArn(model.capacityReservationResourceGroupArn);
        }

        public final String getUsageStrategy() {
            return usageStrategy;
        }

        public final void setUsageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
        }

        @Override
        public final Builder usageStrategy(String usageStrategy) {
            this.usageStrategy = usageStrategy;
            return this;
        }

        @Override
        public final Builder usageStrategy(OnDemandCapacityReservationUsageStrategy usageStrategy) {
            this.usageStrategy(usageStrategy == null ? null : usageStrategy.toString());
            return this;
        }

        public final String getCapacityReservationPreference() {
            return capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(OnDemandCapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference
                    .toString());
            return this;
        }

        public final String getCapacityReservationResourceGroupArn() {
            return capacityReservationResourceGroupArn;
        }

        public final void setCapacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
        }

        @Override
        public final Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
            return this;
        }

        @Override
        public OnDemandCapacityReservationOptions build() {
            return new OnDemandCapacityReservationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
