/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input argument to the <a>TerminationProtection</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetTerminationProtectionRequest extends EmrRequest implements
        ToCopyableBuilder<SetTerminationProtectionRequest.Builder, SetTerminationProtectionRequest> {
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobFlowIds")
            .getter(getter(SetTerminationProtectionRequest::jobFlowIds))
            .setter(setter(Builder::jobFlowIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtected").getter(getter(SetTerminationProtectionRequest::terminationProtected))
            .setter(setter(Builder::terminationProtected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtected").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_IDS_FIELD,
            TERMINATION_PROTECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> jobFlowIds;

    private final Boolean terminationProtected;

    private SetTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
        this.terminationProtected = builder.terminationProtected;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobFlowIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobFlowIds() {
        return jobFlowIds != null && !(jobFlowIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings that uniquely identify the clusters to protect. This identifier is returned by
     * <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobFlowIds} method.
     * </p>
     * 
     * @return A list of strings that uniquely identify the clusters to protect. This identifier is returned by
     *         <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
     */
    public final List<String> jobFlowIds() {
        return jobFlowIds;
    }

    /**
     * <p>
     * A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from
     * shutting down due to API calls, user intervention, or job-flow error.
     * </p>
     * 
     * @return A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the
     *         cluster from shutting down due to API calls, user intervention, or job-flow error.
     */
    public final Boolean terminationProtected() {
        return terminationProtected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobFlowIds() ? jobFlowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTerminationProtectionRequest)) {
            return false;
        }
        SetTerminationProtectionRequest other = (SetTerminationProtectionRequest) obj;
        return hasJobFlowIds() == other.hasJobFlowIds() && Objects.equals(jobFlowIds(), other.jobFlowIds())
                && Objects.equals(terminationProtected(), other.terminationProtected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetTerminationProtectionRequest").add("JobFlowIds", hasJobFlowIds() ? jobFlowIds() : null)
                .add("TerminationProtected", terminationProtected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowIds":
            return Optional.ofNullable(clazz.cast(jobFlowIds()));
        case "TerminationProtected":
            return Optional.ofNullable(clazz.cast(terminationProtected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobFlowIds", JOB_FLOW_IDS_FIELD);
        map.put("TerminationProtected", TERMINATION_PROTECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetTerminationProtectionRequest, T> g) {
        return obj -> g.apply((SetTerminationProtectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetTerminationProtectionRequest> {
        /**
         * <p>
         * A list of strings that uniquely identify the clusters to protect. This identifier is returned by
         * <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
         * </p>
         * 
         * @param jobFlowIds
         *        A list of strings that uniquely identify the clusters to protect. This identifier is returned by
         *        <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(Collection<String> jobFlowIds);

        /**
         * <p>
         * A list of strings that uniquely identify the clusters to protect. This identifier is returned by
         * <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
         * </p>
         * 
         * @param jobFlowIds
         *        A list of strings that uniquely identify the clusters to protect. This identifier is returned by
         *        <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(String... jobFlowIds);

        /**
         * <p>
         * A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster
         * from shutting down due to API calls, user intervention, or job-flow error.
         * </p>
         * 
         * @param terminationProtected
         *        A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the
         *        cluster from shutting down due to API calls, user intervention, or job-flow error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtected(Boolean terminationProtected);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean terminationProtected;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTerminationProtectionRequest model) {
            super(model);
            jobFlowIds(model.jobFlowIds);
            terminationProtected(model.terminationProtected);
        }

        public final Collection<String> getJobFlowIds() {
            if (jobFlowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return jobFlowIds;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String... jobFlowIds) {
            jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final Boolean getTerminationProtected() {
            return terminationProtected;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTerminationProtectionRequest build() {
            return new SetTerminationProtectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
