/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicy;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAutoScalingPolicyRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, PutAutoScalingPolicyRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(PutAutoScalingPolicyRequest.getter(PutAutoScalingPolicyRequest::clusterId)).setter(PutAutoScalingPolicyRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupId").getter(PutAutoScalingPolicyRequest.getter(PutAutoScalingPolicyRequest::instanceGroupId)).setter(PutAutoScalingPolicyRequest.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final SdkField<AutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScalingPolicy").getter(PutAutoScalingPolicyRequest.getter(PutAutoScalingPolicyRequest::autoScalingPolicy)).setter(PutAutoScalingPolicyRequest.setter(Builder::autoScalingPolicy)).constructor(AutoScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_GROUP_ID_FIELD, AUTO_SCALING_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAutoScalingPolicyRequest.memberNameToFieldInitializer();
    private final String clusterId;
    private final String instanceGroupId;
    private final AutoScalingPolicy autoScalingPolicy;

    private PutAutoScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String instanceGroupId() {
        return this.instanceGroupId;
    }

    public final AutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoScalingPolicyRequest)) {
            return false;
        }
        PutAutoScalingPolicyRequest other = (PutAutoScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutAutoScalingPolicyRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "AutoScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("InstanceGroupId", INSTANCE_GROUP_ID_FIELD);
        map.put("AutoScalingPolicy", AUTO_SCALING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAutoScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutAutoScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoScalingPolicyRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final AutoScalingPolicy.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAutoScalingPolicyRequest build() {
            return new PutAutoScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAutoScalingPolicyRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder autoScalingPolicy(AutoScalingPolicy var1);

        default public Builder autoScalingPolicy(Consumer<AutoScalingPolicy.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((AutoScalingPolicy)((AutoScalingPolicy.Builder)AutoScalingPolicy.builder().applyMutation(autoScalingPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

