/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the timeline of the cluster's lifecycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterTimeline implements SdkPojo, Serializable, ToCopyableBuilder<ClusterTimeline.Builder, ClusterTimeline> {
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(ClusterTimeline::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<Instant> READY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReadyDateTime").getter(getter(ClusterTimeline::readyDateTime)).setter(setter(Builder::readyDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadyDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDateTime").getter(getter(ClusterTimeline::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD,
            READY_DATE_TIME_FIELD, END_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationDateTime;

    private final Instant readyDateTime;

    private final Instant endDateTime;

    private ClusterTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * The creation date and time of the cluster.
     * </p>
     * 
     * @return The creation date and time of the cluster.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time when the cluster was ready to run steps.
     * </p>
     * 
     * @return The date and time when the cluster was ready to run steps.
     */
    public final Instant readyDateTime() {
        return readyDateTime;
    }

    /**
     * <p>
     * The date and time when the cluster was terminated.
     * </p>
     * 
     * @return The date and time when the cluster was terminated.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(readyDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterTimeline)) {
            return false;
        }
        ClusterTimeline other = (ClusterTimeline) obj;
        return Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(readyDateTime(), other.readyDateTime()) && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterTimeline").add("CreationDateTime", creationDateTime())
                .add("ReadyDateTime", readyDateTime()).add("EndDateTime", endDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "ReadyDateTime":
            return Optional.ofNullable(clazz.cast(readyDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("ReadyDateTime", READY_DATE_TIME_FIELD);
        map.put("EndDateTime", END_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterTimeline, T> g) {
        return obj -> g.apply((ClusterTimeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterTimeline> {
        /**
         * <p>
         * The creation date and time of the cluster.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time when the cluster was ready to run steps.
         * </p>
         * 
         * @param readyDateTime
         *        The date and time when the cluster was ready to run steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readyDateTime(Instant readyDateTime);

        /**
         * <p>
         * The date and time when the cluster was terminated.
         * </p>
         * 
         * @param endDateTime
         *        The date and time when the cluster was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDateTime;

        private Instant readyDateTime;

        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterTimeline model) {
            creationDateTime(model.creationDateTime);
            readyDateTime(model.readyDateTime);
            endDateTime(model.endDateTime);
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getReadyDateTime() {
            return readyDateTime;
        }

        public final void setReadyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @Override
        public ClusterTimeline build() {
            return new ClusterTimeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
