/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOnClusterAppUiPresignedUrlRequest extends EmrRequest implements
        ToCopyableBuilder<GetOnClusterAppUiPresignedUrlRequest.Builder, GetOnClusterAppUiPresignedUrlRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(GetOnClusterAppUiPresignedUrlRequest::clusterId))
            .setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> ON_CLUSTER_APP_UI_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnClusterAppUIType").getter(getter(GetOnClusterAppUiPresignedUrlRequest::onClusterAppUITypeAsString))
            .setter(setter(Builder::onClusterAppUIType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClusterAppUIType").build())
            .build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetOnClusterAppUiPresignedUrlRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(GetOnClusterAppUiPresignedUrlRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(GetOnClusterAppUiPresignedUrlRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            ON_CLUSTER_APP_UI_TYPE_FIELD, APPLICATION_ID_FIELD, DRY_RUN_FIELD, EXECUTION_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String onClusterAppUIType;

    private final String applicationId;

    private final Boolean dryRun;

    private final String executionRoleArn;

    private GetOnClusterAppUiPresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.onClusterAppUIType = builder.onClusterAppUIType;
        this.applicationId = builder.applicationId;
        this.dryRun = builder.dryRun;
        this.executionRoleArn = builder.executionRoleArn;
    }

    /**
     * <p>
     * The cluster ID associated with the cluster's application user interface presigned URL.
     * </p>
     * 
     * @return The cluster ID associated with the cluster's application user interface presigned URL.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The application UI type associated with the cluster's application user interface presigned URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onClusterAppUIType} will return {@link OnClusterAppUIType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #onClusterAppUITypeAsString}.
     * </p>
     * 
     * @return The application UI type associated with the cluster's application user interface presigned URL.
     * @see OnClusterAppUIType
     */
    public final OnClusterAppUIType onClusterAppUIType() {
        return OnClusterAppUIType.fromValue(onClusterAppUIType);
    }

    /**
     * <p>
     * The application UI type associated with the cluster's application user interface presigned URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onClusterAppUIType} will return {@link OnClusterAppUIType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #onClusterAppUITypeAsString}.
     * </p>
     * 
     * @return The application UI type associated with the cluster's application user interface presigned URL.
     * @see OnClusterAppUIType
     */
    public final String onClusterAppUITypeAsString() {
        return onClusterAppUIType;
    }

    /**
     * <p>
     * The application ID associated with the cluster's application user interface presigned URL.
     * </p>
     * 
     * @return The application ID associated with the cluster's application user interface presigned URL.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Determines if the user interface presigned URL is for a dry run.
     * </p>
     * 
     * @return Determines if the user interface presigned URL is for a dry run.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The execution role ARN associated with the cluster's application user interface presigned URL.
     * </p>
     * 
     * @return The execution role ARN associated with the cluster's application user interface presigned URL.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(onClusterAppUITypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOnClusterAppUiPresignedUrlRequest)) {
            return false;
        }
        GetOnClusterAppUiPresignedUrlRequest other = (GetOnClusterAppUiPresignedUrlRequest) obj;
        return Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(onClusterAppUITypeAsString(), other.onClusterAppUITypeAsString())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(executionRoleArn(), other.executionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOnClusterAppUiPresignedUrlRequest").add("ClusterId", clusterId())
                .add("OnClusterAppUIType", onClusterAppUITypeAsString()).add("ApplicationId", applicationId())
                .add("DryRun", dryRun()).add("ExecutionRoleArn", executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "OnClusterAppUIType":
            return Optional.ofNullable(clazz.cast(onClusterAppUITypeAsString()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("OnClusterAppUIType", ON_CLUSTER_APP_UI_TYPE_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOnClusterAppUiPresignedUrlRequest, T> g) {
        return obj -> g.apply((GetOnClusterAppUiPresignedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetOnClusterAppUiPresignedUrlRequest> {
        /**
         * <p>
         * The cluster ID associated with the cluster's application user interface presigned URL.
         * </p>
         * 
         * @param clusterId
         *        The cluster ID associated with the cluster's application user interface presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The application UI type associated with the cluster's application user interface presigned URL.
         * </p>
         * 
         * @param onClusterAppUIType
         *        The application UI type associated with the cluster's application user interface presigned URL.
         * @see OnClusterAppUIType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnClusterAppUIType
         */
        Builder onClusterAppUIType(String onClusterAppUIType);

        /**
         * <p>
         * The application UI type associated with the cluster's application user interface presigned URL.
         * </p>
         * 
         * @param onClusterAppUIType
         *        The application UI type associated with the cluster's application user interface presigned URL.
         * @see OnClusterAppUIType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnClusterAppUIType
         */
        Builder onClusterAppUIType(OnClusterAppUIType onClusterAppUIType);

        /**
         * <p>
         * The application ID associated with the cluster's application user interface presigned URL.
         * </p>
         * 
         * @param applicationId
         *        The application ID associated with the cluster's application user interface presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Determines if the user interface presigned URL is for a dry run.
         * </p>
         * 
         * @param dryRun
         *        Determines if the user interface presigned URL is for a dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The execution role ARN associated with the cluster's application user interface presigned URL.
         * </p>
         * 
         * @param executionRoleArn
         *        The execution role ARN associated with the cluster's application user interface presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String onClusterAppUIType;

        private String applicationId;

        private Boolean dryRun;

        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOnClusterAppUiPresignedUrlRequest model) {
            super(model);
            clusterId(model.clusterId);
            onClusterAppUIType(model.onClusterAppUIType);
            applicationId(model.applicationId);
            dryRun(model.dryRun);
            executionRoleArn(model.executionRoleArn);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getOnClusterAppUIType() {
            return onClusterAppUIType;
        }

        public final void setOnClusterAppUIType(String onClusterAppUIType) {
            this.onClusterAppUIType = onClusterAppUIType;
        }

        @Override
        public final Builder onClusterAppUIType(String onClusterAppUIType) {
            this.onClusterAppUIType = onClusterAppUIType;
            return this;
        }

        @Override
        public final Builder onClusterAppUIType(OnClusterAppUIType onClusterAppUIType) {
            this.onClusterAppUIType(onClusterAppUIType == null ? null : onClusterAppUIType.toString());
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOnClusterAppUiPresignedUrlRequest build() {
            return new GetOnClusterAppUiPresignedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
