/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersistentAppUiPresignedUrlRequest extends EmrRequest implements
        ToCopyableBuilder<GetPersistentAppUiPresignedUrlRequest.Builder, GetPersistentAppUiPresignedUrlRequest> {
    private static final SdkField<String> PERSISTENT_APP_UI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersistentAppUIId").getter(getter(GetPersistentAppUiPresignedUrlRequest::persistentAppUIId))
            .setter(setter(Builder::persistentAppUIId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIId").build()).build();

    private static final SdkField<String> PERSISTENT_APP_UI_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersistentAppUIType").getter(getter(GetPersistentAppUiPresignedUrlRequest::persistentAppUITypeAsString))
            .setter(setter(Builder::persistentAppUIType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIType").build())
            .build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetPersistentAppUiPresignedUrlRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Boolean> AUTH_PROXY_CALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuthProxyCall").getter(getter(GetPersistentAppUiPresignedUrlRequest::authProxyCall))
            .setter(setter(Builder::authProxyCall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthProxyCall").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(GetPersistentAppUiPresignedUrlRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_ID_FIELD,
            PERSISTENT_APP_UI_TYPE_FIELD, APPLICATION_ID_FIELD, AUTH_PROXY_CALL_FIELD, EXECUTION_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String persistentAppUIId;

    private final String persistentAppUIType;

    private final String applicationId;

    private final Boolean authProxyCall;

    private final String executionRoleArn;

    private GetPersistentAppUiPresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.persistentAppUIId = builder.persistentAppUIId;
        this.persistentAppUIType = builder.persistentAppUIType;
        this.applicationId = builder.applicationId;
        this.authProxyCall = builder.authProxyCall;
        this.executionRoleArn = builder.executionRoleArn;
    }

    /**
     * <p>
     * The persistent application user interface ID associated with the presigned URL.
     * </p>
     * 
     * @return The persistent application user interface ID associated with the presigned URL.
     */
    public final String persistentAppUIId() {
        return persistentAppUIId;
    }

    /**
     * <p>
     * The persistent application user interface type associated with the presigned URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #persistentAppUIType} will return {@link PersistentAppUIType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #persistentAppUITypeAsString}.
     * </p>
     * 
     * @return The persistent application user interface type associated with the presigned URL.
     * @see PersistentAppUIType
     */
    public final PersistentAppUIType persistentAppUIType() {
        return PersistentAppUIType.fromValue(persistentAppUIType);
    }

    /**
     * <p>
     * The persistent application user interface type associated with the presigned URL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #persistentAppUIType} will return {@link PersistentAppUIType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #persistentAppUITypeAsString}.
     * </p>
     * 
     * @return The persistent application user interface type associated with the presigned URL.
     * @see PersistentAppUIType
     */
    public final String persistentAppUITypeAsString() {
        return persistentAppUIType;
    }

    /**
     * <p>
     * The application ID associated with the presigned URL.
     * </p>
     * 
     * @return The application ID associated with the presigned URL.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A boolean that represents if the caller is an authentication proxy call.
     * </p>
     * 
     * @return A boolean that represents if the caller is an authentication proxy call.
     */
    public final Boolean authProxyCall() {
        return authProxyCall;
    }

    /**
     * <p>
     * The execution role ARN associated with the presigned URL.
     * </p>
     * 
     * @return The execution role ARN associated with the presigned URL.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUIId());
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUITypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(authProxyCall());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersistentAppUiPresignedUrlRequest)) {
            return false;
        }
        GetPersistentAppUiPresignedUrlRequest other = (GetPersistentAppUiPresignedUrlRequest) obj;
        return Objects.equals(persistentAppUIId(), other.persistentAppUIId())
                && Objects.equals(persistentAppUITypeAsString(), other.persistentAppUITypeAsString())
                && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(authProxyCall(), other.authProxyCall())
                && Objects.equals(executionRoleArn(), other.executionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPersistentAppUiPresignedUrlRequest").add("PersistentAppUIId", persistentAppUIId())
                .add("PersistentAppUIType", persistentAppUITypeAsString()).add("ApplicationId", applicationId())
                .add("AuthProxyCall", authProxyCall()).add("ExecutionRoleArn", executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersistentAppUIId":
            return Optional.ofNullable(clazz.cast(persistentAppUIId()));
        case "PersistentAppUIType":
            return Optional.ofNullable(clazz.cast(persistentAppUITypeAsString()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "AuthProxyCall":
            return Optional.ofNullable(clazz.cast(authProxyCall()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersistentAppUIId", PERSISTENT_APP_UI_ID_FIELD);
        map.put("PersistentAppUIType", PERSISTENT_APP_UI_TYPE_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("AuthProxyCall", AUTH_PROXY_CALL_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPersistentAppUiPresignedUrlRequest, T> g) {
        return obj -> g.apply((GetPersistentAppUiPresignedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPersistentAppUiPresignedUrlRequest> {
        /**
         * <p>
         * The persistent application user interface ID associated with the presigned URL.
         * </p>
         * 
         * @param persistentAppUIId
         *        The persistent application user interface ID associated with the presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUIId(String persistentAppUIId);

        /**
         * <p>
         * The persistent application user interface type associated with the presigned URL.
         * </p>
         * 
         * @param persistentAppUIType
         *        The persistent application user interface type associated with the presigned URL.
         * @see PersistentAppUIType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersistentAppUIType
         */
        Builder persistentAppUIType(String persistentAppUIType);

        /**
         * <p>
         * The persistent application user interface type associated with the presigned URL.
         * </p>
         * 
         * @param persistentAppUIType
         *        The persistent application user interface type associated with the presigned URL.
         * @see PersistentAppUIType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersistentAppUIType
         */
        Builder persistentAppUIType(PersistentAppUIType persistentAppUIType);

        /**
         * <p>
         * The application ID associated with the presigned URL.
         * </p>
         * 
         * @param applicationId
         *        The application ID associated with the presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A boolean that represents if the caller is an authentication proxy call.
         * </p>
         * 
         * @param authProxyCall
         *        A boolean that represents if the caller is an authentication proxy call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authProxyCall(Boolean authProxyCall);

        /**
         * <p>
         * The execution role ARN associated with the presigned URL.
         * </p>
         * 
         * @param executionRoleArn
         *        The execution role ARN associated with the presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String persistentAppUIId;

        private String persistentAppUIType;

        private String applicationId;

        private Boolean authProxyCall;

        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersistentAppUiPresignedUrlRequest model) {
            super(model);
            persistentAppUIId(model.persistentAppUIId);
            persistentAppUIType(model.persistentAppUIType);
            applicationId(model.applicationId);
            authProxyCall(model.authProxyCall);
            executionRoleArn(model.executionRoleArn);
        }

        public final String getPersistentAppUIId() {
            return persistentAppUIId;
        }

        public final void setPersistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
        }

        @Override
        public final Builder persistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
            return this;
        }

        public final String getPersistentAppUIType() {
            return persistentAppUIType;
        }

        public final void setPersistentAppUIType(String persistentAppUIType) {
            this.persistentAppUIType = persistentAppUIType;
        }

        @Override
        public final Builder persistentAppUIType(String persistentAppUIType) {
            this.persistentAppUIType = persistentAppUIType;
            return this;
        }

        @Override
        public final Builder persistentAppUIType(PersistentAppUIType persistentAppUIType) {
            this.persistentAppUIType(persistentAppUIType == null ? null : persistentAppUIType.toString());
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Boolean getAuthProxyCall() {
            return authProxyCall;
        }

        public final void setAuthProxyCall(Boolean authProxyCall) {
            this.authProxyCall = authProxyCall;
        }

        @Override
        public final Builder authProxyCall(Boolean authProxyCall) {
            this.authProxyCall = authProxyCall;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPersistentAppUiPresignedUrlRequest build() {
            return new GetPersistentAppUiPresignedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
