/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersistentAppUiPresignedUrlResponse extends EmrResponse implements
        ToCopyableBuilder<GetPersistentAppUiPresignedUrlResponse.Builder, GetPersistentAppUiPresignedUrlResponse> {
    private static final SdkField<Boolean> PRESIGNED_URL_READY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PresignedURLReady").getter(getter(GetPersistentAppUiPresignedUrlResponse::presignedURLReady))
            .setter(setter(Builder::presignedURLReady))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresignedURLReady").build()).build();

    private static final SdkField<String> PRESIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresignedURL").getter(getter(GetPersistentAppUiPresignedUrlResponse::presignedURL))
            .setter(setter(Builder::presignedURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresignedURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESIGNED_URL_READY_FIELD,
            PRESIGNED_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean presignedURLReady;

    private final String presignedURL;

    private GetPersistentAppUiPresignedUrlResponse(BuilderImpl builder) {
        super(builder);
        this.presignedURLReady = builder.presignedURLReady;
        this.presignedURL = builder.presignedURL;
    }

    /**
     * <p>
     * Used to determine if the presigned URL is ready.
     * </p>
     * 
     * @return Used to determine if the presigned URL is ready.
     */
    public final Boolean presignedURLReady() {
        return presignedURLReady;
    }

    /**
     * <p>
     * The returned presigned URL.
     * </p>
     * 
     * @return The returned presigned URL.
     */
    public final String presignedURL() {
        return presignedURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(presignedURLReady());
        hashCode = 31 * hashCode + Objects.hashCode(presignedURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersistentAppUiPresignedUrlResponse)) {
            return false;
        }
        GetPersistentAppUiPresignedUrlResponse other = (GetPersistentAppUiPresignedUrlResponse) obj;
        return Objects.equals(presignedURLReady(), other.presignedURLReady())
                && Objects.equals(presignedURL(), other.presignedURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPersistentAppUiPresignedUrlResponse").add("PresignedURLReady", presignedURLReady())
                .add("PresignedURL", presignedURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PresignedURLReady":
            return Optional.ofNullable(clazz.cast(presignedURLReady()));
        case "PresignedURL":
            return Optional.ofNullable(clazz.cast(presignedURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PresignedURLReady", PRESIGNED_URL_READY_FIELD);
        map.put("PresignedURL", PRESIGNED_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPersistentAppUiPresignedUrlResponse, T> g) {
        return obj -> g.apply((GetPersistentAppUiPresignedUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPersistentAppUiPresignedUrlResponse> {
        /**
         * <p>
         * Used to determine if the presigned URL is ready.
         * </p>
         * 
         * @param presignedURLReady
         *        Used to determine if the presigned URL is ready.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedURLReady(Boolean presignedURLReady);

        /**
         * <p>
         * The returned presigned URL.
         * </p>
         * 
         * @param presignedURL
         *        The returned presigned URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedURL(String presignedURL);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private Boolean presignedURLReady;

        private String presignedURL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersistentAppUiPresignedUrlResponse model) {
            super(model);
            presignedURLReady(model.presignedURLReady);
            presignedURL(model.presignedURL);
        }

        public final Boolean getPresignedURLReady() {
            return presignedURLReady;
        }

        public final void setPresignedURLReady(Boolean presignedURLReady) {
            this.presignedURLReady = presignedURLReady;
        }

        @Override
        public final Builder presignedURLReady(Boolean presignedURLReady) {
            this.presignedURLReady = presignedURLReady;
            return this;
        }

        public final String getPresignedURL() {
            return presignedURL;
        }

        public final void setPresignedURL(String presignedURL) {
            this.presignedURL = presignedURL;
        }

        @Override
        public final Builder presignedURL(String presignedURL) {
            this.presignedURL = presignedURL;
            return this;
        }

        @Override
        public GetPersistentAppUiPresignedUrlResponse build() {
            return new GetPersistentAppUiPresignedUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
