/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSupportedInstanceTypesRequest extends EmrRequest implements
        ToCopyableBuilder<ListSupportedInstanceTypesRequest.Builder, ListSupportedInstanceTypesRequest> {
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseLabel").getter(getter(ListSupportedInstanceTypesRequest::releaseLabel))
            .setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListSupportedInstanceTypesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_LABEL_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String releaseLabel;

    private final String marker;

    private ListSupportedInstanceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.releaseLabel = builder.releaseLabel;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon EMR release label determines the <a
     * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-app-versions-6.x.html">versions of
     * open-source application packages</a> that Amazon EMR has installed on the cluster. Release labels are in the
     * format <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release number such as <code>emr-6.10.0</code>. For
     * more information about Amazon EMR releases and their included application versions and features, see the <i> <a
     * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html">Amazon EMR Release
     * Guide</a> </i>.
     * </p>
     * 
     * @return The Amazon EMR release label determines the <a
     *         href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-app-versions-6.x.html">versions of
     *         open-source application packages</a> that Amazon EMR has installed on the cluster. Release labels are in
     *         the format <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release number such as
     *         <code>emr-6.10.0</code>. For more information about Amazon EMR releases and their included application
     *         versions and features, see the <i> <a
     *         href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html">Amazon EMR Release
     *         Guide</a> </i>.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The pagination token that marks the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that marks the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedInstanceTypesRequest)) {
            return false;
        }
        ListSupportedInstanceTypesRequest other = (ListSupportedInstanceTypesRequest) obj;
        return Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSupportedInstanceTypesRequest").add("ReleaseLabel", releaseLabel()).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReleaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReleaseLabel", RELEASE_LABEL_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedInstanceTypesRequest, T> g) {
        return obj -> g.apply((ListSupportedInstanceTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSupportedInstanceTypesRequest> {
        /**
         * <p>
         * The Amazon EMR release label determines the <a
         * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-app-versions-6.x.html">versions of
         * open-source application packages</a> that Amazon EMR has installed on the cluster. Release labels are in the
         * format <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release number such as <code>emr-6.10.0</code>.
         * For more information about Amazon EMR releases and their included application versions and features, see the
         * <i> <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html">Amazon EMR
         * Release Guide</a> </i>.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release label determines the <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-app-versions-6.x.html">versions
         *        of open-source application packages</a> that Amazon EMR has installed on the cluster. Release labels
         *        are in the format <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release number such as
         *        <code>emr-6.10.0</code>. For more information about Amazon EMR releases and their included application
         *        versions and features, see the <i> <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html">Amazon EMR
         *        Release Guide</a> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The pagination token that marks the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that marks the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String releaseLabel;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedInstanceTypesRequest model) {
            super(model);
            releaseLabel(model.releaseLabel);
            marker(model.marker);
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSupportedInstanceTypesRequest build() {
            return new ListSupportedInstanceTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
