/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Holds persistent application user interface information. Applications installed on the Amazon EMR cluster publish
 * user interfaces as web sites to monitor cluster activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersistentAppUI implements SdkPojo, Serializable, ToCopyableBuilder<PersistentAppUI.Builder, PersistentAppUI> {
    private static final SdkField<String> PERSISTENT_APP_UI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersistentAppUIId").getter(getter(PersistentAppUI::persistentAppUIId))
            .setter(setter(Builder::persistentAppUIId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIId").build()).build();

    private static final SdkField<List<String>> PERSISTENT_APP_UI_TYPE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PersistentAppUITypeList")
            .getter(getter(PersistentAppUI::persistentAppUITypeListAsStrings))
            .setter(setter(Builder::persistentAppUITypeListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUITypeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PERSISTENT_APP_UI_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersistentAppUIStatus").getter(getter(PersistentAppUI::persistentAppUIStatus))
            .setter(setter(Builder::persistentAppUIStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIStatus").build())
            .build();

    private static final SdkField<String> AUTHOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorId").getter(getter(PersistentAppUI::authorId)).setter(setter(Builder::authorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PersistentAppUI::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PersistentAppUI::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_STATE_CHANGE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastStateChangeReason").getter(getter(PersistentAppUI::lastStateChangeReason))
            .setter(setter(Builder::lastStateChangeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStateChangeReason").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PersistentAppUI::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_ID_FIELD,
            PERSISTENT_APP_UI_TYPE_LIST_FIELD, PERSISTENT_APP_UI_STATUS_FIELD, AUTHOR_ID_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_STATE_CHANGE_REASON_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String persistentAppUIId;

    private final List<String> persistentAppUITypeList;

    private final String persistentAppUIStatus;

    private final String authorId;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String lastStateChangeReason;

    private final List<Tag> tags;

    private PersistentAppUI(BuilderImpl builder) {
        this.persistentAppUIId = builder.persistentAppUIId;
        this.persistentAppUITypeList = builder.persistentAppUITypeList;
        this.persistentAppUIStatus = builder.persistentAppUIStatus;
        this.authorId = builder.authorId;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastStateChangeReason = builder.lastStateChangeReason;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier for the persistent application user interface object.
     * </p>
     * 
     * @return The identifier for the persistent application user interface object.
     */
    public final String persistentAppUIId() {
        return persistentAppUIId;
    }

    /**
     * <p>
     * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersistentAppUITypeList} method.
     * </p>
     * 
     * @return The type list for the persistent application user interface object. Valid values include SHS, YTS, or
     *         TEZ.
     */
    public final List<PersistentAppUIType> persistentAppUITypeList() {
        return PersistentAppUITypeListCopier.copyStringToEnum(persistentAppUITypeList);
    }

    /**
     * For responses, this returns true if the service returned a value for the PersistentAppUITypeList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPersistentAppUITypeList() {
        return persistentAppUITypeList != null && !(persistentAppUITypeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersistentAppUITypeList} method.
     * </p>
     * 
     * @return The type list for the persistent application user interface object. Valid values include SHS, YTS, or
     *         TEZ.
     */
    public final List<String> persistentAppUITypeListAsStrings() {
        return persistentAppUITypeList;
    }

    /**
     * <p>
     * The status for the persistent application user interface object.
     * </p>
     * 
     * @return The status for the persistent application user interface object.
     */
    public final String persistentAppUIStatus() {
        return persistentAppUIStatus;
    }

    /**
     * <p>
     * The author ID for the persistent application user interface object.
     * </p>
     * 
     * @return The author ID for the persistent application user interface object.
     */
    public final String authorId() {
        return authorId;
    }

    /**
     * <p>
     * The creation date and time for the persistent application user interface object.
     * </p>
     * 
     * @return The creation date and time for the persistent application user interface object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time the persistent application user interface object was last changed.
     * </p>
     * 
     * @return The date and time the persistent application user interface object was last changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The reason the persistent application user interface object was last changed.
     * </p>
     * 
     * @return The reason the persistent application user interface object was last changed.
     */
    public final String lastStateChangeReason() {
        return lastStateChangeReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of tags for the persistent application user interface object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of tags for the persistent application user interface object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUIId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPersistentAppUITypeList() ? persistentAppUITypeListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUIStatus());
        hashCode = 31 * hashCode + Objects.hashCode(authorId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersistentAppUI)) {
            return false;
        }
        PersistentAppUI other = (PersistentAppUI) obj;
        return Objects.equals(persistentAppUIId(), other.persistentAppUIId())
                && hasPersistentAppUITypeList() == other.hasPersistentAppUITypeList()
                && Objects.equals(persistentAppUITypeListAsStrings(), other.persistentAppUITypeListAsStrings())
                && Objects.equals(persistentAppUIStatus(), other.persistentAppUIStatus())
                && Objects.equals(authorId(), other.authorId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastStateChangeReason(), other.lastStateChangeReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PersistentAppUI").add("PersistentAppUIId", persistentAppUIId())
                .add("PersistentAppUITypeList", hasPersistentAppUITypeList() ? persistentAppUITypeListAsStrings() : null)
                .add("PersistentAppUIStatus", persistentAppUIStatus()).add("AuthorId", authorId())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("LastStateChangeReason", lastStateChangeReason()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersistentAppUIId":
            return Optional.ofNullable(clazz.cast(persistentAppUIId()));
        case "PersistentAppUITypeList":
            return Optional.ofNullable(clazz.cast(persistentAppUITypeListAsStrings()));
        case "PersistentAppUIStatus":
            return Optional.ofNullable(clazz.cast(persistentAppUIStatus()));
        case "AuthorId":
            return Optional.ofNullable(clazz.cast(authorId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastStateChangeReason":
            return Optional.ofNullable(clazz.cast(lastStateChangeReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersistentAppUIId", PERSISTENT_APP_UI_ID_FIELD);
        map.put("PersistentAppUITypeList", PERSISTENT_APP_UI_TYPE_LIST_FIELD);
        map.put("PersistentAppUIStatus", PERSISTENT_APP_UI_STATUS_FIELD);
        map.put("AuthorId", AUTHOR_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastStateChangeReason", LAST_STATE_CHANGE_REASON_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PersistentAppUI, T> g) {
        return obj -> g.apply((PersistentAppUI) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersistentAppUI> {
        /**
         * <p>
         * The identifier for the persistent application user interface object.
         * </p>
         * 
         * @param persistentAppUIId
         *        The identifier for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUIId(String persistentAppUIId);

        /**
         * <p>
         * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
         * </p>
         * 
         * @param persistentAppUITypeList
         *        The type list for the persistent application user interface object. Valid values include SHS, YTS, or
         *        TEZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUITypeListWithStrings(Collection<String> persistentAppUITypeList);

        /**
         * <p>
         * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
         * </p>
         * 
         * @param persistentAppUITypeList
         *        The type list for the persistent application user interface object. Valid values include SHS, YTS, or
         *        TEZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUITypeListWithStrings(String... persistentAppUITypeList);

        /**
         * <p>
         * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
         * </p>
         * 
         * @param persistentAppUITypeList
         *        The type list for the persistent application user interface object. Valid values include SHS, YTS, or
         *        TEZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUITypeList(Collection<PersistentAppUIType> persistentAppUITypeList);

        /**
         * <p>
         * The type list for the persistent application user interface object. Valid values include SHS, YTS, or TEZ.
         * </p>
         * 
         * @param persistentAppUITypeList
         *        The type list for the persistent application user interface object. Valid values include SHS, YTS, or
         *        TEZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUITypeList(PersistentAppUIType... persistentAppUITypeList);

        /**
         * <p>
         * The status for the persistent application user interface object.
         * </p>
         * 
         * @param persistentAppUIStatus
         *        The status for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUIStatus(String persistentAppUIStatus);

        /**
         * <p>
         * The author ID for the persistent application user interface object.
         * </p>
         * 
         * @param authorId
         *        The author ID for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorId(String authorId);

        /**
         * <p>
         * The creation date and time for the persistent application user interface object.
         * </p>
         * 
         * @param creationTime
         *        The creation date and time for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time the persistent application user interface object was last changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the persistent application user interface object was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The reason the persistent application user interface object was last changed.
         * </p>
         * 
         * @param lastStateChangeReason
         *        The reason the persistent application user interface object was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStateChangeReason(String lastStateChangeReason);

        /**
         * <p>
         * A collection of tags for the persistent application user interface object.
         * </p>
         * 
         * @param tags
         *        A collection of tags for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A collection of tags for the persistent application user interface object.
         * </p>
         * 
         * @param tags
         *        A collection of tags for the persistent application user interface object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A collection of tags for the persistent application user interface object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.emr.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.emr.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.emr.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String persistentAppUIId;

        private List<String> persistentAppUITypeList = DefaultSdkAutoConstructList.getInstance();

        private String persistentAppUIStatus;

        private String authorId;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String lastStateChangeReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersistentAppUI model) {
            persistentAppUIId(model.persistentAppUIId);
            persistentAppUITypeListWithStrings(model.persistentAppUITypeList);
            persistentAppUIStatus(model.persistentAppUIStatus);
            authorId(model.authorId);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastStateChangeReason(model.lastStateChangeReason);
            tags(model.tags);
        }

        public final String getPersistentAppUIId() {
            return persistentAppUIId;
        }

        public final void setPersistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
        }

        @Override
        public final Builder persistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
            return this;
        }

        public final Collection<String> getPersistentAppUITypeList() {
            if (persistentAppUITypeList instanceof SdkAutoConstructList) {
                return null;
            }
            return persistentAppUITypeList;
        }

        public final void setPersistentAppUITypeList(Collection<String> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copy(persistentAppUITypeList);
        }

        @Override
        public final Builder persistentAppUITypeListWithStrings(Collection<String> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copy(persistentAppUITypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persistentAppUITypeListWithStrings(String... persistentAppUITypeList) {
            persistentAppUITypeListWithStrings(Arrays.asList(persistentAppUITypeList));
            return this;
        }

        @Override
        public final Builder persistentAppUITypeList(Collection<PersistentAppUIType> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copyEnumToString(persistentAppUITypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persistentAppUITypeList(PersistentAppUIType... persistentAppUITypeList) {
            persistentAppUITypeList(Arrays.asList(persistentAppUITypeList));
            return this;
        }

        public final String getPersistentAppUIStatus() {
            return persistentAppUIStatus;
        }

        public final void setPersistentAppUIStatus(String persistentAppUIStatus) {
            this.persistentAppUIStatus = persistentAppUIStatus;
        }

        @Override
        public final Builder persistentAppUIStatus(String persistentAppUIStatus) {
            this.persistentAppUIStatus = persistentAppUIStatus;
            return this;
        }

        public final String getAuthorId() {
            return authorId;
        }

        public final void setAuthorId(String authorId) {
            this.authorId = authorId;
        }

        @Override
        public final Builder authorId(String authorId) {
            this.authorId = authorId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastStateChangeReason() {
            return lastStateChangeReason;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PersistentAppUI build() {
            return new PersistentAppUI(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
