/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of port ranges that are permitted to allow inbound traffic from all public IP addresses. To specify a single
 * port, use the same value for <code>MinRange</code> and <code>MaxRange</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortRange implements SdkPojo, Serializable, ToCopyableBuilder<PortRange.Builder, PortRange> {
    private static final SdkField<Integer> MIN_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinRange").getter(getter(PortRange::minRange)).setter(setter(Builder::minRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRange").build()).build();

    private static final SdkField<Integer> MAX_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRange").getter(getter(PortRange::maxRange)).setter(setter(Builder::maxRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_RANGE_FIELD,
            MAX_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minRange;

    private final Integer maxRange;

    private PortRange(BuilderImpl builder) {
        this.minRange = builder.minRange;
        this.maxRange = builder.maxRange;
    }

    /**
     * <p>
     * The smallest port number in a specified range of port numbers.
     * </p>
     * 
     * @return The smallest port number in a specified range of port numbers.
     */
    public final Integer minRange() {
        return minRange;
    }

    /**
     * <p>
     * The smallest port number in a specified range of port numbers.
     * </p>
     * 
     * @return The smallest port number in a specified range of port numbers.
     */
    public final Integer maxRange() {
        return maxRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minRange());
        hashCode = 31 * hashCode + Objects.hashCode(maxRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortRange)) {
            return false;
        }
        PortRange other = (PortRange) obj;
        return Objects.equals(minRange(), other.minRange()) && Objects.equals(maxRange(), other.maxRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortRange").add("MinRange", minRange()).add("MaxRange", maxRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinRange":
            return Optional.ofNullable(clazz.cast(minRange()));
        case "MaxRange":
            return Optional.ofNullable(clazz.cast(maxRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinRange", MIN_RANGE_FIELD);
        map.put("MaxRange", MAX_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortRange, T> g) {
        return obj -> g.apply((PortRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortRange> {
        /**
         * <p>
         * The smallest port number in a specified range of port numbers.
         * </p>
         * 
         * @param minRange
         *        The smallest port number in a specified range of port numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minRange(Integer minRange);

        /**
         * <p>
         * The smallest port number in a specified range of port numbers.
         * </p>
         * 
         * @param maxRange
         *        The smallest port number in a specified range of port numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRange(Integer maxRange);
    }

    static final class BuilderImpl implements Builder {
        private Integer minRange;

        private Integer maxRange;

        private BuilderImpl() {
        }

        private BuilderImpl(PortRange model) {
            minRange(model.minRange);
            maxRange(model.maxRange);
        }

        public final Integer getMinRange() {
            return minRange;
        }

        public final void setMinRange(Integer minRange) {
            this.minRange = minRange;
        }

        @Override
        public final Builder minRange(Integer minRange) {
            this.minRange = minRange;
            return this;
        }

        public final Integer getMaxRange() {
            return maxRange;
        }

        public final void setMaxRange(Integer maxRange) {
            this.maxRange = maxRange;
        }

        @Override
        public final Builder maxRange(Integer maxRange) {
            this.maxRange = maxRange;
            return this;
        }

        @Override
        public PortRange build() {
            return new PortRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
