/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAutoScalingPolicyRequest extends EmrRequest implements
        ToCopyableBuilder<PutAutoScalingPolicyRequest.Builder, PutAutoScalingPolicyRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(PutAutoScalingPolicyRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupId").getter(getter(PutAutoScalingPolicyRequest::instanceGroupId))
            .setter(setter(Builder::instanceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()).build();

    private static final SdkField<AutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField
            .<AutoScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("AutoScalingPolicy")
            .getter(getter(PutAutoScalingPolicyRequest::autoScalingPolicy)).setter(setter(Builder::autoScalingPolicy))
            .constructor(AutoScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_GROUP_ID_FIELD, AUTO_SCALING_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String instanceGroupId;

    private final AutoScalingPolicy autoScalingPolicy;

    private PutAutoScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    /**
     * <p>
     * Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this
     * cluster.
     * </p>
     * 
     * @return Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is
     *         within this cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * Specifies the ID of the instance group to which the automatic scaling policy is applied.
     * </p>
     * 
     * @return Specifies the ID of the instance group to which the automatic scaling policy is applied.
     */
    public final String instanceGroupId() {
        return instanceGroupId;
    }

    /**
     * <p>
     * Specifies the definition of the automatic scaling policy.
     * </p>
     * 
     * @return Specifies the definition of the automatic scaling policy.
     */
    public final AutoScalingPolicy autoScalingPolicy() {
        return autoScalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoScalingPolicyRequest)) {
            return false;
        }
        PutAutoScalingPolicyRequest other = (PutAutoScalingPolicyRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceGroupId(), other.instanceGroupId())
                && Objects.equals(autoScalingPolicy(), other.autoScalingPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAutoScalingPolicyRequest").add("ClusterId", clusterId())
                .add("InstanceGroupId", instanceGroupId()).add("AutoScalingPolicy", autoScalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceGroupId":
            return Optional.ofNullable(clazz.cast(instanceGroupId()));
        case "AutoScalingPolicy":
            return Optional.ofNullable(clazz.cast(autoScalingPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("InstanceGroupId", INSTANCE_GROUP_ID_FIELD);
        map.put("AutoScalingPolicy", AUTO_SCALING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAutoScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutAutoScalingPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAutoScalingPolicyRequest> {
        /**
         * <p>
         * Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within
         * this cluster.
         * </p>
         * 
         * @param clusterId
         *        Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is
         *        within this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * Specifies the ID of the instance group to which the automatic scaling policy is applied.
         * </p>
         * 
         * @param instanceGroupId
         *        Specifies the ID of the instance group to which the automatic scaling policy is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupId(String instanceGroupId);

        /**
         * <p>
         * Specifies the definition of the automatic scaling policy.
         * </p>
         * 
         * @param autoScalingPolicy
         *        Specifies the definition of the automatic scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy);

        /**
         * <p>
         * Specifies the definition of the automatic scaling policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingPolicy.Builder} avoiding the
         * need to create one manually via {@link AutoScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #autoScalingPolicy(AutoScalingPolicy)}.
         * 
         * @param autoScalingPolicy
         *        a consumer that will call methods on {@link AutoScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingPolicy(AutoScalingPolicy)
         */
        default Builder autoScalingPolicy(Consumer<AutoScalingPolicy.Builder> autoScalingPolicy) {
            return autoScalingPolicy(AutoScalingPolicy.builder().applyMutation(autoScalingPolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String instanceGroupId;

        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoScalingPolicyRequest model) {
            super(model);
            clusterId(model.clusterId);
            instanceGroupId(model.instanceGroupId);
            autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceGroupId() {
            return instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final AutoScalingPolicy.Builder getAutoScalingPolicy() {
            return autoScalingPolicy != null ? autoScalingPolicy.toBuilder() : null;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAutoScalingPolicyRequest build() {
            return new PutAutoScalingPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
