/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUnhealthyNodeReplacementRequest extends EmrRequest implements
        ToCopyableBuilder<SetUnhealthyNodeReplacementRequest.Builder, SetUnhealthyNodeReplacementRequest> {
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobFlowIds")
            .getter(getter(SetUnhealthyNodeReplacementRequest::jobFlowIds))
            .setter(setter(Builder::jobFlowIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> UNHEALTHY_NODE_REPLACEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UnhealthyNodeReplacement").getter(getter(SetUnhealthyNodeReplacementRequest::unhealthyNodeReplacement))
            .setter(setter(Builder::unhealthyNodeReplacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyNodeReplacement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_IDS_FIELD,
            UNHEALTHY_NODE_REPLACEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> jobFlowIds;

    private final Boolean unhealthyNodeReplacement;

    private SetUnhealthyNodeReplacementRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
        this.unhealthyNodeReplacement = builder.unhealthyNodeReplacement;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobFlowIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobFlowIds() {
        return jobFlowIds != null && !(jobFlowIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of strings that uniquely identify the clusters for which to turn on unhealthy node replacement. You can
     * get these identifiers by running the <a>RunJobFlow</a> or the <a>DescribeJobFlows</a> operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobFlowIds} method.
     * </p>
     * 
     * @return The list of strings that uniquely identify the clusters for which to turn on unhealthy node replacement.
     *         You can get these identifiers by running the <a>RunJobFlow</a> or the <a>DescribeJobFlows</a> operations.
     */
    public final List<String> jobFlowIds() {
        return jobFlowIds;
    }

    /**
     * <p>
     * Indicates whether to turn on or turn off graceful unhealthy node replacement.
     * </p>
     * 
     * @return Indicates whether to turn on or turn off graceful unhealthy node replacement.
     */
    public final Boolean unhealthyNodeReplacement() {
        return unhealthyNodeReplacement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobFlowIds() ? jobFlowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyNodeReplacement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUnhealthyNodeReplacementRequest)) {
            return false;
        }
        SetUnhealthyNodeReplacementRequest other = (SetUnhealthyNodeReplacementRequest) obj;
        return hasJobFlowIds() == other.hasJobFlowIds() && Objects.equals(jobFlowIds(), other.jobFlowIds())
                && Objects.equals(unhealthyNodeReplacement(), other.unhealthyNodeReplacement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetUnhealthyNodeReplacementRequest").add("JobFlowIds", hasJobFlowIds() ? jobFlowIds() : null)
                .add("UnhealthyNodeReplacement", unhealthyNodeReplacement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowIds":
            return Optional.ofNullable(clazz.cast(jobFlowIds()));
        case "UnhealthyNodeReplacement":
            return Optional.ofNullable(clazz.cast(unhealthyNodeReplacement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobFlowIds", JOB_FLOW_IDS_FIELD);
        map.put("UnhealthyNodeReplacement", UNHEALTHY_NODE_REPLACEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetUnhealthyNodeReplacementRequest, T> g) {
        return obj -> g.apply((SetUnhealthyNodeReplacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetUnhealthyNodeReplacementRequest> {
        /**
         * <p>
         * The list of strings that uniquely identify the clusters for which to turn on unhealthy node replacement. You
         * can get these identifiers by running the <a>RunJobFlow</a> or the <a>DescribeJobFlows</a> operations.
         * </p>
         * 
         * @param jobFlowIds
         *        The list of strings that uniquely identify the clusters for which to turn on unhealthy node
         *        replacement. You can get these identifiers by running the <a>RunJobFlow</a> or the
         *        <a>DescribeJobFlows</a> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(Collection<String> jobFlowIds);

        /**
         * <p>
         * The list of strings that uniquely identify the clusters for which to turn on unhealthy node replacement. You
         * can get these identifiers by running the <a>RunJobFlow</a> or the <a>DescribeJobFlows</a> operations.
         * </p>
         * 
         * @param jobFlowIds
         *        The list of strings that uniquely identify the clusters for which to turn on unhealthy node
         *        replacement. You can get these identifiers by running the <a>RunJobFlow</a> or the
         *        <a>DescribeJobFlows</a> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(String... jobFlowIds);

        /**
         * <p>
         * Indicates whether to turn on or turn off graceful unhealthy node replacement.
         * </p>
         * 
         * @param unhealthyNodeReplacement
         *        Indicates whether to turn on or turn off graceful unhealthy node replacement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyNodeReplacement(Boolean unhealthyNodeReplacement);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean unhealthyNodeReplacement;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUnhealthyNodeReplacementRequest model) {
            super(model);
            jobFlowIds(model.jobFlowIds);
            unhealthyNodeReplacement(model.unhealthyNodeReplacement);
        }

        public final Collection<String> getJobFlowIds() {
            if (jobFlowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return jobFlowIds;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String... jobFlowIds) {
            jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final Boolean getUnhealthyNodeReplacement() {
            return unhealthyNodeReplacement;
        }

        public final void setUnhealthyNodeReplacement(Boolean unhealthyNodeReplacement) {
            this.unhealthyNodeReplacement = unhealthyNodeReplacement;
        }

        @Override
        public final Builder unhealthyNodeReplacement(Boolean unhealthyNodeReplacement) {
            this.unhealthyNodeReplacement = unhealthyNodeReplacement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUnhealthyNodeReplacementRequest build() {
            return new SetUnhealthyNodeReplacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
