/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The execution status details of the cluster step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepStatus implements SdkPojo, Serializable, ToCopyableBuilder<StepStatus.Builder, StepStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StepStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<StepStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<StepStateChangeReason> builder(MarshallingType.SDK_POJO).memberName("StateChangeReason")
            .getter(getter(StepStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .constructor(StepStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField
            .<FailureDetails> builder(MarshallingType.SDK_POJO).memberName("FailureDetails")
            .getter(getter(StepStatus::failureDetails)).setter(setter(Builder::failureDetails))
            .constructor(FailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()).build();

    private static final SdkField<StepTimeline> TIMELINE_FIELD = SdkField.<StepTimeline> builder(MarshallingType.SDK_POJO)
            .memberName("Timeline").getter(getter(StepStatus::timeline)).setter(setter(Builder::timeline))
            .constructor(StepTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, FAILURE_DETAILS_FIELD, TIMELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final StepStateChangeReason stateChangeReason;

    private final FailureDetails failureDetails;

    private final StepTimeline timeline;

    private StepStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.failureDetails = builder.failureDetails;
        this.timeline = builder.timeline;
    }

    /**
     * <p>
     * The execution state of the cluster step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The execution state of the cluster step.
     * @see StepState
     */
    public final StepState state() {
        return StepState.fromValue(state);
    }

    /**
     * <p>
     * The execution state of the cluster step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The execution state of the cluster step.
     * @see StepState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the step execution status change.
     * </p>
     * 
     * @return The reason for the step execution status change.
     */
    public final StepStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The details for the step failure including reason, message, and log file path where the root cause was
     * identified.
     * </p>
     * 
     * @return The details for the step failure including reason, message, and log file path where the root cause was
     *         identified.
     */
    public final FailureDetails failureDetails() {
        return failureDetails;
    }

    /**
     * <p>
     * The timeline of the cluster step status over time.
     * </p>
     * 
     * @return The timeline of the cluster step status over time.
     */
    public final StepTimeline timeline() {
        return timeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepStatus)) {
            return false;
        }
        StepStatus other = (StepStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason())
                && Objects.equals(failureDetails(), other.failureDetails()) && Objects.equals(timeline(), other.timeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepStatus").add("State", stateAsString()).add("StateChangeReason", stateChangeReason())
                .add("FailureDetails", failureDetails()).add("Timeline", timeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "FailureDetails":
            return Optional.ofNullable(clazz.cast(failureDetails()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("FailureDetails", FAILURE_DETAILS_FIELD);
        map.put("Timeline", TIMELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepStatus, T> g) {
        return obj -> g.apply((StepStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepStatus> {
        /**
         * <p>
         * The execution state of the cluster step.
         * </p>
         * 
         * @param state
         *        The execution state of the cluster step.
         * @see StepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepState
         */
        Builder state(String state);

        /**
         * <p>
         * The execution state of the cluster step.
         * </p>
         * 
         * @param state
         *        The execution state of the cluster step.
         * @see StepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepState
         */
        Builder state(StepState state);

        /**
         * <p>
         * The reason for the step execution status change.
         * </p>
         * 
         * @param stateChangeReason
         *        The reason for the step execution status change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(StepStateChangeReason stateChangeReason);

        /**
         * <p>
         * The reason for the step execution status change.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepStateChangeReason.Builder} avoiding
         * the need to create one manually via {@link StepStateChangeReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepStateChangeReason.Builder#build()} is called immediately and
         * its result is passed to {@link #stateChangeReason(StepStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link StepStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(StepStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<StepStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(StepStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }

        /**
         * <p>
         * The details for the step failure including reason, message, and log file path where the root cause was
         * identified.
         * </p>
         * 
         * @param failureDetails
         *        The details for the step failure including reason, message, and log file path where the root cause was
         *        identified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(FailureDetails failureDetails);

        /**
         * <p>
         * The details for the step failure including reason, message, and log file path where the root cause was
         * identified.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureDetails.Builder} avoiding the need
         * to create one manually via {@link FailureDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #failureDetails(FailureDetails)}.
         * 
         * @param failureDetails
         *        a consumer that will call methods on {@link FailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDetails(FailureDetails)
         */
        default Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return failureDetails(FailureDetails.builder().applyMutation(failureDetails).build());
        }

        /**
         * <p>
         * The timeline of the cluster step status over time.
         * </p>
         * 
         * @param timeline
         *        The timeline of the cluster step status over time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(StepTimeline timeline);

        /**
         * <p>
         * The timeline of the cluster step status over time.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepTimeline.Builder} avoiding the need
         * to create one manually via {@link StepTimeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepTimeline.Builder#build()} is called immediately and its
         * result is passed to {@link #timeline(StepTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link StepTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(StepTimeline)
         */
        default Builder timeline(Consumer<StepTimeline.Builder> timeline) {
            return timeline(StepTimeline.builder().applyMutation(timeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private StepStateChangeReason stateChangeReason;

        private FailureDetails failureDetails;

        private StepTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(StepStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            failureDetails(model.failureDetails);
            timeline(model.timeline);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StepState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StepStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(StepStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(StepStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return failureDetails != null ? failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final StepTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(StepTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(StepTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        @Override
        public StepStatus build() {
            return new StepStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
