/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStudioRequest extends EmrRequest implements
        ToCopyableBuilder<UpdateStudioRequest.Builder, UpdateStudioRequest> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioId").getter(getter(UpdateStudioRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateStudioRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateStudioRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(UpdateStudioRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultS3Location").getter(getter(UpdateStudioRequest::defaultS3Location))
            .setter(setter(Builder::defaultS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultS3Location").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(UpdateStudioRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SUBNET_IDS_FIELD, DEFAULT_S3_LOCATION_FIELD, ENCRYPTION_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String studioId;

    private final String name;

    private final String description;

    private final List<String> subnetIds;

    private final String defaultS3Location;

    private final String encryptionKeyArn;

    private UpdateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.studioId = builder.studioId;
        this.name = builder.name;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
        this.defaultS3Location = builder.defaultS3Location;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio to update.
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio to update.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * A descriptive name for the Amazon EMR Studio.
     * </p>
     * 
     * @return A descriptive name for the Amazon EMR Studio.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description to assign to the Amazon EMR Studio.
     * </p>
     * 
     * @return A detailed description to assign to the Amazon EMR Studio.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also
     * include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can
     * have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but
     *         must also include all of the subnet IDs previously associated with the Studio. The list order does not
     *         matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.
     * </p>
     * 
     * @return The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.
     */
    public final String defaultS3Location() {
        return defaultS3Location;
    }

    /**
     * <p>
     * The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to
     * Amazon S3.
     * </p>
     * 
     * @return The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed
     *         up to Amazon S3.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStudioRequest)) {
            return false;
        }
        UpdateStudioRequest other = (UpdateStudioRequest) obj;
        return Objects.equals(studioId(), other.studioId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(defaultS3Location(), other.defaultS3Location())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStudioRequest").add("StudioId", studioId()).add("Name", name())
                .add("Description", description()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("DefaultS3Location", defaultS3Location()).add("EncryptionKeyArn", encryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "DefaultS3Location":
            return Optional.ofNullable(clazz.cast(defaultS3Location()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StudioId", STUDIO_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("DefaultS3Location", DEFAULT_S3_LOCATION_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStudioRequest, T> g) {
        return obj -> g.apply((UpdateStudioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStudioRequest> {
        /**
         * <p>
         * The ID of the Amazon EMR Studio to update.
         * </p>
         * 
         * @param studioId
         *        The ID of the Amazon EMR Studio to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * A descriptive name for the Amazon EMR Studio.
         * </p>
         * 
         * @param name
         *        A descriptive name for the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description to assign to the Amazon EMR Studio.
         * </p>
         * 
         * @param description
         *        A detailed description to assign to the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must
         * also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A
         * Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but
         *        must also include all of the subnet IDs previously associated with the Studio. The list order does not
         *        matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the
         *        Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must
         * also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A
         * Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but
         *        must also include all of the subnet IDs previously associated with the Studio. The list order does not
         *        matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the
         *        Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.
         * </p>
         * 
         * @param defaultS3Location
         *        The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultS3Location(String defaultS3Location);

        /**
         * <p>
         * The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to
         * Amazon S3.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when
         *        backed up to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String studioId;

        private String name;

        private String description;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String defaultS3Location;

        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStudioRequest model) {
            super(model);
            studioId(model.studioId);
            name(model.name);
            description(model.description);
            subnetIds(model.subnetIds);
            defaultS3Location(model.defaultS3Location);
            encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getDefaultS3Location() {
            return defaultS3Location;
        }

        public final void setDefaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
        }

        @Override
        public final Builder defaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStudioRequest build() {
            return new UpdateStudioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
