/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to an AddInstanceGroups call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddInstanceGroupsRequest extends EmrRequest implements
        ToCopyableBuilder<AddInstanceGroupsRequest.Builder, AddInstanceGroupsRequest> {
    private static final SdkField<List<InstanceGroupConfig>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<InstanceGroupConfig>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(AddInstanceGroupsRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceGroupConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceGroupConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFlowId").getter(getter(AddInstanceGroupsRequest::jobFlowId)).setter(setter(Builder::jobFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUPS_FIELD,
            JOB_FLOW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceGroupConfig> instanceGroups;

    private final String jobFlowId;

    private AddInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceGroups = builder.instanceGroups;
        this.jobFlowId = builder.jobFlowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Instance groups to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return Instance groups to add.
     */
    public final List<InstanceGroupConfig> instanceGroups() {
        return instanceGroups;
    }

    /**
     * <p>
     * Job flow in which to add the instance groups.
     * </p>
     * 
     * @return Job flow in which to add the instance groups.
     */
    public final String jobFlowId() {
        return jobFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest) obj;
        return hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(instanceGroups(), other.instanceGroups())
                && Objects.equals(jobFlowId(), other.jobFlowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddInstanceGroupsRequest").add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null)
                .add("JobFlowId", jobFlowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "JobFlowId":
            return Optional.ofNullable(clazz.cast(jobFlowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("JobFlowId", JOB_FLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceGroupsRequest, T> g) {
        return obj -> g.apply((AddInstanceGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddInstanceGroupsRequest> {
        /**
         * <p>
         * Instance groups to add.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups);

        /**
         * <p>
         * Instance groups to add.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(InstanceGroupConfig... instanceGroups);

        /**
         * <p>
         * Instance groups to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.InstanceGroupConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.InstanceGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.InstanceGroupConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceGroups(List<InstanceGroupConfig>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.InstanceGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<InstanceGroupConfig>)
         */
        Builder instanceGroups(Consumer<InstanceGroupConfig.Builder>... instanceGroups);

        /**
         * <p>
         * Job flow in which to add the instance groups.
         * </p>
         * 
         * @param jobFlowId
         *        Job flow in which to add the instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowId(String jobFlowId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private List<InstanceGroupConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private String jobFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsRequest model) {
            super(model);
            instanceGroups(model.instanceGroups);
            jobFlowId(model.jobFlowId);
        }

        public final List<InstanceGroupConfig.Builder> getInstanceGroups() {
            List<InstanceGroupConfig.Builder> result = InstanceGroupConfigListCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupConfig.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> InstanceGroupConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getJobFlowId() {
            return jobFlowId;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceGroupsRequest build() {
            return new AddInstanceGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
