/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePersistentAppUiRequest extends EmrRequest implements
        ToCopyableBuilder<CreatePersistentAppUiRequest.Builder, CreatePersistentAppUiRequest> {
    private static final SdkField<String> TARGET_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetResourceArn").getter(getter(CreatePersistentAppUiRequest::targetResourceArn))
            .setter(setter(Builder::targetResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResourceArn").build()).build();

    private static final SdkField<EMRContainersConfig> EMR_CONTAINERS_CONFIG_FIELD = SdkField
            .<EMRContainersConfig> builder(MarshallingType.SDK_POJO).memberName("EMRContainersConfig")
            .getter(getter(CreatePersistentAppUiRequest::emrContainersConfig)).setter(setter(Builder::emrContainersConfig))
            .constructor(EMRContainersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMRContainersConfig").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePersistentAppUiRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> X_REFERER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XReferer").getter(getter(CreatePersistentAppUiRequest::xReferer)).setter(setter(Builder::xReferer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XReferer").build()).build();

    private static final SdkField<String> PROFILER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfilerType").getter(getter(CreatePersistentAppUiRequest::profilerTypeAsString))
            .setter(setter(Builder::profilerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_ARN_FIELD,
            EMR_CONTAINERS_CONFIG_FIELD, TAGS_FIELD, X_REFERER_FIELD, PROFILER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetResourceArn;

    private final EMRContainersConfig emrContainersConfig;

    private final List<Tag> tags;

    private final String xReferer;

    private final String profilerType;

    private CreatePersistentAppUiRequest(BuilderImpl builder) {
        super(builder);
        this.targetResourceArn = builder.targetResourceArn;
        this.emrContainersConfig = builder.emrContainersConfig;
        this.tags = builder.tags;
        this.xReferer = builder.xReferer;
        this.profilerType = builder.profilerType;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the target resource.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the target resource.
     */
    public final String targetResourceArn() {
        return targetResourceArn;
    }

    /**
     * <p>
     * The EMR containers configuration.
     * </p>
     * 
     * @return The EMR containers configuration.
     */
    public final EMRContainersConfig emrContainersConfig() {
        return emrContainersConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for the persistent application user interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the persistent application user interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The cross reference for the persistent application user interface.
     * </p>
     * 
     * @return The cross reference for the persistent application user interface.
     */
    public final String xReferer() {
        return xReferer;
    }

    /**
     * <p>
     * The profiler type for the persistent application user interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profilerType} will
     * return {@link ProfilerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profilerTypeAsString}.
     * </p>
     * 
     * @return The profiler type for the persistent application user interface.
     * @see ProfilerType
     */
    public final ProfilerType profilerType() {
        return ProfilerType.fromValue(profilerType);
    }

    /**
     * <p>
     * The profiler type for the persistent application user interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profilerType} will
     * return {@link ProfilerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profilerTypeAsString}.
     * </p>
     * 
     * @return The profiler type for the persistent application user interface.
     * @see ProfilerType
     */
    public final String profilerTypeAsString() {
        return profilerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(emrContainersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(xReferer());
        hashCode = 31 * hashCode + Objects.hashCode(profilerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentAppUiRequest)) {
            return false;
        }
        CreatePersistentAppUiRequest other = (CreatePersistentAppUiRequest) obj;
        return Objects.equals(targetResourceArn(), other.targetResourceArn())
                && Objects.equals(emrContainersConfig(), other.emrContainersConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(xReferer(), other.xReferer())
                && Objects.equals(profilerTypeAsString(), other.profilerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePersistentAppUiRequest").add("TargetResourceArn", targetResourceArn())
                .add("EMRContainersConfig", emrContainersConfig()).add("Tags", hasTags() ? tags() : null)
                .add("XReferer", xReferer()).add("ProfilerType", profilerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetResourceArn":
            return Optional.ofNullable(clazz.cast(targetResourceArn()));
        case "EMRContainersConfig":
            return Optional.ofNullable(clazz.cast(emrContainersConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "XReferer":
            return Optional.ofNullable(clazz.cast(xReferer()));
        case "ProfilerType":
            return Optional.ofNullable(clazz.cast(profilerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetResourceArn", TARGET_RESOURCE_ARN_FIELD);
        map.put("EMRContainersConfig", EMR_CONTAINERS_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("XReferer", X_REFERER_FIELD);
        map.put("ProfilerType", PROFILER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentAppUiRequest, T> g) {
        return obj -> g.apply((CreatePersistentAppUiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePersistentAppUiRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the target resource.
         * </p>
         * 
         * @param targetResourceArn
         *        The unique Amazon Resource Name (ARN) of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceArn(String targetResourceArn);

        /**
         * <p>
         * The EMR containers configuration.
         * </p>
         * 
         * @param emrContainersConfig
         *        The EMR containers configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emrContainersConfig(EMRContainersConfig emrContainersConfig);

        /**
         * <p>
         * The EMR containers configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EMRContainersConfig.Builder} avoiding the
         * need to create one manually via {@link EMRContainersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EMRContainersConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #emrContainersConfig(EMRContainersConfig)}.
         * 
         * @param emrContainersConfig
         *        a consumer that will call methods on {@link EMRContainersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emrContainersConfig(EMRContainersConfig)
         */
        default Builder emrContainersConfig(Consumer<EMRContainersConfig.Builder> emrContainersConfig) {
            return emrContainersConfig(EMRContainersConfig.builder().applyMutation(emrContainersConfig).build());
        }

        /**
         * <p>
         * Tags for the persistent application user interface.
         * </p>
         * 
         * @param tags
         *        Tags for the persistent application user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags for the persistent application user interface.
         * </p>
         * 
         * @param tags
         *        Tags for the persistent application user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags for the persistent application user interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.emr.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.emr.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.emr.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The cross reference for the persistent application user interface.
         * </p>
         * 
         * @param xReferer
         *        The cross reference for the persistent application user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xReferer(String xReferer);

        /**
         * <p>
         * The profiler type for the persistent application user interface.
         * </p>
         * 
         * @param profilerType
         *        The profiler type for the persistent application user interface.
         * @see ProfilerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfilerType
         */
        Builder profilerType(String profilerType);

        /**
         * <p>
         * The profiler type for the persistent application user interface.
         * </p>
         * 
         * @param profilerType
         *        The profiler type for the persistent application user interface.
         * @see ProfilerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfilerType
         */
        Builder profilerType(ProfilerType profilerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String targetResourceArn;

        private EMRContainersConfig emrContainersConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String xReferer;

        private String profilerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentAppUiRequest model) {
            super(model);
            targetResourceArn(model.targetResourceArn);
            emrContainersConfig(model.emrContainersConfig);
            tags(model.tags);
            xReferer(model.xReferer);
            profilerType(model.profilerType);
        }

        public final String getTargetResourceArn() {
            return targetResourceArn;
        }

        public final void setTargetResourceArn(String targetResourceArn) {
            this.targetResourceArn = targetResourceArn;
        }

        @Override
        public final Builder targetResourceArn(String targetResourceArn) {
            this.targetResourceArn = targetResourceArn;
            return this;
        }

        public final EMRContainersConfig.Builder getEmrContainersConfig() {
            return emrContainersConfig != null ? emrContainersConfig.toBuilder() : null;
        }

        public final void setEmrContainersConfig(EMRContainersConfig.BuilderImpl emrContainersConfig) {
            this.emrContainersConfig = emrContainersConfig != null ? emrContainersConfig.build() : null;
        }

        @Override
        public final Builder emrContainersConfig(EMRContainersConfig emrContainersConfig) {
            this.emrContainersConfig = emrContainersConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getXReferer() {
            return xReferer;
        }

        public final void setXReferer(String xReferer) {
            this.xReferer = xReferer;
        }

        @Override
        public final Builder xReferer(String xReferer) {
            this.xReferer = xReferer;
            return this;
        }

        public final String getProfilerType() {
            return profilerType;
        }

        public final void setProfilerType(String profilerType) {
            this.profilerType = profilerType;
        }

        @Override
        public final Builder profilerType(String profilerType) {
            this.profilerType = profilerType;
            return this;
        }

        @Override
        public final Builder profilerType(ProfilerType profilerType) {
            this.profilerType(profilerType == null ? null : profilerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePersistentAppUiRequest build() {
            return new CreatePersistentAppUiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
