/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityConfigurationRequest extends EmrRequest implements
        ToCopyableBuilder<CreateSecurityConfigurationRequest.Builder, CreateSecurityConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSecurityConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(CreateSecurityConfigurationRequest::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SECURITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String securityConfiguration;

    private CreateSecurityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.securityConfiguration = builder.securityConfiguration;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The security configuration details in JSON format. For JSON parameters and examples, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
     * Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * 
     * @return The security configuration details in JSON format. For JSON parameters and examples, see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use
     *         Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityConfigurationRequest)) {
            return false;
        }
        CreateSecurityConfigurationRequest other = (CreateSecurityConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(securityConfiguration(), other.securityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSecurityConfigurationRequest").add("Name", name())
                .add("SecurityConfiguration", securityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSecurityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecurityConfigurationRequest> {
        /**
         * <p>
         * The name of the security configuration.
         * </p>
         * 
         * @param name
         *        The name of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The security configuration details in JSON format. For JSON parameters and examples, see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security
         * Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.
         * </p>
         * 
         * @param securityConfiguration
         *        The security configuration details in JSON format. For JSON parameters and examples, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use
         *        Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String name;

        private String securityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityConfigurationRequest model) {
            super(model);
            name(model.name);
            securityConfiguration(model.securityConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityConfigurationRequest build() {
            return new CreateSecurityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
