/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This output contains the description of the cluster step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStepResponse extends EmrResponse implements
        ToCopyableBuilder<DescribeStepResponse.Builder, DescribeStepResponse> {
    private static final SdkField<Step> STEP_FIELD = SdkField.<Step> builder(MarshallingType.SDK_POJO).memberName("Step")
            .getter(getter(DescribeStepResponse::step)).setter(setter(Builder::step)).constructor(Step::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Step").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Step step;

    private DescribeStepResponse(BuilderImpl builder) {
        super(builder);
        this.step = builder.step;
    }

    /**
     * <p>
     * The step details for the requested step identifier.
     * </p>
     * 
     * @return The step details for the requested step identifier.
     */
    public final Step step() {
        return step;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(step());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStepResponse)) {
            return false;
        }
        DescribeStepResponse other = (DescribeStepResponse) obj;
        return Objects.equals(step(), other.step());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStepResponse").add("Step", step()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Step":
            return Optional.ofNullable(clazz.cast(step()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Step", STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStepResponse, T> g) {
        return obj -> g.apply((DescribeStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStepResponse> {
        /**
         * <p>
         * The step details for the requested step identifier.
         * </p>
         * 
         * @param step
         *        The step details for the requested step identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder step(Step step);

        /**
         * <p>
         * The step details for the requested step identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link Step.Builder} avoiding the need to create
         * one manually via {@link Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Step.Builder#build()} is called immediately and its result is
         * passed to {@link #step(Step)}.
         * 
         * @param step
         *        a consumer that will call methods on {@link Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #step(Step)
         */
        default Builder step(Consumer<Step.Builder> step) {
            return step(Step.builder().applyMutation(step).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private Step step;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStepResponse model) {
            super(model);
            step(model.step);
        }

        public final Step.Builder getStep() {
            return step != null ? step.toBuilder() : null;
        }

        public final void setStep(Step.BuilderImpl step) {
            this.step = step != null ? step.build() : null;
        }

        @Override
        public final Builder step(Step step) {
            this.step = step;
            return this;
        }

        @Override
        public DescribeStepResponse build() {
            return new DescribeStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
