/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceFleetRequest extends EmrRequest implements
        ToCopyableBuilder<ModifyInstanceFleetRequest.Builder, ModifyInstanceFleetRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(ModifyInstanceFleetRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<InstanceFleetModifyConfig> INSTANCE_FLEET_FIELD = SdkField
            .<InstanceFleetModifyConfig> builder(MarshallingType.SDK_POJO).memberName("InstanceFleet")
            .getter(getter(ModifyInstanceFleetRequest::instanceFleet)).setter(setter(Builder::instanceFleet))
            .constructor(InstanceFleetModifyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_FLEET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final InstanceFleetModifyConfig instanceFleet;

    private ModifyInstanceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceFleet = builder.instanceFleet;
    }

    /**
     * <p>
     * The unique identifier of the cluster.
     * </p>
     * 
     * @return The unique identifier of the cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The configuration parameters of the instance fleet.
     * </p>
     * 
     * @return The configuration parameters of the instance fleet.
     */
    public final InstanceFleetModifyConfig instanceFleet() {
        return instanceFleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceFleetRequest)) {
            return false;
        }
        ModifyInstanceFleetRequest other = (ModifyInstanceFleetRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceFleet(), other.instanceFleet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceFleetRequest").add("ClusterId", clusterId()).add("InstanceFleet", instanceFleet())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceFleet":
            return Optional.ofNullable(clazz.cast(instanceFleet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("InstanceFleet", INSTANCE_FLEET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceFleetRequest, T> g) {
        return obj -> g.apply((ModifyInstanceFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceFleetRequest> {
        /**
         * <p>
         * The unique identifier of the cluster.
         * </p>
         * 
         * @param clusterId
         *        The unique identifier of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The configuration parameters of the instance fleet.
         * </p>
         * 
         * @param instanceFleet
         *        The configuration parameters of the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleet(InstanceFleetModifyConfig instanceFleet);

        /**
         * <p>
         * The configuration parameters of the instance fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceFleetModifyConfig.Builder}
         * avoiding the need to create one manually via {@link InstanceFleetModifyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceFleetModifyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceFleet(InstanceFleetModifyConfig)}.
         * 
         * @param instanceFleet
         *        a consumer that will call methods on {@link InstanceFleetModifyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceFleet(InstanceFleetModifyConfig)
         */
        default Builder instanceFleet(Consumer<InstanceFleetModifyConfig.Builder> instanceFleet) {
            return instanceFleet(InstanceFleetModifyConfig.builder().applyMutation(instanceFleet).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private InstanceFleetModifyConfig instanceFleet;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceFleetRequest model) {
            super(model);
            clusterId(model.clusterId);
            instanceFleet(model.instanceFleet);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final InstanceFleetModifyConfig.Builder getInstanceFleet() {
            return instanceFleet != null ? instanceFleet.toBuilder() : null;
        }

        public final void setInstanceFleet(InstanceFleetModifyConfig.BuilderImpl instanceFleet) {
            this.instanceFleet = instanceFleet != null ? instanceFleet.build() : null;
        }

        @Override
        public final Builder instanceFleet(InstanceFleetModifyConfig instanceFleet) {
            this.instanceFleet = instanceFleet;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceFleetRequest build() {
            return new ModifyInstanceFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
