/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains CloudWatch log configuration metadata and settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfiguration.Builder, MonitoringConfiguration> {
    private static final SdkField<CloudWatchLogConfiguration> CLOUD_WATCH_LOG_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogConfiguration")
            .getter(getter(MonitoringConfiguration::cloudWatchLogConfiguration))
            .setter(setter(Builder::cloudWatchLogConfiguration))
            .constructor(CloudWatchLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_WATCH_LOG_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogConfiguration cloudWatchLogConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.cloudWatchLogConfiguration = builder.cloudWatchLogConfiguration;
    }

    /**
     * <p>
     * CloudWatch log configuration settings and metadata that specify settings like log files to monitor and where to
     * send them.
     * </p>
     * 
     * @return CloudWatch log configuration settings and metadata that specify settings like log files to monitor and
     *         where to send them.
     */
    public final CloudWatchLogConfiguration cloudWatchLogConfiguration() {
        return cloudWatchLogConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration) obj;
        return Objects.equals(cloudWatchLogConfiguration(), other.cloudWatchLogConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfiguration").add("CloudWatchLogConfiguration", cloudWatchLogConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLogConfiguration", CLOUD_WATCH_LOG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfiguration> {
        /**
         * <p>
         * CloudWatch log configuration settings and metadata that specify settings like log files to monitor and where
         * to send them.
         * </p>
         * 
         * @param cloudWatchLogConfiguration
         *        CloudWatch log configuration settings and metadata that specify settings like log files to monitor and
         *        where to send them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogConfiguration(CloudWatchLogConfiguration cloudWatchLogConfiguration);

        /**
         * <p>
         * CloudWatch log configuration settings and metadata that specify settings like log files to monitor and where
         * to send them.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogConfiguration(CloudWatchLogConfiguration)}.
         * 
         * @param cloudWatchLogConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogConfiguration(CloudWatchLogConfiguration)
         */
        default Builder cloudWatchLogConfiguration(Consumer<CloudWatchLogConfiguration.Builder> cloudWatchLogConfiguration) {
            return cloudWatchLogConfiguration(CloudWatchLogConfiguration.builder().applyMutation(cloudWatchLogConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogConfiguration cloudWatchLogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            cloudWatchLogConfiguration(model.cloudWatchLogConfiguration);
        }

        public final CloudWatchLogConfiguration.Builder getCloudWatchLogConfiguration() {
            return cloudWatchLogConfiguration != null ? cloudWatchLogConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogConfiguration(CloudWatchLogConfiguration.BuilderImpl cloudWatchLogConfiguration) {
            this.cloudWatchLogConfiguration = cloudWatchLogConfiguration != null ? cloudWatchLogConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogConfiguration(CloudWatchLogConfiguration cloudWatchLogConfiguration) {
            this.cloudWatchLogConfiguration = cloudWatchLogConfiguration;
            return this;
        }

        @Override
        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
