/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the <a>RunJobFlow</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunJobFlowResponse extends EmrResponse implements
        ToCopyableBuilder<RunJobFlowResponse.Builder, RunJobFlowResponse> {
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFlowId").getter(getter(RunJobFlowResponse::jobFlowId)).setter(setter(Builder::jobFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(RunJobFlowResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_ID_FIELD,
            CLUSTER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobFlowId;

    private final String clusterArn;

    private RunJobFlowResponse(BuilderImpl builder) {
        super(builder);
        this.jobFlowId = builder.jobFlowId;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * <p>
     * A unique identifier for the job flow.
     * </p>
     * 
     * @return A unique identifier for the job flow.
     */
    public final String jobFlowId() {
        return jobFlowId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowResponse)) {
            return false;
        }
        RunJobFlowResponse other = (RunJobFlowResponse) obj;
        return Objects.equals(jobFlowId(), other.jobFlowId()) && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunJobFlowResponse").add("JobFlowId", jobFlowId()).add("ClusterArn", clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowId":
            return Optional.ofNullable(clazz.cast(jobFlowId()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobFlowId", JOB_FLOW_ID_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunJobFlowResponse, T> g) {
        return obj -> g.apply((RunJobFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, RunJobFlowResponse> {
        /**
         * <p>
         * A unique identifier for the job flow.
         * </p>
         * 
         * @param jobFlowId
         *        A unique identifier for the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowId(String jobFlowId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String jobFlowId;

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RunJobFlowResponse model) {
            super(model);
            jobFlowId(model.jobFlowId);
            clusterArn(model.clusterArn);
        }

        public final String getJobFlowId() {
            return jobFlowId;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        @Override
        public RunJobFlowResponse build() {
            return new RunJobFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
