/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for an Amazon EMR Studio, including ID, Name, VPC, and Description. To fetch additional details such as
 * subnets, IAM roles, security groups, and tags for the Studio, use the <a>DescribeStudio</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioSummary implements SdkPojo, Serializable, ToCopyableBuilder<StudioSummary.Builder, StudioSummary> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioId").getter(getter(StudioSummary::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StudioSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(StudioSummary::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StudioSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(StudioSummary::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMode").getter(getter(StudioSummary::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(StudioSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD, NAME_FIELD,
            VPC_ID_FIELD, DESCRIPTION_FIELD, URL_FIELD, AUTH_MODE_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String studioId;

    private final String name;

    private final String vpcId;

    private final String description;

    private final String url;

    private final String authMode;

    private final Instant creationTime;

    private StudioSummary(BuilderImpl builder) {
        this.studioId = builder.studioId;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
        this.description = builder.description;
        this.url = builder.url;
        this.authMode = builder.authMode;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio.
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * The name of the Amazon EMR Studio.
     * </p>
     * 
     * @return The name of the Amazon EMR Studio.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
     * </p>
     * 
     * @return The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The detailed description of the Amazon EMR Studio.
     * </p>
     * 
     * @return The detailed description of the Amazon EMR Studio.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique access URL of the Amazon EMR Studio.
     * </p>
     * 
     * @return The unique access URL of the Amazon EMR Studio.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     * @see AuthMode
     */
    public final AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
     * @see AuthMode
     */
    public final String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * The time when the Amazon EMR Studio was created.
     * </p>
     * 
     * @return The time when the Amazon EMR Studio was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioSummary)) {
            return false;
        }
        StudioSummary other = (StudioSummary) obj;
        return Objects.equals(studioId(), other.studioId()) && Objects.equals(name(), other.name())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(description(), other.description())
                && Objects.equals(url(), other.url()) && Objects.equals(authModeAsString(), other.authModeAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioSummary").add("StudioId", studioId()).add("Name", name()).add("VpcId", vpcId())
                .add("Description", description()).add("Url", url()).add("AuthMode", authModeAsString())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StudioId", STUDIO_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Url", URL_FIELD);
        map.put("AuthMode", AUTH_MODE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StudioSummary, T> g) {
        return obj -> g.apply((StudioSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioSummary> {
        /**
         * <p>
         * The ID of the Amazon EMR Studio.
         * </p>
         * 
         * @param studioId
         *        The ID of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * The name of the Amazon EMR Studio.
         * </p>
         * 
         * @param name
         *        The name of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The detailed description of the Amazon EMR Studio.
         * </p>
         * 
         * @param description
         *        The detailed description of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique access URL of the Amazon EMR Studio.
         * </p>
         * 
         * @param url
         *        The unique access URL of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using IAM or IAM Identity Center.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * The time when the Amazon EMR Studio was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the Amazon EMR Studio was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String studioId;

        private String name;

        private String vpcId;

        private String description;

        private String url;

        private String authMode;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioSummary model) {
            studioId(model.studioId);
            name(model.name);
            vpcId(model.vpcId);
            description(model.description);
            url(model.url);
            authMode(model.authMode);
            creationTime(model.creationTime);
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getAuthMode() {
            return authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public StudioSummary build() {
            return new StudioSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
